/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.bigquery.ui.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.bigquery.ui.BigQueryActivator;
import org.jkiss.dbeaver.ext.bigquery.ui.internal.BigQueryMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class BigQueryConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private static final Log log = Log.getLog(BigQueryConnectionPage.class);
    private Text projectText;
    private Text extraProjectsText;
    private Text usernameText;
    private Combo authTypeCombo;
    private TextWithOpenFile authCertFile;
    private Text hostText;
    private Text portText;
    private static ImageDescriptor logoImage = BigQueryActivator.getImageDescriptor("icons/bigquery_logo.png");
    private DriverPropertiesDialogPage driverPropsPage = new DriverPropertiesDialogPage((ConnectionPageAbstract)this);

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        settingsGroup.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Group addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)BigQueryMessages.label_connection, (int)2, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        this.projectText = UIUtils.createLabelText((Composite)addrGroup, (String)BigQueryMessages.label_project, (String)"");
        this.projectText.addModifyListener(textListener);
        this.extraProjectsText = UIUtils.createLabelText((Composite)addrGroup, (String)BigQueryMessages.label_additional_project, (String)"");
        this.extraProjectsText.setToolTipText("Coma-separated list of projects (optional)");
        this.extraProjectsText.addModifyListener(textListener);
        addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)BigQueryMessages.label_security, (int)4, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        this.usernameText = UIUtils.createLabelText((Composite)addrGroup, (String)BigQueryMessages.label_service_account, (String)"");
        this.usernameText.setToolTipText("Google account email address. Can be left empty if auth type is service based and key file contains all user info (JSON).");
        this.usernameText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)BigQueryMessages.label_oauth_type);
        this.authTypeCombo = new Combo((Composite)addrGroup, 2060);
        this.authTypeCombo.add(BigQueryMessages.label_service_based);
        this.authTypeCombo.add(BigQueryMessages.label_user_based);
        GridData gd = new GridData(32);
        this.authTypeCombo.setLayoutData((Object)gd);
        this.authTypeCombo.addModifyListener(textListener);
        this.authTypeCombo.select(0);
        UIUtils.createControlLabel((Composite)addrGroup, (String)BigQueryMessages.label_key_path);
        this.authCertFile = new TextWithOpenFile((Composite)addrGroup, BigQueryMessages.label_private_key_path, new String[]{"*", "*.p12", "*.json"});
        gd = new GridData(800);
        gd.horizontalSpan = 3;
        this.authCertFile.setLayoutData((Object)gd);
        addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)BigQueryMessages.label_server_info, (int)4, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        this.hostText = UIUtils.createLabelText((Composite)addrGroup, (String)BigQueryMessages.label_host, (String)"https://www.googleapis.com/bigquery/v2");
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)addrGroup, (String)BigQueryMessages.label_port, (String)String.valueOf(433));
        gd = (GridData)this.portText.getLayoutData();
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    public boolean isComplete() {
        return this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && this.portText != null && !CommonUtils.isEmpty((String)this.portText.getText()) && this.projectText != null && !CommonUtils.isEmpty((String)this.projectText.getText()) && this.usernameText != null && !CommonUtils.isEmpty((String)this.usernameText.getText());
    }

    public void loadSettings() {
        String keyPath;
        String additionalProjects;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.projectText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                databaseName = "";
            }
            this.projectText.setText(databaseName);
        }
        if ((additionalProjects = connectionInfo.getProperty("AdditionalProjects")) != null) {
            this.extraProjectsText.setText(additionalProjects);
        }
        if (this.usernameText != null) {
            this.usernameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.authTypeCombo != null) {
            this.authTypeCombo.select(CommonUtils.toInt((Object)connectionInfo.getProperty("OAuthType")));
        }
        if ((keyPath = connectionInfo.getProperty("OAuthPvtKeyPath")) != null && this.authCertFile != null) {
            this.authCertFile.setText(keyPath);
        }
        if (this.hostText != null) {
            if (CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText("https://www.googleapis.com/bigquery/v2");
            } else {
                this.hostText.setText(connectionInfo.getHostName());
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.projectText != null) {
            connectionInfo.setDatabaseName(this.projectText.getText().trim());
        }
        if (this.extraProjectsText != null) {
            connectionInfo.setProperty("AdditionalProjects", this.extraProjectsText.getText().trim());
        }
        if (this.usernameText != null) {
            connectionInfo.setUserName(this.usernameText.getText().trim());
        }
        if (this.authTypeCombo != null) {
            connectionInfo.setProperty("OAuthType", String.valueOf(this.authTypeCombo.getSelectionIndex()));
        }
        if (this.authCertFile != null) {
            connectionInfo.setProperty("OAuthPvtKeyPath", this.authCertFile.getText());
        }
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getSubPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{this.driverPropsPage};
    }
}

