/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.IWorkbenchWindowInitializer;

public class WorkbenchHandlerRegistry {
    private static final Log log = Log.getLog(WorkbenchHandlerRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.workbenchHandler";
    public static final String WORKBENCH_WINDOW_INITIALIZER = "workbenchWindowInitializer";
    private static WorkbenchHandlerRegistry instance = null;
    private final List<IWorkbenchWindowInitializer> wwInitializers = new ArrayList<IWorkbenchWindowInitializer>();

    public static synchronized WorkbenchHandlerRegistry getInstance() {
        if (instance == null) {
            instance = new WorkbenchHandlerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private WorkbenchHandlerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (ext.getName().equals(WORKBENCH_WINDOW_INITIALIZER)) {
                HandlerDescriptor handlerDescriptor = new HandlerDescriptor(ext);
                try {
                    IWorkbenchWindowInitializer wwInit = (IWorkbenchWindowInitializer)handlerDescriptor.type.createInstance(IWorkbenchWindowInitializer.class);
                    this.wwInitializers.add(wwInit);
                }
                catch (DBException e) {
                    log.error((Object)"Can't create workbench window initializer", (Throwable)e);
                }
            }
            ++n2;
        }
    }

    public List<IWorkbenchWindowInitializer> getWorkbenchWindowInitializers() {
        return this.wwInitializers;
    }

    private class HandlerDescriptor
    extends AbstractDescriptor {
        private final AbstractDescriptor.ObjectType type;

        protected HandlerDescriptor(IConfigurationElement config) {
            super(config);
            this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        }
    }
}

