/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.sql.SQLToolTaskConfigurationWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.utils.CommonUtils;

class SQLToolTaskPageSettings
extends ActiveWizardPage<SQLToolTaskConfigurationWizard> {
    private static final Log log = Log.getLog(SQLToolTaskPageSettings.class);
    private SQLToolTaskConfigurationWizard sqlWizard;
    private Button ignoreErrorsCheck;
    private Button dumpQueryCheck;
    private Button autoCommitCheck;
    private TableViewer scriptsViewer;
    private TableViewer dataSourceViewer;
    private List<DBNResource> selectedScripts = new ArrayList<DBNResource>();
    private List<DBNDataSource> selectedDataSources = new ArrayList<DBNDataSource>();

    SQLToolTaskPageSettings(SQLToolTaskConfigurationWizard wizard) {
        super("Tool parameters");
        this.setTitle("Tool parameters");
        this.setDescription("Parameters for database tool");
        this.sqlWizard = wizard;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
    }

    private void refreshScripts() {
        this.scriptsViewer.refresh(true, true);
        this.updateSelectedScripts();
    }

    private void refreshDataSources() {
        this.dataSourceViewer.refresh(true, true);
    }

    private void updateSelectedScripts() {
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(this.sqlWizard.getProject());
        LinkedHashSet dataSources = new LinkedHashSet();
        for (DBNResource element : this.selectedScripts) {
            Collection resDS = element.getAssociatedDataSources();
            if (CommonUtils.isEmpty((Collection)resDS)) continue;
            dataSources.addAll(resDS);
        }
        if (!dataSources.isEmpty()) {
            ArrayList<DBNDataSource> checkedDataSources = new ArrayList<DBNDataSource>();
            for (DBPDataSourceContainer ds : dataSources) {
                DBNDataSource dsNode = projectNode.getDatabases().getDataSource(ds);
                if (dsNode == null) continue;
                checkedDataSources.add(dsNode);
            }
            if (!checkedDataSources.isEmpty()) {
                this.refreshDataSources();
                for (DBNDataSource dsNode : checkedDataSources) {
                    if (this.selectedDataSources.contains(dsNode)) continue;
                    this.selectedDataSources.add(dsNode);
                }
            }
        }
        this.refreshDataSources();
        this.updatePageCompletion();
    }

    public void activatePage() {
        this.updatePageCompletion();
    }

    public void deactivatePage() {
    }

    protected boolean determinePageCompletion() {
        if (this.selectedScripts.isEmpty()) {
            this.setErrorMessage("You must select script(s) to execute");
            return false;
        }
        if (this.selectedDataSources.isEmpty()) {
            this.setErrorMessage("You must select connection(s)");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

