/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class AbstractContextDescriptor
extends AbstractDescriptor {
    private static final String OBJECT_TYPE = "objectType";
    private final AbstractDescriptor.ObjectType[] objectTypes;

    public AbstractContextDescriptor(IConfigurationElement config) {
        super(config.getContributor().getName());
        ArrayList<AbstractDescriptor.ObjectType> objectTypes = new ArrayList<AbstractDescriptor.ObjectType>();
        String objectType = config.getAttribute(OBJECT_TYPE);
        if (objectType != null) {
            objectTypes.add(new AbstractDescriptor.ObjectType((AbstractDescriptor)this, objectType));
        }
        IConfigurationElement[] iConfigurationElementArray = config.getChildren(OBJECT_TYPE);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement typeCfg = iConfigurationElementArray[n2];
            objectTypes.add(new AbstractDescriptor.ObjectType((AbstractDescriptor)this, typeCfg));
            ++n2;
        }
        this.objectTypes = objectTypes.toArray(new AbstractDescriptor.ObjectType[0]);
    }

    public AbstractContextDescriptor(String pluginId) {
        super(pluginId);
        this.objectTypes = new AbstractDescriptor.ObjectType[0];
    }

    public boolean hasObjectTypes() {
        return this.objectTypes.length > 0;
    }

    public AbstractDescriptor.ObjectType[] getObjectTypes() {
        return this.objectTypes;
    }

    public boolean appliesTo(DBPObject object) {
        return this.appliesTo(object, null);
    }

    public boolean appliesTo(DBPObject object, Object context) {
        if (object instanceof DBSObject) {
            object = DBUtils.getPublicObject((DBSObject)object);
        }
        if (object == null) {
            return false;
        }
        Object adapted = this.adaptType(object);
        AbstractDescriptor.ObjectType[] objectTypeArray = this.objectTypes;
        int n = this.objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDescriptor.ObjectType objectType = objectTypeArray[n2];
            if (objectType.appliesTo(object, context) || adapted != null && objectType.appliesTo(adapted, context)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Object adaptType(DBPObject object) {
        return null;
    }
}

