/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.data.TemporalAccessorValueHandler;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCTemporalAccessorValueHandler
extends TemporalAccessorValueHandler {
    public static final DateTimeFormatter DEFAULT_DATE_FORMAT = DateTimeFormatter.ofPattern("''yyyy-MM-dd''");
    public static final DateTimeFormatter DEFAULT_TIME_FORMAT = DateTimeFormatter.ofPattern("''HH:mm:ss''");
    public static final DateTimeFormatter DEFAULT_TIME_TZ_FORMAT = DateTimeFormatter.ofPattern("''HH:mm:ss Z''");
    public static final DateTimeFormatter DEFAULT_TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("''yyyy-MM-dd HH:mm:ss.SSS''");
    public static final DateTimeFormatter DEFAULT_TIMESTAMP_TZ_FORMAT = DateTimeFormatter.ofPattern("''yyyy-MM-dd HH:mm:ss.SSS'Z'''");

    public JDBCTemporalAccessorValueHandler(DBDDataFormatterProfile formatterProfile) {
        super(formatterProfile);
    }

    @Override
    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        try {
            if (resultSet instanceof JDBCResultSet) {
                JDBCResultSet dbResults = (JDBCResultSet)resultSet;
                if (this.isZonedType(type)) {
                    return dbResults.getObject(index + 1, ZonedDateTime.class);
                }
                return dbResults.getObject(index + 1, LocalDateTime.class);
            }
            return resultSet.getAttributeValue(index);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @Override
    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
        try {
            JDBCPreparedStatement dbStat = (JDBCPreparedStatement)statement;
            if (value == null) {
                dbStat.setNull(index + 1, type.getTypeID());
            } else if (value instanceof TemporalAccessor) {
                dbStat.setObject(index + 1, value);
            }
        }
        catch (SQLException e) {
            throw new DBCException(ModelMessages.model_jdbc_exception_could_not_bind_statement_parameter, e);
        }
    }

    @Override
    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        DateTimeFormatter nativeFormat;
        if (value instanceof TemporalAccessor && format == DBDDisplayFormat.NATIVE && (nativeFormat = this.getNativeValueFormat(column)) != null) {
            try {
                return nativeFormat.format((TemporalAccessor)value);
            }
            catch (Exception e) {
                log.error("Error formatting date", e);
            }
        }
        return super.getValueDisplayString(column, value, format);
    }

    @Nullable
    protected DateTimeFormatter getNativeValueFormat(DBSTypedObject type) {
        switch (type.getTypeID()) {
            case 93: {
                return DEFAULT_TIMESTAMP_FORMAT;
            }
            case 2014: {
                return DEFAULT_TIMESTAMP_TZ_FORMAT;
            }
            case 92: {
                return DEFAULT_TIME_FORMAT;
            }
            case 2013: {
                return DEFAULT_TIME_TZ_FORMAT;
            }
            case 91: {
                return DEFAULT_DATE_FORMAT;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected String getFormatterId(DBSTypedObject column) {
        switch (column.getTypeID()) {
            case 92: 
            case 2013: {
                return "time";
            }
            case 91: {
                return "date";
            }
        }
        return "timestamp";
    }

    @Override
    protected boolean isZonedType(DBSTypedObject type) {
        switch (type.getTypeID()) {
            case 2013: 
            case 2014: {
                return true;
            }
        }
        return false;
    }
}

