/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PropertySourceCustom
implements DBPPropertySource {
    private List<DBPPropertyDescriptor> props = new ArrayList<DBPPropertyDescriptor>();
    private Map<Object, Object> originalValues = new TreeMap<Object, Object>();
    private Map<Object, Object> propValues = new TreeMap<Object, Object>();
    private Map<Object, Object> defaultValues = new TreeMap<Object, Object>();
    private IVariableResolver defValueResolver = null;

    public PropertySourceCustom() {
    }

    public PropertySourceCustom(Collection<? extends DBPPropertyDescriptor> properties, Map<?, ?> values) {
        this.addProperties(properties);
        this.setValues(values);
    }

    public PropertySourceCustom(DBPPropertyDescriptor[] properties, Map<?, ?> values) {
        this.addProperties(properties);
        this.setValues(values);
    }

    public void setDefValueResolver(IVariableResolver defValueResolver) {
        this.defValueResolver = defValueResolver;
    }

    public void setValues(Map<?, ?> values) {
        this.originalValues = new HashMap<Object, Object>();
        if (values != null) {
            block0: for (Map.Entry<?, ?> value : values.entrySet()) {
                Object propValue = value.getValue();
                for (DBPPropertyDescriptor prop : this.props) {
                    if (!prop.getId().equals(value.getKey())) continue;
                    if (propValue instanceof String) {
                        propValue = GeneralUtils.convertString((String)value.getValue(), prop.getDataType());
                    }
                    this.originalValues.put(value.getKey(), propValue);
                    continue block0;
                }
            }
        }
    }

    public void setDefaultValues(Map<Object, Object> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public void addDefaultValues(Map<?, ?> defaultValues) {
        this.defaultValues.putAll(defaultValues);
    }

    public Map<Object, Object> getProperties() {
        HashMap<Object, Object> allValues = new HashMap<Object, Object>(this.originalValues);
        allValues.putAll(this.propValues);
        return allValues;
    }

    public Map<Object, Object> getPropertiesWithDefaults() {
        HashMap<Object, Object> allValues = new HashMap<Object, Object>(this.defaultValues);
        allValues.putAll(this.originalValues);
        allValues.putAll(this.propValues);
        if (this.defValueResolver != null) {
            for (Map.Entry entry : allValues.entrySet()) {
                entry.setValue(this.getDefaultValue(entry.getValue()));
            }
        }
        return allValues;
    }

    public void addProperty(DBPPropertyDescriptor property) {
        this.props.add(property);
        Object defaultValue = property.getDefaultValue();
        if (defaultValue != null) {
            this.defaultValues.put(property.getId(), defaultValue);
        }
    }

    public void addProperties(Collection<? extends DBPPropertyDescriptor> properties) {
        this.props.addAll(properties);
        for (DBPPropertyDescriptor dBPPropertyDescriptor : properties) {
            Object defaultValue = dBPPropertyDescriptor.getDefaultValue();
            if (defaultValue == null) continue;
            this.defaultValues.put(dBPPropertyDescriptor.getId(), defaultValue);
        }
    }

    public void addProperties(DBPPropertyDescriptor[] properties) {
        Collections.addAll(this.props, properties);
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            Object defaultValue = prop.getDefaultValue();
            if (defaultValue != null) {
                this.defaultValues.put(prop.getId(), defaultValue);
            }
            ++n2;
        }
    }

    private Object getDefaultValue(Object defaultValue) {
        if (this.defValueResolver != null && defaultValue instanceof String) {
            return GeneralUtils.replaceVariables((String)defaultValue, this.defValueResolver);
        }
        return defaultValue;
    }

    @Override
    public Object getEditableValue() {
        return this;
    }

    @Override
    public DBPPropertyDescriptor[] getPropertyDescriptors2() {
        return this.props.toArray(new DBPPropertyDescriptor[0]);
    }

    @Override
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
        if (id == null) {
            return null;
        }
        Object value = this.propValues.get(id);
        if (value == null) {
            value = this.originalValues.get(id);
        }
        if (value == null) {
            value = this.defaultValues.get(id);
        }
        return value != null ? this.getDefaultValue(value) : null;
    }

    @Override
    public boolean isPropertyResettable(Object id) {
        return true;
    }

    @Override
    public boolean isPropertySet(Object id) {
        Object value = this.getPropertyValue(null, id);
        if (value == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(this.defaultValues.get(id));
        return !CommonUtils.equalObjects((Object)this.getDefaultValue(value), (Object)defaultValue);
    }

    @Override
    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
        this.propValues.remove(id);
    }

    @Override
    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, Object id, Object value) {
        if (!this.originalValues.containsKey(id)) {
            if (this.propValues.containsKey(id)) {
                this.originalValues.put(id, this.propValues.get(id));
            } else if (this.defaultValues.containsKey(id)) {
                this.originalValues.put(id, this.defaultValues.get(id));
            } else {
                this.originalValues.put(id, null);
            }
        }
        if (value == null || value.equals(this.originalValues.get(id))) {
            this.propValues.remove(id);
        } else {
            this.propValues.put(id, value);
        }
    }

    @Override
    public boolean isDirty(Object id) {
        return !this.propValues.isEmpty();
    }

    @Override
    public void resetPropertyValueToDefault(Object id) {
        this.propValues.remove(id);
        this.originalValues.remove(id);
    }

    public void removeAll() {
        this.props.clear();
        this.originalValues.clear();
        this.propValues.clear();
        this.defaultValues.clear();
    }
}

