/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;

public class DataExporterDbUnit
extends StreamExporterAbstract {
    private static final String PROP_UPPER_CASE_TABLE_NAME = "upperCaseTableName";
    private static final String PROP_NULL_VALUE_STRING = "nullValueString";
    private static final String PROP_UPPER_CASE_COLUMN_NAMES = "upperCaseColumnNames";
    private static final String PROP_INCLUDE_NULL_VALUES = "includeNullValues";
    private DBDAttributeBinding[] columns;
    private String tableName;
    private boolean upperCaseTableName;
    private boolean upperCaseColumnNames;
    private boolean includeNullValues;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        this.upperCaseTableName = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_UPPER_CASE_TABLE_NAME), (boolean)true);
        this.upperCaseColumnNames = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_UPPER_CASE_COLUMN_NAMES), (boolean)true);
        this.includeNullValues = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_INCLUDE_NULL_VALUES), (boolean)true);
    }

    @Override
    public void dispose() {
        this.tableName = null;
        this.columns = null;
        super.dispose();
    }

    private String getTableName() {
        String result = "UNKNOWN_TABLE_NAME";
        if (this.getSite() == null || this.getSite().getAttributes() == null || this.getSite().getAttributes().length == 0) {
            return result;
        }
        DBCAttributeMetaData metaAttribute = this.getSite().getAttributes()[0].getMetaAttribute();
        if (metaAttribute != null && metaAttribute instanceof JDBCColumnMetaData) {
            JDBCColumnMetaData metaData = (JDBCColumnMetaData)metaAttribute;
            result = metaData.getEntityName();
        }
        if (this.upperCaseTableName) {
            result = result == null ? null : result.toUpperCase();
        }
        return result;
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        PrintWriter out = this.getWriter();
        this.columns = this.getSite().getAttributes();
        this.tableName = this.getTableName();
        String outputEncoding = this.getSite().getOutputEncoding();
        out.append("<?xml version=\"1.0\" encoding=\"").append(outputEncoding).append("\"?>").append(CommonUtils.getLineSeparator());
        out.append("<dataset>").append(CommonUtils.getLineSeparator());
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        PrintWriter out = this.getWriter();
        out.write("    <" + this.tableName);
        int i = 0;
        while (i < row.length) {
            if (!DBUtils.isNullValue((Object)row[i]) || this.includeNullValues) {
                block48: {
                    DBDAttributeBinding column = this.columns[i];
                    String columnName = this.escapeXmlElementName(column.getName());
                    if (columnName != null && this.upperCaseColumnNames) {
                        columnName = columnName.toUpperCase();
                    }
                    out.write(" " + columnName + "=\"");
                    Object columnValue = row[i];
                    if (DBUtils.isNullValue((Object)columnValue)) {
                        this.writeTextCell("" + this.getSite().getProperties().get(PROP_NULL_VALUE_STRING));
                    } else if (columnValue instanceof Float || columnValue instanceof Double || columnValue instanceof BigDecimal) {
                        int scale = column.getMetaAttribute().getScale() != null && column.getMetaAttribute().getScale() > 0 ? column.getMetaAttribute().getScale() : 1;
                        try {
                            out.write(String.format(Locale.ROOT, "%." + scale + "f", columnValue));
                        }
                        catch (Exception exception) {
                            out.write(columnValue.toString());
                        }
                    } else if (columnValue instanceof Boolean) {
                        out.write(columnValue.toString());
                    } else if (columnValue instanceof Number) {
                        out.write(columnValue.toString());
                    } else if (columnValue instanceof Timestamp) {
                        try {
                            int nanoseconds = ((Timestamp)columnValue).getNanos();
                            out.write(String.format(Locale.ROOT, "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%2$d", columnValue, nanoseconds));
                        }
                        catch (Exception exception) {
                            out.write(columnValue.toString());
                        }
                    } else if (columnValue instanceof Time) {
                        try {
                            out.write(String.format(Locale.ROOT, "%1$tH:%1$tM:%1$tS", columnValue));
                        }
                        catch (Exception exception) {
                            out.write(columnValue.toString());
                        }
                    } else if (columnValue instanceof Date) {
                        try {
                            out.write(String.format(Locale.ROOT, "%1$tY-%1$tm-%1$td", columnValue));
                        }
                        catch (Exception exception) {
                            out.write(columnValue.toString());
                        }
                    } else {
                        if (columnValue instanceof DBDContent) {
                            DBDContent content = (DBDContent)columnValue;
                            try {
                                Object var12_15;
                                Throwable throwable;
                                DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                                if (cs == null) break block48;
                                if (ContentUtils.isTextContent((DBDContent)content)) {
                                    throwable = null;
                                    var12_15 = null;
                                    try (Reader reader = cs.getContentReader();){
                                        this.writeCellValue(reader);
                                        break block48;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                throwable = null;
                                var12_15 = null;
                                try (InputStream stream = cs.getContentStream();){
                                    Base64.encode((InputStream)stream, (long)cs.getContentLength(), (Writer)this.getSite().getWriter());
                                    break block48;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                            }
                            finally {
                                content.release();
                            }
                        }
                        this.writeTextCell(super.getValueDisplayString(column, columnValue));
                    }
                }
                out.write("\"");
            }
            ++i;
        }
        out.write("/>" + CommonUtils.getLineSeparator());
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) {
        this.getWriter().write("</dataset>\n");
    }

    private void writeTextCell(@Nullable String value) {
        if (value != null) {
            value = value.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
            this.getWriter().write(value);
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        int count;
        PrintWriter out = this.getWriter();
        char[] buffer = new char[2000];
        while ((count = reader.read(buffer)) > 0) {
            int i = 0;
            while (i < count) {
                if (buffer[i] == '<') {
                    out.write("&lt;");
                } else if (buffer[i] == '>') {
                    out.write("&gt;");
                } else if (buffer[i] == '&') {
                    out.write("&amp;");
                } else {
                    out.write(buffer[i]);
                }
                ++i;
            }
        }
    }

    private String escapeXmlElementName(String name) {
        return name.replaceAll("[^\\p{Alpha}\\p{Digit}]+", "_");
    }
}

