/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.importer;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.importer.StreamImporterAbstract;
import org.jkiss.dbeaver.tools.transfer.stream.model.StreamDataSource;
import org.jkiss.dbeaver.tools.transfer.stream.model.StreamExecutionContext;
import org.jkiss.dbeaver.tools.transfer.stream.model.StreamTransferSession;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataImporterCSV
extends StreamImporterAbstract {
    private static final Log log = Log.getLog(DataImporterCSV.class);
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_HEADER = "header";
    private static final String PROP_DELIMITER = "delimiter";
    private static final String PROP_QUOTE_CHAR = "quoteChar";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_EMPTY_STRING_NULL = "emptyStringNull";
    private static final String PROP_ESCAPE_CHAR = "escapeChar";
    private static final String PROP_TIMESTAMP_FORMAT = "timestampFormat";

    @Override
    public List<StreamDataImporterColumnInfo> readColumnsInfo(InputStream inputStream) throws DBException {
        ArrayList<StreamDataImporterColumnInfo> columnsInfo;
        block23: {
            columnsInfo = new ArrayList<StreamDataImporterColumnInfo>();
            Map<Object, Object> processorProperties = this.getSite().getProcessorProperties();
            HeaderPosition headerPosition = this.getHeaderPosition(processorProperties);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStreamReader reader = this.openStreamReader(inputStream, processorProperties);){
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (CSVReader csvReader = this.openCSVReader(reader, processorProperties);){
                        String[] line;
                        do {
                            if ((line = csvReader.readNext()) != null) continue;
                            break block23;
                        } while (line.length == 0);
                        int i = 0;
                        while (i < line.length) {
                            String column = line[i];
                            if (headerPosition == HeaderPosition.none) {
                                column = null;
                            }
                            columnsInfo.add(new StreamDataImporterColumnInfo(i, column));
                            ++i;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new DBException("IO error reading CSV", (Throwable)e);
            }
        }
        return columnsInfo;
    }

    private HeaderPosition getHeaderPosition(Map<Object, Object> processorProperties) {
        return (HeaderPosition)CommonUtils.valueOf(HeaderPosition.class, (String)CommonUtils.toString((Object)processorProperties.get(PROP_HEADER)), (Enum)HeaderPosition.top);
    }

    private CSVReader openCSVReader(Reader reader, Map<Object, Object> processorProperties) {
        String escapeChar;
        String delimiter = StreamTransferUtils.getDelimiterString(processorProperties, PROP_DELIMITER);
        String quoteChar = CommonUtils.toString((Object)processorProperties.get(PROP_QUOTE_CHAR));
        if (CommonUtils.isEmpty((String)quoteChar)) {
            quoteChar = "'";
        }
        if (CommonUtils.isEmpty((String)(escapeChar = CommonUtils.toString((Object)processorProperties.get(PROP_ESCAPE_CHAR))))) {
            escapeChar = "\\";
        }
        return new CSVReader(reader, delimiter.charAt(0), quoteChar.charAt(0), escapeChar.charAt(0));
    }

    private InputStreamReader openStreamReader(InputStream inputStream, Map<Object, Object> processorProperties) throws UnsupportedEncodingException {
        String encoding = CommonUtils.toString((Object)processorProperties.get(PROP_ENCODING), (String)GeneralUtils.UTF8_ENCODING);
        return new InputStreamReader(inputStream, encoding);
    }

    @Override
    public void runImport(DBRProgressMonitor monitor, InputStream inputStream, IDataTransferConsumer consumer) throws DBException {
        IStreamDataImporterSite site = this.getSite();
        StreamProducerSettings.EntityMapping entityMapping = site.getSettings().getEntityMapping(site.getSourceObject());
        Map<Object, Object> properties = site.getProcessorProperties();
        HeaderPosition headerPosition = this.getHeaderPosition(properties);
        boolean emptyStringNull = CommonUtils.getBoolean((Object)properties.get(PROP_EMPTY_STRING_NULL), (boolean)false);
        String nullValueMark = CommonUtils.toString((Object)properties.get(PROP_NULL_STRING));
        DateTimeFormatter tsFormat = null;
        String tsFormatPattern = CommonUtils.toString((Object)properties.get(PROP_TIMESTAMP_FORMAT));
        if (!CommonUtils.isEmpty((String)tsFormatPattern)) {
            try {
                tsFormat = DateTimeFormatter.ofPattern(tsFormatPattern);
            }
            catch (Exception e) {
                log.error((Object)("Wrong timestamp format: " + tsFormatPattern), (Throwable)e);
            }
        }
        StreamDataSource streamDataSource = new StreamDataSource("Transfer stream");
        Throwable throwable = null;
        Object var14_16 = null;
        try (StreamExecutionContext context = streamDataSource.openIsolatedContext(monitor, "Transfer stream data", null);){
            Throwable throwable2 = null;
            Object var17_21 = null;
            try (StreamTransferSession producerSession = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Transfer stream data");){
                LocalStatement localStatement = new LocalStatement((DBCSession)producerSession, "SELECT * FROM Stream");
                StreamTransferResultSet resultSet = new StreamTransferResultSet(producerSession, (DBCStatement)localStatement, entityMapping);
                if (tsFormat != null) {
                    resultSet.setDateTimeFormat(tsFormat);
                }
                consumer.fetchStart((DBCSession)producerSession, resultSet, -1L, -1L);
                try {
                    try {
                        Throwable throwable3 = null;
                        Object var22_29 = null;
                        try (InputStreamReader reader = this.openStreamReader(inputStream, properties);){
                            Throwable throwable4 = null;
                            Object var25_34 = null;
                            try (CSVReader csvReader = this.openCSVReader(reader, properties);){
                                Object[] line;
                                int maxRows = site.getSettings().getMaxRows();
                                int targetAttrSize = entityMapping.getStreamColumns().size();
                                boolean headerRead = false;
                                int lineNum = 0;
                                while ((line = csvReader.readNext()) != null) {
                                    if (line.length == 0) continue;
                                    if (headerPosition != HeaderPosition.none && !headerRead) {
                                        headerRead = true;
                                        continue;
                                    }
                                    if (maxRows > 0 && lineNum >= maxRows) {
                                        break;
                                    }
                                    if (line.length < targetAttrSize) {
                                        String[] newLine = new String[targetAttrSize];
                                        System.arraycopy(line, 0, newLine, 0, line.length);
                                        int i = line.length;
                                        while (i < targetAttrSize - line.length) {
                                            newLine[i] = null;
                                            ++i;
                                        }
                                        line = newLine;
                                    }
                                    if (emptyStringNull) {
                                        int i = 0;
                                        while (i < line.length) {
                                            if ("".equals(line[i])) {
                                                line[i] = null;
                                            }
                                            ++i;
                                        }
                                    }
                                    if (!CommonUtils.isEmpty((String)nullValueMark)) {
                                        int i = 0;
                                        while (i < line.length) {
                                            if (nullValueMark.equals(line[i])) {
                                                line[i] = null;
                                            }
                                            ++i;
                                        }
                                    }
                                    resultSet.setStreamRow(line);
                                    consumer.fetchRow((DBCSession)producerSession, resultSet);
                                    ++lineNum;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable4 == null) {
                                    throwable4 = throwable5;
                                } else if (throwable4 != throwable5) {
                                    throwable4.addSuppressed(throwable5);
                                }
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable3 == null) {
                                throwable3 = throwable6;
                            } else if (throwable3 != throwable6) {
                                throwable3.addSuppressed(throwable6);
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        throw new DBException("IO error reading CSV", (Throwable)e);
                    }
                }
                finally {
                    try {
                        consumer.fetchEnd((DBCSession)producerSession, resultSet);
                    }
                    finally {
                        consumer.close();
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable2 == null) {
                    throwable2 = throwable7;
                } else if (throwable2 != throwable7) {
                    throwable2.addSuppressed(throwable7);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
            } else if (throwable != throwable8) {
                throwable.addSuppressed(throwable8);
            }
            throw throwable;
        }
    }

    static enum HeaderPosition {
        none,
        top,
        both;

    }
}

