/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.tipoftheday;

import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.ext.ui.tipoftheday.ShowTipOfTheDayHandler;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IWorkbenchWindowInitializer;
import org.jkiss.utils.CommonUtils;

public class TipOfTheDayInitializer
implements IWorkbenchWindowInitializer {
    public void initializeWorkbenchWindow(IWorkbenchWindow window) {
        if (!TipOfTheDayInitializer.isTipsEnabled() || window.getWorkbench().getWorkbenchWindowCount() > 1) {
            return;
        }
        ShowTipOfTheDayHandler.showTipOfTheDay(window);
    }

    private static boolean isTipsEnabled() {
        if (DataSourceRegistry.getAllDataSources().isEmpty()) {
            return false;
        }
        String tipsEnabledStr = DBWorkbench.getPlatform().getPreferenceStore().getString("ui.show.tip.of.the.day.on.startup");
        if (CommonUtils.isEmpty((String)tipsEnabledStr)) {
            return true;
        }
        return CommonUtils.toBoolean((Object)tipsEnabledStr);
    }
}

