/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DBPositiveNumberTransformer
implements IPropertyValueTransformer<DBSObject, Number> {
    @Override
    public Number transform(DBSObject object, Number value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double && value.doubleValue() <= 0.0) {
            return null;
        }
        if (value instanceof Float && (double)value.floatValue() <= 0.0) {
            return null;
        }
        if (value.longValue() <= 0L) {
            return null;
        }
        return value;
    }
}

