/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandAggregator;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.edit.DBEStructEditor;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public abstract class SQLStructEditor<OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBSObject>
extends SQLObjectEditor<OBJECT_TYPE, CONTAINER_TYPE>
implements DBEStructEditor<OBJECT_TYPE> {
    protected abstract void addStructObjectCreateActions(DBRProgressMonitor var1, DBCExecutionContext var2, List<DBEPersistAction> var3, StructCreateCommand var4, Map<String, Object> var5) throws DBException;

    @Override
    public StructCreateCommand makeCreateCommand(OBJECT_TYPE object, Map<String, Object> options) {
        return new StructCreateCommand(this, object, ModelMessages.model_jdbc_create_new_object, options);
    }

    protected Collection<SQLObjectEditor.NestedObjectCommand> getNestedOrderedCommands(StructCreateCommand structCommand) {
        ArrayList<SQLObjectEditor.NestedObjectCommand> nestedCommands = new ArrayList<SQLObjectEditor.NestedObjectCommand>(structCommand.getObjectCommands().values());
        nestedCommands.sort((o1, o2) -> {
            Object object1 = o1.getObject();
            Object object2 = o2.getObject();
            if (object1 == structCommand.getObject()) {
                return 1;
            }
            if (object2 == structCommand.getObject()) {
                return -1;
            }
            int order1 = -1;
            int order2 = 1;
            Class<?>[] childTypes = this.getChildTypes();
            int i = 0;
            int childTypesLength = childTypes.length;
            while (i < childTypesLength) {
                Class<?> childType = childTypes[i];
                if (childType.isAssignableFrom(object1.getClass())) {
                    order1 = i;
                }
                if (childType.isAssignableFrom(object2.getClass())) {
                    order2 = i;
                }
                ++i;
            }
            return order1 - order2;
        });
        return nestedCommands;
    }

    @Override
    protected void createObjectReferences(DBRProgressMonitor monitor, DBECommandContext commandContext, SQLObjectEditor.ObjectCreateCommand createCommand) throws DBException {
        DBSObject object = (DBSObject)createCommand.getObject();
        DBERegistry editorsRegistry = object.getDataSource().getContainer().getPlatform().getEditorsRegistry();
        Class<?>[] classArray = this.getChildTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLObjectEditor<?, DBSObject> nestedEditor;
            Class<?> childType = classArray[n2];
            Collection<DBSObject> children = this.getChildObjects(monitor, object, childType);
            if (!CommonUtils.isEmpty(children) && (nestedEditor = this.getObjectEditor(editorsRegistry, childType)) != null) {
                for (DBSObject child : children) {
                    SQLObjectEditor.ObjectCreateCommand childCreateCommand = nestedEditor.makeCreateCommand(child, createCommand.getOptions());
                    commandContext.addCommand(childCreateCommand, null, false);
                }
            }
            ++n2;
        }
    }

    protected <T extends DBSObject> SQLObjectEditor<T, OBJECT_TYPE> getObjectEditor(DBERegistry editorsRegistry, Class<T> type) {
        Class<T> childType = this.getChildType(type);
        return childType == null ? null : editorsRegistry.getObjectManager(childType, SQLObjectEditor.class);
    }

    protected <T> Class<? extends T> getChildType(Class<T> type) {
        Class<?>[] classArray = this.getChildTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> childType = classArray[n2];
            if (type.isAssignableFrom(childType)) {
                return childType;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, OBJECT_TYPE object, Class<? extends DBSObject> childType) throws DBException {
        return null;
    }

    public static class StructCreateCommand
    extends SQLObjectEditor.ObjectCreateCommand
    implements DBECommandAggregator<OBJECT_TYPE> {
        private final Map<DBPObject, SQLObjectEditor.NestedObjectCommand> objectCommands;
        final /* synthetic */ SQLStructEditor this$0;

        public StructCreateCommand(OBJECT_TYPE object, String table, Map<String, Object> options) {
            this.this$0 = var1_1;
            super((SQLObjectEditor)var1_1, object, table, options);
            this.objectCommands = new LinkedHashMap<DBPObject, SQLObjectEditor.NestedObjectCommand>();
            this.objectCommands.put((DBPObject)this.getObject(), this);
        }

        public Map<DBPObject, SQLObjectEditor.NestedObjectCommand> getObjectCommands() {
            return this.objectCommands;
        }

        @Override
        public boolean aggregateCommand(DBECommand<?> command) {
            if (command instanceof SQLObjectEditor.NestedObjectCommand) {
                this.objectCommands.put((DBPObject)command.getObject(), (SQLObjectEditor.NestedObjectCommand)command);
                return true;
            }
            return false;
        }

        @Override
        public void resetAggregatedCommands() {
            this.objectCommands.clear();
            this.objectCommands.put((DBPObject)this.getObject(), this);
        }

        @Override
        public DBEPersistAction[] getPersistActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, Map<String, Object> options) throws DBException {
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            this.this$0.addStructObjectCreateActions(monitor, executionContext, actions, this, options);
            this.this$0.addObjectExtraActions(monitor, executionContext, actions, this, options);
            return actions.toArray(new DBEPersistAction[actions.size()]);
        }
    }
}

