/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationDescriptor;

public class SSHImplementationRegistry {
    private static SSHImplementationRegistry instance = null;
    private final List<SSHImplementationDescriptor> descriptors = new ArrayList<SSHImplementationDescriptor>();

    public static synchronized SSHImplementationRegistry getInstance() {
        if (instance == null) {
            instance = new SSHImplementationRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SSHImplementationRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.net.ssh");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            SSHImplementationDescriptor descriptor = new SSHImplementationDescriptor(ext);
            this.descriptors.add(descriptor);
            ++n2;
        }
    }

    public List<SSHImplementationDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public SSHImplementationDescriptor getDescriptor(String id) {
        for (SSHImplementationDescriptor desc : this.descriptors) {
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }
}

