/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;
import org.jkiss.utils.CommonUtils;

public class StreamProducerSettings
implements IDataTransferSettings {
    private static final Log log = Log.getLog(StreamProducerSettings.class);
    private Map<String, EntityMapping> entityMapping = new HashMap<String, EntityMapping>();
    private Map<String, Object> processorProperties;
    private int maxRows;

    public EntityMapping getEntityMapping(DBSEntity entity) {
        String fullName = DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML);
        EntityMapping mapping = this.entityMapping.get(fullName);
        if (mapping == null) {
            mapping = new EntityMapping(entity);
            this.entityMapping.put(fullName, mapping);
        }
        return mapping;
    }

    public Map<String, Object> getProcessorProperties() {
        return this.processorProperties;
    }

    public void setProcessorProperties(Map<String, Object> processorProperties) {
        this.processorProperties = processorProperties;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DataTransferSettings dataTransferSettings, Map<String, Object> settings) {
        this.setProcessorProperties(dataTransferSettings.getProcessorProperties());
        try {
            for (Map mapping : JSONUtils.getObjectList(settings, (String)"mappings")) {
                EntityMapping em = new EntityMapping(runnableContext, mapping);
                DBSEntity entity = em.getEntity();
                if (entity == null) continue;
                this.entityMapping.put(DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML), em);
            }
            this.updateMappingsFromStream(dataTransferSettings);
        }
        catch (Exception e) {
            log.error((Object)"Error loading stream producer settings", (Throwable)e);
        }
    }

    public void updateMappingsFromStream(DataTransferSettings dataTransferSettings) throws DBException {
        Map<String, Object> processorProperties = dataTransferSettings.getProcessorProperties();
        for (DataTransferPipe pipe : dataTransferSettings.getDataPipes()) {
            DBSObject targetObject;
            StreamTransferProducer producer = (StreamTransferProducer)pipe.getProducer();
            if (producer == null || pipe.getConsumer() == null || !((targetObject = pipe.getConsumer().getDatabaseObject()) instanceof DBSEntity)) continue;
            DBSEntity entity = (DBSEntity)targetObject;
            EntityMapping entityMapping = this.getEntityMapping(entity);
            List<StreamDataImporterColumnInfo> columnInfos = null;
            File inputFile = producer.getInputFile();
            if (inputFile != null && inputFile.exists()) {
                IDataTransferProcessor importer = dataTransferSettings.getProcessor().getInstance();
                if (importer instanceof IStreamDataImporter) {
                    IStreamDataImporter sdi = (IStreamDataImporter)importer;
                    try {
                        Object object = null;
                        Object var14_16 = null;
                        try (FileInputStream is = new FileInputStream(inputFile);){
                            sdi.init(new StreamDataImporterSite(this, entity, processorProperties));
                            try {
                                columnInfos = sdi.readColumnsInfo(is);
                            }
                            finally {
                                sdi.dispose();
                            }
                        }
                        catch (Throwable throwable) {
                            if (object == null) {
                                object = throwable;
                            } else if (object != throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            throw object;
                        }
                    }
                    catch (IOException e) {
                        throw new DBException("IO error", (Throwable)e);
                    }
                }
                entityMapping.setStreamColumns(columnInfos);
            }
            if (columnInfos == null) continue;
            List<AttributeMapping> attributeMappings = entityMapping.getAttributeMappings();
            for (StreamDataImporterColumnInfo columnInfo : columnInfos) {
                AttributeMapping attr2;
                boolean mappingFound = false;
                if (columnInfo.getColumnName() != null) {
                    for (AttributeMapping attr2 : attributeMappings) {
                        if (!CommonUtils.equalObjects((Object)attr2.getSourceAttributeName(), (Object)columnInfo.getColumnName())) continue;
                        if (attr2.getMappingType() == AttributeMapping.MappingType.NONE || attr2.getSourceAttributeIndex() < 0) {
                            attr2.setSourceAttributeName(columnInfo.getColumnName());
                            attr2.setSourceAttributeIndex(columnInfo.getColumnIndex());
                            if (attr2.getMappingType() == AttributeMapping.MappingType.NONE) {
                                attr2.setMappingType(AttributeMapping.MappingType.IMPORT);
                            }
                            attr2.setSourceColumn(columnInfo);
                        }
                        mappingFound = true;
                        break;
                    }
                }
                if (mappingFound || columnInfo.getColumnIndex() < 0 || columnInfo.getColumnIndex() >= attributeMappings.size() || (attr2 = attributeMappings.get(columnInfo.getColumnIndex())).getMappingType() != AttributeMapping.MappingType.NONE) continue;
                if (!CommonUtils.isEmpty((String)columnInfo.getColumnName())) {
                    attr2.setSourceAttributeName(columnInfo.getColumnName());
                }
                attr2.setSourceAttributeIndex(columnInfo.getColumnIndex());
                attr2.setMappingType(AttributeMapping.MappingType.IMPORT);
                attr2.setSourceColumn(columnInfo);
            }
        }
    }

    @Override
    public void saveSettings(Map<String, Object> settings) {
        ArrayList<Map<String, Object>> mappings = new ArrayList<Map<String, Object>>();
        settings.put("mappings", mappings);
        for (EntityMapping emc : this.entityMapping.values()) {
            Map<String, Object> emSettings = emc.saveSettings();
            if (emSettings == null) continue;
            mappings.add(emSettings);
        }
    }

    @Override
    public String getSettingsSummary() {
        StringBuilder summary = new StringBuilder();
        return summary.toString();
    }

    public static class AttributeMapping {
        private DBSEntityAttribute targetAttribute;
        private DBDValueHandler targetValueHandler;
        private String targetAttributeName;
        private String sourceAttributeName;
        private int sourceAttributeIndex = -1;
        private boolean skip;
        private String defaultValue;
        private MappingType mappingType = MappingType.NONE;
        private StreamDataImporterColumnInfo sourceColumn;

        public AttributeMapping(DBSEntityAttribute attr) {
            this.sourceAttributeName = this.targetAttributeName = attr.getName();
            this.targetAttribute = attr;
            this.targetValueHandler = DBUtils.findValueHandler((DBPDataSource)attr.getDataSource(), (DBSTypedObject)attr);
        }

        AttributeMapping(DBRProgressMonitor monitor, EntityMapping em, String sourceAttrName, Map<String, Object> config) throws DBException {
            this.targetAttributeName = JSONUtils.getString(config, (String)"targetName");
            this.sourceAttributeName = sourceAttrName;
            this.mappingType = (MappingType)CommonUtils.valueOf(MappingType.class, (String)CommonUtils.toString((Object)config.get("mapping")), (Enum)MappingType.SKIP);
            this.skip = JSONUtils.getBoolean(config, (String)"skip");
            this.defaultValue = JSONUtils.getString(config, (String)"default");
            this.targetAttribute = em.entity.getAttribute(monitor, this.targetAttributeName);
            if (this.targetAttribute != null) {
                this.targetValueHandler = DBUtils.findValueHandler((DBPDataSource)this.targetAttribute.getDataSource(), (DBSTypedObject)this.targetAttribute);
            }
        }

        public MappingType getMappingType() {
            return this.mappingType;
        }

        public void setMappingType(MappingType mappingType) {
            this.mappingType = mappingType;
        }

        public DBSEntityAttribute getTargetAttribute() {
            return this.targetAttribute;
        }

        public DBDValueHandler getTargetValueHandler() {
            return this.targetValueHandler;
        }

        public String getSourceAttributeName() {
            return CommonUtils.isEmpty((String)this.sourceAttributeName) ? String.valueOf(this.sourceAttributeIndex) : this.sourceAttributeName;
        }

        public void setSourceAttributeName(String sourceAttributeName) {
            this.sourceAttributeName = sourceAttributeName;
        }

        public int getSourceAttributeIndex() {
            return this.sourceAttributeIndex;
        }

        public void setSourceAttributeIndex(int sourceAttributeIndex) {
            this.sourceAttributeIndex = sourceAttributeIndex;
        }

        public String getTargetAttributeName() {
            return this.targetAttributeName;
        }

        public void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public StreamDataImporterColumnInfo getSourceColumn() {
            return this.sourceColumn;
        }

        public void setSourceColumn(StreamDataImporterColumnInfo sourceColumn) {
            this.sourceColumn = sourceColumn;
        }

        public boolean isValuable() {
            return this.mappingType == MappingType.IMPORT || this.mappingType == MappingType.DEFAULT_VALUE;
        }

        void saveSettings(Map<String, Object> config) {
            LinkedHashMap<String, Object> attrMap = new LinkedHashMap<String, Object>();
            config.put(this.getSourceAttributeName(), attrMap);
            attrMap.put("targetName", this.getTargetAttributeName());
            attrMap.put("mapping", this.mappingType.name());
            if (this.skip) {
                attrMap.put("skip", true);
            }
            if (!CommonUtils.isEmpty((String)this.defaultValue)) {
                attrMap.put("default", this.defaultValue);
            }
        }

        public String toString() {
            return String.valueOf(this.sourceAttributeName) + " " + (Object)((Object)this.mappingType) + " (" + this.targetAttributeName + ")";
        }

        public static enum MappingType {
            NONE("none"),
            IMPORT("import"),
            DEFAULT_VALUE("custom value"),
            SKIP("skip");

            private final String title;

            private MappingType(String title) {
                this.title = title;
            }

            public String getTitle() {
                return this.title;
            }
        }
    }

    public static class EntityMapping {
        private String entityName;
        private DBSEntity entity;
        private List<AttributeMapping> attributeMappings = new ArrayList<AttributeMapping>();
        private List<StreamDataImporterColumnInfo> streamColumns = new ArrayList<StreamDataImporterColumnInfo>();

        EntityMapping(DBSEntity entity) {
            this.entity = entity;
            this.entityName = DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }

        EntityMapping(String entityName) {
            this.entityName = entityName;
        }

        EntityMapping(DBRRunnableContext runnableContext, Map<String, Object> config) throws DBCException, InvocationTargetException, InterruptedException {
            DBPProject project;
            String projectName = CommonUtils.toString((Object)config.get("project"));
            DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
            if (project == null) {
                throw new DBCException("Error loading stream producer mappings - project not found");
            }
            String entityId = CommonUtils.toString((Object)config.get("entityId"));
            if (!CommonUtils.isEmpty((String)entityId)) {
                runnableContext.run(true, true, monitor -> {
                    try {
                        this.entity = (DBSEntity)DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)entityId);
                        if (this.entity == null) {
                            log.error((Object)("Entity '" + entityId + "' not found"));
                            return;
                        }
                        Map attrsConfig = JSONUtils.getObject((Map)config, (String)"attributes");
                        for (String sourceAttrName : attrsConfig.keySet()) {
                            Map attrMap = (Map)attrsConfig.get(sourceAttrName);
                            AttributeMapping am = new AttributeMapping(monitor, this, sourceAttrName, attrMap);
                            this.attributeMappings.add(am);
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
        }

        public String getEntityName() {
            return this.entityName;
        }

        public DBSEntity getEntity() {
            return this.entity;
        }

        public List<AttributeMapping> getAttributeMappings() {
            return this.attributeMappings;
        }

        public List<AttributeMapping> getValuableAttributeMappings() {
            ArrayList<AttributeMapping> result = new ArrayList<AttributeMapping>();
            for (AttributeMapping am : this.attributeMappings) {
                if (!am.isValuable()) continue;
                result.add(am);
            }
            return result;
        }

        public AttributeMapping getAttributeMapping(DBSEntityAttribute attr) {
            AttributeMapping am2;
            for (AttributeMapping am2 : this.attributeMappings) {
                if (!attr.getName().equals(am2.getTargetAttributeName())) continue;
                return am2;
            }
            am2 = new AttributeMapping(attr);
            this.attributeMappings.add(am2);
            return am2;
        }

        public boolean isComplete() {
            for (AttributeMapping am : this.attributeMappings) {
                if (am.getMappingType() != AttributeMapping.MappingType.NONE) continue;
                return false;
            }
            return true;
        }

        public List<StreamDataImporterColumnInfo> getStreamColumns() {
            return this.streamColumns;
        }

        public void setStreamColumns(List<StreamDataImporterColumnInfo> streamColumns) {
            this.streamColumns.clear();
            this.streamColumns.addAll(streamColumns);
        }

        public StreamDataImporterColumnInfo getStreamColumn(String name) {
            for (StreamDataImporterColumnInfo col : this.streamColumns) {
                if (!name.equals(col.getColumnName())) continue;
                return col;
            }
            return null;
        }

        Map<String, Object> saveSettings() {
            if (this.entity == null || this.entity.getParentObject() == null) {
                return null;
            }
            LinkedHashMap<String, Object> mappings = new LinkedHashMap<String, Object>();
            mappings.put("project", this.entity.getDataSource().getContainer().getProject().getName());
            mappings.put("entityId", DBUtils.getObjectFullId((DBSObject)this.entity));
            LinkedHashMap<String, Object> attrConfig = new LinkedHashMap<String, Object>();
            mappings.put("attributes", attrConfig);
            for (AttributeMapping attr : this.attributeMappings) {
                attr.saveSettings(attrConfig);
            }
            return mappings;
        }
    }
}

