/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.serialize.DBPObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.utils.CommonUtils;

@DBSerializable(value="streamTransferProducer")
public class StreamTransferProducer
implements IDataTransferProducer<StreamProducerSettings> {
    private static final Log log = Log.getLog(StreamTransferProducer.class);
    public static final String NODE_ID = "stream_producer";
    private File inputFile;
    private DataTransferProcessorDescriptor defaultProcessor;
    private StreamSourceObject sourceObject;

    public StreamTransferProducer() {
    }

    public StreamTransferProducer(File file) {
        this(file, null);
    }

    public StreamTransferProducer(File file, DataTransferProcessorDescriptor defaultProcessor) {
        this.inputFile = file;
        this.defaultProcessor = defaultProcessor;
        this.sourceObject = new StreamSourceObject(new StreamProducerSettings.EntityMapping(file.getName()));
    }

    public DBSEntity getDatabaseObject() {
        return this.sourceObject;
    }

    @Override
    public String getObjectName() {
        return this.inputFile == null ? null : this.inputFile.getName();
    }

    @Override
    public DBPImage getObjectIcon() {
        if (this.defaultProcessor != null) {
            return this.defaultProcessor.getIcon();
        }
        return null;
    }

    @Override
    public String getObjectContainerName() {
        return this.inputFile == null ? null : this.inputFile.getParentFile().getAbsolutePath();
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        return DBIcon.TREE_FOLDER;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    @Override
    public void transferData(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferConsumer consumer, @Nullable IDataTransferProcessor processor, @NotNull StreamProducerSettings settings, DBTTask task) throws DBException {
        DBSObject databaseObject = consumer.getDatabaseObject();
        if (!(databaseObject instanceof DBSEntity)) {
            throw new DBException("Wrong consumer object for stream producer: " + databaseObject);
        }
        StreamProducerSettings.EntityMapping entityMapping = settings.getEntityMapping(this.sourceObject);
        if (entityMapping != null) {
            this.loadObjectDefinition(entityMapping);
        }
        Map<String, Object> processorProperties = settings.getProcessorProperties();
        StreamDataImporterSite site = new StreamDataImporterSite(settings, (DBSEntity)databaseObject, processorProperties);
        IStreamDataImporter importer = (IStreamDataImporter)processor;
        importer.init(site);
        try {
            try {
                Throwable throwable = null;
                Object var12_14 = null;
                try (FileInputStream is = new FileInputStream(this.inputFile);){
                    importer.runImport(monitor, is, consumer);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new DBException("IO error", (Throwable)e);
            }
        }
        finally {
            importer.dispose();
        }
    }

    public void loadObjectDefinition(StreamProducerSettings.EntityMapping entityMapping) throws DBException {
        if (this.defaultProcessor == null) {
            return;
        }
        this.sourceObject.entityMapping = entityMapping;
    }

    public static class ObjectSerializer
    implements DBPObjectSerializer<DBTTask, StreamTransferProducer> {
        public void serializeObject(DBRRunnableContext runnableContext, DBTTask context, StreamTransferProducer object, Map<String, Object> state) {
            state.put("file", object.inputFile.getAbsolutePath());
            if (object.defaultProcessor != null) {
                state.put("node", object.defaultProcessor.getNode().getId());
                state.put("processor", object.defaultProcessor.getId());
            }
        }

        public StreamTransferProducer deserializeObject(DBRRunnableContext runnableContext, DBTTask objectContext, Map<String, Object> state) {
            File inputFile = new File(CommonUtils.toString((Object)state.get("file")));
            String nodeId = CommonUtils.toString((Object)state.get("node"));
            String processorId = CommonUtils.toString((Object)state.get("processor"));
            DataTransferProcessorDescriptor processor = null;
            if (!CommonUtils.isEmpty((String)nodeId) && !CommonUtils.isEmpty((String)processorId)) {
                DataTransferNodeDescriptor nodeDesc = DataTransferRegistry.getInstance().getNodeById(nodeId);
                if (nodeDesc == null) {
                    log.warn((Object)("Stream producer node " + nodeId + " not found"));
                } else {
                    processor = nodeDesc.getProcessor(processorId);
                    if (processor == null) {
                        log.warn((Object)("Stream processor " + processorId + " not found"));
                    }
                }
            }
            return new StreamTransferProducer(inputFile, processor);
        }
    }

    private static class StreamSourceAttribute
    extends AbstractAttribute
    implements DBSEntityAttribute {
        private final StreamSourceObject sourceObject;
        private final StreamProducerSettings.AttributeMapping attributeMapping;

        StreamSourceAttribute(StreamSourceObject sourceObject, StreamProducerSettings.AttributeMapping attributeMapping) {
            super(attributeMapping.getSourceAttributeName(), "String", 1, attributeMapping.getSourceAttributeIndex(), Integer.MAX_VALUE, null, null, false, false);
            this.sourceObject = sourceObject;
            this.attributeMapping = attributeMapping;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.STRING;
        }

        public String getDefaultValue() {
            return this.attributeMapping.getDefaultValue();
        }

        @NotNull
        public DBSEntity getParentObject() {
            return this.sourceObject;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return this.sourceObject.getDataSource();
        }
    }

    private class StreamSourceObject
    implements DBSEntity,
    DBSDataContainer,
    DBPQualifiedObject {
        private StreamProducerSettings.EntityMapping entityMapping;

        public StreamSourceObject(StreamProducerSettings.EntityMapping entityMapping) {
            this.entityMapping = entityMapping;
        }

        @NotNull
        public DBSEntityType getEntityType() {
            return DBSEntityType.TABLE;
        }

        public List<StreamSourceAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
            List<StreamProducerSettings.AttributeMapping> attrMappings = this.entityMapping.getValuableAttributeMappings();
            ArrayList<StreamSourceAttribute> result = new ArrayList<StreamSourceAttribute>(attrMappings.size());
            for (StreamProducerSettings.AttributeMapping sa : attrMappings) {
                result.add(new StreamSourceAttribute(this, sa));
            }
            return result;
        }

        public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
            for (StreamProducerSettings.AttributeMapping sa : this.entityMapping.getAttributeMappings()) {
                if (!sa.isValuable() || !attributeName.equals(sa.getSourceAttributeName())) continue;
                return new StreamSourceAttribute(this, sa);
            }
            return null;
        }

        public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
            return null;
        }

        public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
            return null;
        }

        public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public DBSObject getParentObject() {
            return null;
        }

        public DBPDataSource getDataSource() {
            return null;
        }

        public int getSupportedFeatures() {
            return 0;
        }

        @NotNull
        public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
            throw new DBCException("Not implemented");
        }

        public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, DBDDataFilter dataFilter, long flags) throws DBCException {
            return -1L;
        }

        @NotNull
        public String getName() {
            return StreamTransferProducer.this.getObjectName();
        }

        public boolean isPersisted() {
            return true;
        }

        @NotNull
        public String getFullyQualifiedName(DBPEvaluationContext context) {
            return this.getName();
        }
    }
}

