/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DriverTreeViewer
extends TreeViewer {
    private List<DBPDataSourceProviderDescriptor> providers;
    private Font boldFont;
    private final Map<String, DriverCategory> categories = new HashMap<String, DriverCategory>();
    private final List<Object> driverList = new ArrayList<Object>();
    private boolean sortByName = false;

    public DriverTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        parent.addDisposeListener(e -> UIUtils.dispose((Resource)this.boldFont));
    }

    public void initDrivers(List<DBPDataSourceProviderDescriptor> providers, boolean expandRecent) {
        this.getTree().setHeaderVisible(true);
        this.providers = providers;
        if (this.providers == null) {
            this.providers = DataSourceProviderRegistry.getInstance().getEnabledDataSourceProviders();
        }
        TreeColumn nameColumn = new TreeColumn(this.getTree(), 16384);
        nameColumn.setText("Name");
        nameColumn.addListener(13, (Listener)new DriversSortListener(nameColumn, true));
        TreeColumn usersColumn = new TreeColumn(this.getTree(), 16384);
        usersColumn.setText("#");
        usersColumn.addListener(13, (Listener)new DriversSortListener(usersColumn, false));
        this.setContentProvider((IContentProvider)new ViewContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.getControl().setLayoutData((Object)new GridData(1808));
        Collection<Object> drivers = this.collectDrivers();
        this.setInput(drivers);
        UIUtils.expandAll((AbstractTreeViewer)this);
        UIUtils.packColumns((Tree)this.getTree(), (boolean)true, (float[])new float[]{0.9f, 0.1f});
        if (expandRecent) {
            for (Object driver : drivers) {
                if (driver instanceof DriverCategory && this.getConnectionCount(driver) > 0) {
                    this.expandToLevel(driver, -1);
                    continue;
                }
                this.collapseToLevel(driver, -1);
            }
        } else {
            this.collapseAll();
        }
        this.addDoubleClickListener(event -> {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty() && ((element = selection.getFirstElement()) instanceof DriverCategory || element instanceof DataSourceProviderDescriptor)) {
                if (Boolean.TRUE.equals(this.getExpandedState(element))) {
                    super.collapseToLevel(element, 1);
                } else {
                    super.expandToLevel(element, 1);
                }
            }
        });
    }

    public void refresh() {
        if (this.providers != null) {
            this.collectDrivers();
        }
        super.refresh();
    }

    private Collection<Object> collectDrivers() {
        for (DriverCategory category : this.categories.values()) {
            category.drivers.clear();
        }
        this.driverList.clear();
        for (DBPDataSourceProviderDescriptor provider : this.providers) {
            List drivers = provider.getEnabledDrivers();
            for (DBPDriver driver : drivers) {
                String category = driver.getCategory();
                if (CommonUtils.isEmpty((String)category)) {
                    this.driverList.add(driver);
                    continue;
                }
                DriverCategory driverCategory = this.categories.get(category);
                if (driverCategory == null) {
                    driverCategory = new DriverCategory(category);
                    this.categories.put(category, driverCategory);
                }
                if (!this.driverList.contains(driverCategory)) {
                    this.driverList.add(driverCategory);
                }
                driverCategory.drivers.add((DriverDescriptor)driver);
            }
        }
        this.driverList.sort((o1, o2) -> {
            int count1 = this.getConnectionCount(o1);
            int count2 = this.getConnectionCount(o2);
            if (this.sortByName || count1 == count2) {
                String name1 = o1 instanceof DriverDescriptor ? ((DriverDescriptor)o1).getName() : ((DriverCategory)o1).getName();
                String name2 = o2 instanceof DriverDescriptor ? ((DriverDescriptor)o2).getName() : ((DriverCategory)o2).getName();
                return name1.compareToIgnoreCase(name2);
            }
            return count2 - count1;
        });
        for (DriverCategory category : this.categories.values()) {
            category.drivers.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        }
        return this.driverList;
    }

    private int getConnectionCount(Object obj) {
        List allDataSources = DataSourceRegistry.getAllDataSources();
        if (obj instanceof DataSourceProviderDescriptor) {
            int count = 0;
            for (DBPDriver dBPDriver : ((DataSourceProviderDescriptor)obj).getEnabledDrivers()) {
                count += DriverUtils.getUsedBy((DBPDriver)dBPDriver, (List)allDataSources).size();
            }
            return count;
        }
        if (obj instanceof DriverCategory) {
            int count = 0;
            for (DBPDriver dBPDriver : ((DriverCategory)obj).drivers) {
                count += DriverUtils.getUsedBy((DBPDriver)dBPDriver, (List)allDataSources).size();
            }
            return count;
        }
        if (obj instanceof DBPDriver) {
            return DriverUtils.getUsedBy((DBPDriver)((DBPDriver)obj), (List)allDataSources).size();
        }
        return 0;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        super.setSelection(selection, reveal);
    }

    public static class DriverCategory {
        final String name;
        final List<DriverDescriptor> drivers = new ArrayList<DriverDescriptor>();

        DriverCategory(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<DriverDescriptor> getDrivers() {
            return this.drivers;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return obj instanceof DriverCategory && ((DriverCategory)obj).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public DBPImage getImage() {
            DBPImage driverImage = null;
            for (DBPDriver dBPDriver : this.getDrivers()) {
                if (driverImage == null) {
                    driverImage = dBPDriver.getPlainIcon();
                    continue;
                }
                if (driverImage.equals(dBPDriver.getPlainIcon())) continue;
                driverImage = null;
                break;
            }
            if (driverImage != null) {
                return driverImage;
            }
            return DBIcon.TREE_DATABASE_CATEGORY;
        }
    }

    private class DriversSortListener
    implements Listener {
        private final TreeColumn column;
        private final boolean sortByName;

        DriversSortListener(TreeColumn column, boolean sortByName) {
            this.column = column;
            this.sortByName = sortByName;
        }

        public void handleEvent(Event event) {
            DriverTreeViewer.this.getTree().setSortColumn(this.column);
            DriverTreeViewer.this.getTree().setSortDirection(1024);
            DriverTreeViewer.this.sortByName = this.sortByName;
            DriverTreeViewer.this.refresh();
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            DriverDescriptor driver;
            if (child instanceof DriverDescriptor && (driver = (DriverDescriptor)child).getCategory() != null) {
                return DriverTreeViewer.this.categories.get(driver.getCategory());
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof Collection) {
                return ((Collection)parent).toArray();
            }
            if (parent instanceof DriverCategory) {
                return ((DriverCategory)parent).getDrivers().toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof DriverCategory) {
                return !((DriverCategory)parent).drivers.isEmpty();
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        ViewLabelProvider() {
        }

        public void update(ViewerCell cell) {
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(this.getText(cell.getElement()));
                    break;
                }
                case 1: {
                    int count = DriverTreeViewer.this.getConnectionCount(cell.getElement());
                    cell.setText(count <= 0 ? "" : String.valueOf(count));
                    break;
                }
                default: {
                    cell.setText("");
                }
            }
            DBPImage image = this.getImage(cell.getElement(), cell.getColumnIndex());
            if (image != null) {
                cell.setImage(DBeaverIcons.getImage((DBPImage)image));
            }
        }

        public String getDescription(Object obj) {
            if (obj instanceof DataSourceProviderDescriptor) {
                return ((DataSourceProviderDescriptor)obj).getDescription();
            }
            if (obj instanceof DriverDescriptor) {
                return ((DriverDescriptor)obj).getDescription();
            }
            return "";
        }

        public DBPImage getImage(Object obj, int index) {
            if (index != 0) {
                return null;
            }
            DBIcon defImage = DBIcon.TREE_PAGE;
            DBPImage icon = null;
            if (obj instanceof DataSourceProviderDescriptor) {
                icon = ((DataSourceProviderDescriptor)obj).getIcon();
                defImage = DBIcon.TREE_FOLDER;
            } else if (obj instanceof DriverCategory) {
                icon = ((DriverCategory)obj).getImage();
            } else if (obj instanceof DriverDescriptor) {
                icon = ((DriverDescriptor)obj).getIcon();
            }
            if (icon != null) {
                return icon;
            }
            return defImage;
        }

        public Image getImage(Object element) {
            return DBeaverIcons.getImage((DBPImage)this.getImage(element, 0));
        }

        public String getText(Object element) {
            if (element instanceof DataSourceProviderDescriptor) {
                return ((DataSourceProviderDescriptor)element).getName();
            }
            if (element instanceof DriverCategory) {
                return ((DriverCategory)element).name;
            }
            if (element instanceof DriverDescriptor) {
                return ((DriverDescriptor)element).getName();
            }
            return element.toString();
        }
    }
}

