/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionNavigatorSettingsDialog;

public class ConnectionViewSettingsContributor
extends DataSourceMenuContributor {
    private static final Log log = Log.getLog(ConnectionViewSettingsContributor.class);

    protected void fillContributionItems(List<IContributionItem> menuItems) {
        DBPDataSourceContainer dsContainer = AbstractDataSourceHandler.getDataSourceContainerFromPart((IWorkbenchPart)UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart());
        if (dsContainer == null) {
            return;
        }
        boolean presetChecked = false;
        for (DataSourceNavigatorSettings.Preset preset : DataSourceNavigatorSettings.PRESETS.values()) {
            if (preset == DataSourceNavigatorSettings.PRESET_CUSTOM) continue;
            boolean checked = preset.getSettings().equals(dsContainer.getNavigatorSettings());
            if (checked) {
                presetChecked = checked;
            }
            menuItems.add((IContributionItem)new ActionContributionItem((IAction)new UseSettingsPresetAction(dsContainer, preset, checked)));
        }
        menuItems.add((IContributionItem)new ActionContributionItem((IAction)new UseSettingsCustomAction(dsContainer, !presetChecked)));
        menuItems.add((IContributionItem)new Separator());
        menuItems.add((IContributionItem)new ActionContributionItem((IAction)new ShowSystemObjectsAction(dsContainer)));
    }

    private static abstract class SettingsAction
    extends Action {
        final DBPDataSourceContainer dsContainer;

        SettingsAction(DBPDataSourceContainer dsContainer, String name, int style) {
            super(name, style);
            this.dsContainer = dsContainer;
        }

        protected void updateSettings(DBNBrowseSettings settings) {
            ((DataSourceDescriptor)this.dsContainer).setNavigatorSettings(settings);
            this.dsContainer.persistConfiguration();
            if (this.dsContainer.isConnected() && UIUtils.confirmAction((Shell)UIUtils.getActiveWorkbenchShell(), (String)CoreMessages.dialog_connection_edit_wizard_conn_change_title, (String)NLS.bind((String)CoreMessages.dialog_connection_edit_wizard_conn_change_question, (Object)this.dsContainer.getName()))) {
                DataSourceHandler.reconnectDataSource(null, this.dsContainer);
            }
        }
    }

    private static class ShowSystemObjectsAction
    extends SettingsAction {
        ShowSystemObjectsAction(DBPDataSourceContainer container) {
            super(container, CoreMessages.dialog_connection_wizard_final_checkbox_show_system_objects, 2);
            this.setToolTipText(CoreMessages.dialog_connection_wizard_final_checkbox_show_system_objects_tip);
            this.setChecked(container.getNavigatorSettings().isShowSystemObjects());
        }

        public void run() {
            DataSourceNavigatorSettings newSettings = new DataSourceNavigatorSettings(this.dsContainer.getNavigatorSettings());
            newSettings.setShowSystemObjects(this.isChecked());
            this.updateSettings((DBNBrowseSettings)newSettings);
        }
    }

    private static class UseSettingsCustomAction
    extends SettingsAction {
        UseSettingsCustomAction(DBPDataSourceContainer dsContainer, boolean checked) {
            super(dsContainer, String.valueOf(DataSourceNavigatorSettings.PRESET_CUSTOM.getName()) + " ...", 8);
            this.setToolTipText(DataSourceNavigatorSettings.PRESET_CUSTOM.getDescription());
            this.setChecked(checked);
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            EditConnectionNavigatorSettingsDialog dialog = new EditConnectionNavigatorSettingsDialog(UIUtils.getActiveWorkbenchShell(), this.dsContainer.getNavigatorSettings());
            if (dialog.open() == 0) {
                this.updateSettings(dialog.getNavigatorSettings());
            }
        }
    }

    private static class UseSettingsPresetAction
    extends SettingsAction {
        private final DataSourceNavigatorSettings.Preset preset;

        UseSettingsPresetAction(DBPDataSourceContainer dsContainer, DataSourceNavigatorSettings.Preset preset, boolean checked) {
            super(dsContainer, preset.getName(), 8);
            this.preset = preset;
            this.setToolTipText(preset.getDescription());
            this.setChecked(checked);
        }

        public void run() {
            if (this.isChecked()) {
                this.updateSettings(this.preset.getSettings());
            }
        }
    }
}

