/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.utils.CommonUtils;

class DataTransferPagePipes
extends ActiveWizardPage<DataTransferWizard> {
    private TableViewer nodesTable;
    private TableViewer inputsTable;

    DataTransferPagePipes() {
        super(DTMessages.data_transfer_wizard_init_name);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        SashForm sash = new SashForm(composite, 256);
        sash.setLayoutData((Object)new GridData(1808));
        this.createNodesTable((Composite)sash);
        this.createInputsTable((Composite)sash);
        sash.setWeights(new int[]{66, 33});
        this.updatePageCompletion();
        this.setControl((Control)composite);
        this.updatePageCompletion();
    }

    private void createNodesTable(Composite composite) {
        Composite panel = UIUtils.createComposite((Composite)composite, (int)1);
        panel.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)panel, (String)DTUIMessages.data_transfer_wizard_final_column_target);
        this.nodesTable = new TableViewer(panel, 67588);
        this.nodesTable.getTable().setLayoutData((Object)new GridData(1808));
        this.nodesTable.getTable().setLinesVisible(true);
        this.nodesTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        CellLabelProvider labelProvider = new CellLabelProvider(){

            public void update(ViewerCell cell) {
                TransferTarget element = (TransferTarget)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    if (element.processor != null) {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)element.processor.getIcon()));
                        cell.setText(element.processor.getName());
                    } else {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)element.node.getIcon()));
                        cell.setText(element.node.getName());
                    }
                } else if (element.processor != null) {
                    cell.setText(element.processor.getDescription());
                } else {
                    cell.setText(element.node.getDescription());
                }
            }
        };
        TableViewerColumn columnName = new TableViewerColumn(this.nodesTable, 16384);
        columnName.setLabelProvider(labelProvider);
        columnName.getColumn().setText(DTMessages.data_transfer_wizard_init_column_exported);
        TableViewerColumn columnDesc = new TableViewerColumn(this.nodesTable, 16384);
        columnDesc.setLabelProvider(labelProvider);
        columnDesc.getColumn().setText(DTMessages.data_transfer_wizard_init_column_description);
        this.nodesTable.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DataTransferPagePipes.this.nodesTable.getSelection();
                TransferTarget target = !selection.isEmpty() ? (TransferTarget)selection.getFirstElement() : null;
                DataTransferSettings settings = ((DataTransferWizard)DataTransferPagePipes.this.getWizard()).getSettings();
                if (target == null) {
                    settings.selectConsumer(null, null, true);
                } else if (settings.isConsumerOptional()) {
                    settings.selectConsumer(target.node, target.processor, true);
                } else if (settings.isProducerOptional()) {
                    settings.selectProducer(target.node, target.processor, true);
                }
                DataTransferPagePipes.this.updatePageCompletion();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                if (DataTransferPagePipes.this.isPageComplete()) {
                    ((DataTransferWizard)DataTransferPagePipes.this.getWizard()).getContainer().showPage(((DataTransferWizard)DataTransferPagePipes.this.getWizard()).getNextPage((IWizardPage)DataTransferPagePipes.this));
                }
            }
        });
    }

    private void createInputsTable(Composite composite) {
        Composite panel = UIUtils.createComposite((Composite)composite, (int)1);
        panel.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)panel, (String)DTUIMessages.data_transfer_wizard_final_group_objects);
        this.inputsTable = new TableViewer(panel, 67588);
        this.inputsTable.getTable().setLayoutData((Object)new GridData(1808));
        this.inputsTable.getTable().setLinesVisible(true);
        this.inputsTable.getTable().setHeaderVisible(true);
        this.inputsTable.setContentProvider((IContentProvider)new ListContentProvider());
        UIUtils.createTableContextMenu((Table)this.inputsTable.getTable(), null);
        final DBNModel nModel = DBWorkbench.getPlatform().getNavigatorModel();
        CellLabelProvider labelProvider = new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBSObject element = (DBSObject)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    DBNDatabaseNode objectNode = nModel.getNodeByObject(element);
                    DBPImage icon = objectNode != null ? objectNode.getNodeIconDefault() : DBValueFormatting.getObjectImage((DBPObject)element);
                    cell.setImage(DBeaverIcons.getImage((DBPImage)icon));
                    cell.setText(DBUtils.getObjectFullName((DBPNamedObject)element, (DBPEvaluationContext)DBPEvaluationContext.UI));
                } else if (element.getDescription() != null) {
                    cell.setText(element.getDescription());
                }
            }
        };
        TableViewerColumn columnName = new TableViewerColumn(this.inputsTable, 16384);
        columnName.setLabelProvider(labelProvider);
        columnName.getColumn().setText(DTMessages.data_transfer_wizard_init_column_exported);
        TableViewerColumn columnDesc = new TableViewerColumn(this.inputsTable, 16384);
        columnDesc.setLabelProvider(labelProvider);
        columnDesc.getColumn().setText(DTMessages.data_transfer_wizard_init_column_description);
        UIUtils.asyncExec(() -> {
            UIUtils.packColumns((Table)this.inputsTable.getTable());
            UIUtils.maxTableColumnsWidth((Table)this.inputsTable.getTable());
        });
    }

    public void activatePage() {
        if (((DataTransferWizard)this.getWizard()).getSettings().isConsumerOptional()) {
            this.setTitle(DTMessages.data_transfer_wizard_init_title);
            this.setDescription(DTMessages.data_transfer_wizard_init_description);
            this.loadConsumers();
        } else {
            this.setTitle(DTMessages.data_transfer_wizard_producers_title);
            this.setDescription(DTMessages.data_transfer_wizard_producers_description);
            this.loadProducers();
        }
        UIUtils.asyncExec(() -> {
            UIUtils.packColumns((Table)this.nodesTable.getTable());
            UIUtils.maxTableColumnsWidth((Table)this.nodesTable.getTable());
        });
        DataTransferNodeDescriptor consumer = ((DataTransferWizard)this.getWizard()).getSettings().getConsumer();
        DataTransferNodeDescriptor producer = ((DataTransferWizard)this.getWizard()).getSettings().getProducer();
        DataTransferProcessorDescriptor processor = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
        if (consumer != null || producer != null) {
            Collection targets = (Collection)this.nodesTable.getInput();
            for (TransferTarget target : targets) {
                if (target.node != consumer && target.node != producer || target.processor != processor) continue;
                this.nodesTable.setSelection((ISelection)new StructuredSelection((Object)target));
                break;
            }
        }
        this.inputsTable.setInput((Object)((DataTransferWizard)this.getWizard()).getSettings().getSourceObjects());
        this.updatePageCompletion();
    }

    private void loadConsumers() {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        List objects = settings.getSourceObjects();
        ArrayList<TransferTarget> transferTargets = new ArrayList<TransferTarget>();
        for (DataTransferNodeDescriptor consumer : DataTransferRegistry.getInstance().getAvailableConsumers((Collection)objects)) {
            List processors = consumer.getAvailableProcessors((Collection)objects);
            if (CommonUtils.isEmpty((Collection)processors)) {
                transferTargets.add(new TransferTarget(consumer, null));
                continue;
            }
            for (DataTransferProcessorDescriptor processor : processors) {
                transferTargets.add(new TransferTarget(consumer, processor));
            }
        }
        this.nodesTable.setInput(transferTargets);
    }

    private void loadProducers() {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        List objects = settings.getSourceObjects();
        ArrayList<TransferTarget> transferTargets = new ArrayList<TransferTarget>();
        for (DataTransferNodeDescriptor producer : DataTransferRegistry.getInstance().getAvailableProducers((Collection)objects)) {
            List processors = producer.getAvailableProcessors((Collection)objects);
            if (CommonUtils.isEmpty((Collection)processors)) {
                transferTargets.add(new TransferTarget(producer, null));
                continue;
            }
            for (DataTransferProcessorDescriptor processor : processors) {
                transferTargets.add(new TransferTarget(producer, processor));
            }
        }
        this.nodesTable.setInput(transferTargets);
    }

    protected boolean determinePageCompletion() {
        return ((DataTransferWizard)this.getWizard()).getSettings().getConsumer() != null && ((DataTransferWizard)this.getWizard()).getSettings().getProducer() != null;
    }

    private static class TransferTarget {
        DataTransferNodeDescriptor node;
        DataTransferProcessorDescriptor processor;

        private TransferTarget(DataTransferNodeDescriptor node, DataTransferProcessorDescriptor processor) {
            this.node = node;
            this.processor = processor;
        }
    }
}

