/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.locks.graph;

import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.jkiss.dbeaver.ext.ui.locks.graph.LockGraphConnectionAnchor;
import org.jkiss.dbeaver.ext.ui.locks.graph.LockGraphEditPart;
import org.jkiss.dbeaver.ext.ui.locks.graph.LockGraphNodeFigure;
import org.jkiss.dbeaver.model.impl.admin.locks.LockGraph;
import org.jkiss.dbeaver.model.impl.admin.locks.LockGraphEdge;
import org.jkiss.dbeaver.model.impl.admin.locks.LockGraphNode;

public class LockGraphNodeEditPart
extends AbstractGraphicalEditPart {
    private LockGraphConnectionAnchor sourceAnchor;
    private LockGraphConnectionAnchor targetAnchor;

    public boolean isSelectable() {
        return true;
    }

    protected IFigure createFigure() {
        LockGraphNode node = (LockGraphNode)this.getModel();
        LockGraph graph = (LockGraph)this.getParent().getModel();
        LockGraphNodeFigure nodeFigure = new LockGraphNodeFigure(node.getTitle(), node == graph.getSelection());
        this.targetAnchor = new LockGraphConnectionAnchor((IFigure)nodeFigure);
        this.sourceAnchor = new LockGraphConnectionAnchor((IFigure)nodeFigure);
        return nodeFigure;
    }

    protected List<LockGraphEdge> getModelSourceConnections() {
        return ((LockGraphNode)this.getModel()).getSourceEdges();
    }

    protected List<LockGraphEdge> getModelTargetConnections() {
        return ((LockGraphNode)this.getModel()).getTargetEdges();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.sourceAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.targetAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.targetAnchor;
    }

    protected void refreshVisuals() {
        LockGraphNode node = (LockGraphNode)this.getModel();
        LockGraph lgraph = (LockGraph)((LockGraphEditPart)this.getParent()).getModel();
        LockGraphNodeFigure nodeFigure = (LockGraphNodeFigure)this.getFigure();
        LockGraphEditPart graph = (LockGraphEditPart)this.getParent();
        GridData gridData = new GridData(55, 30);
        gridData.horizontalAlignment = 2;
        gridData.verticalAlignment = 2;
        gridData.verticalSpan = 10;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        int span = lgraph.getMaxWidth() / node.getSpan();
        int spanMod = lgraph.getMaxWidth() % node.getSpan();
        gridData.horizontalSpan = 0;
        if (span > 1 && node.getLevelPosition() != LockGraphNode.LevelPosition.RIGHT) {
            gridData.horizontalSpan = span;
        } else if (spanMod > 0 && node.getLevelPosition() == LockGraphNode.LevelPosition.RIGHT) {
            gridData.horizontalSpan = span + spanMod;
        }
        graph.setLayoutConstraint((EditPart)this, (IFigure)nodeFigure, gridData);
    }

    protected void createEditPolicies() {
        SelectionPolicy selectionPolicy = new SelectionPolicy();
        selectionPolicy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)selectionPolicy);
    }

    static class SelectionPolicy
    extends NonResizableEditPolicy {
        SelectionPolicy() {
        }

        protected void hideSelection() {
        }

        protected void showSelection() {
        }
    }
}

