/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2SchemaObject;
import org.jkiss.dbeaver.ext.db2.model.DB2XMLSchemaDep;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2XSRDecomposition;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2XSRStatus;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2XSRType;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class DB2XMLSchema
extends DB2SchemaObject
implements DBPRefreshableObject {
    private static final String C_DEP = "SELECT * FROM SYSCAT.XSROBJECTDEP  WHERE OBJECTSCHEMA = ? AND OBJECTNAME = ? ORDER BY BSCHEMA,BNAME WITH UR";
    private final DBSObjectCache<DB2XMLSchema, DB2XMLSchemaDep> xmlschemaDepCache;
    private Long id;
    private String targetNameSpace;
    private String schemaLocation;
    private DB2XSRType objectType;
    private String owner;
    private DB2OwnerType ownerType;
    private Timestamp createTime;
    private Timestamp alterTime;
    private DB2XSRStatus status;
    private DB2XSRDecomposition decomposition;
    private String remarks;
    private SQLXML objectInfo;
    private String objectInfoString;

    public DB2XMLSchema(DB2Schema schema, ResultSet dbResult) throws SQLException {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECTNAME"), true);
        this.id = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"OBJECTID");
        this.targetNameSpace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TARGETNAMESPACE");
        this.schemaLocation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMALOCATION");
        this.objectType = (DB2XSRType)CommonUtils.valueOf(DB2XSRType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECTTYPE"));
        this.owner = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"OWNER");
        this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.alterTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ALTER_TIME");
        this.status = (DB2XSRStatus)CommonUtils.valueOf(DB2XSRStatus.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
        this.decomposition = (DB2XSRDecomposition)CommonUtils.valueOf(DB2XSRDecomposition.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DECOMPOSITION"));
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        this.objectInfo = JDBCUtils.safeGetXML((ResultSet)dbResult, (String)"OBJECTINFO");
        this.objectInfoString = this.objectInfo.getString();
        this.xmlschemaDepCache = new JDBCObjectSimpleCache(DB2XMLSchemaDep.class, C_DEP, new Object[]{schema.getName(), this.getName()});
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.xmlschemaDepCache.clearCache();
        return this;
    }

    @Association
    public Collection<DB2XMLSchemaDep> getXmlschemaDeps(DBRProgressMonitor monitor) throws DBException {
        return this.xmlschemaDepCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, order=2)
    public DB2Schema getSchema() {
        return super.getSchema();
    }

    @Property(viewable=true, order=3)
    public DB2XSRType getObjectType() {
        return this.objectType;
    }

    @Property(viewable=true, order=4)
    public DB2XSRStatus getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=5)
    public DB2XSRDecomposition getDecomposition() {
        return this.decomposition;
    }

    @Property(viewable=false, order=10)
    public Long getId() {
        return this.id;
    }

    @Property(viewable=false, order=11)
    public String getTargetNameSpace() {
        return this.targetNameSpace;
    }

    @Property(viewable=false, order=12)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Property(viewable=false, order=13)
    public String getObjectInfoString() {
        return this.objectInfoString;
    }

    @Override
    @Property(viewable=false, order=20, updatable=true, multiline=true)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Property(viewable=false, order=21, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, order=22, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=false, order=23, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, order=24, category="Date & Time")
    public Timestamp getAlterTime() {
        return this.alterTime;
    }
}

