/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTreeEditor;
import org.jkiss.dbeaver.ui.controls.NamedObjectPatternFilter;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.utils.CommonUtils;

class FilterSettingsDialog
extends HelpEnabledDialog {
    private static final String DIALOG_ID = "DBeaver.FilterSettingsDialog";
    private final Comparator<DBDAttributeBinding> POSITION_SORTER = (o1, o2) -> {
        DBDAttributeConstraint c1 = this.getBindingConstraint((DBDAttributeBinding)o1);
        DBDAttributeConstraint c2 = this.getBindingConstraint((DBDAttributeBinding)o2);
        return c1.getVisualPosition() - c2.getVisualPosition();
    };
    private final Comparator<DBDAttributeBinding> ALPHA_SORTER = Comparator.comparing(DBDAttributeBinding::getName);
    private final ResultSetViewer resultSetViewer;
    private final List<DBDAttributeBinding> attributes;
    private CheckboxTreeViewer columnsViewer;
    private DBDDataFilter dataFilter;
    private Text whereText;
    private Text orderText;
    private List<DBDAttributeConstraint> constraints;
    private ToolItem moveTopButton;
    private ToolItem moveUpButton;
    private ToolItem moveDownButton;
    private ToolItem moveBottomButton;
    private Comparator<DBDAttributeBinding> activeSorter = this.POSITION_SORTER;

    FilterSettingsDialog(ResultSetViewer resultSetViewer) {
        super(resultSetViewer.getControl().getShell(), "data-filter");
        this.resultSetViewer = resultSetViewer;
        this.dataFilter = new DBDDataFilter(resultSetViewer.getModel().getDataFilter());
        this.constraints = new ArrayList<DBDAttributeConstraint>(this.dataFilter.getConstraints());
        DBDAttributeBinding[] modelAttrs = resultSetViewer.getModel().getAttributes();
        this.attributes = new ArrayList<DBDAttributeBinding>(modelAttrs.length);
        Collections.addAll(this.attributes, modelAttrs);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(ResultSetMessages.controls_resultset_filter_title);
        this.getShell().setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER));
        Composite composite = (Composite)super.createDialogArea(parent);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        Composite columnsGroup = UIUtils.createPlaceholder((Composite)tabFolder, (int)1);
        new FilteredTree(columnsGroup, 65572, (PatternFilter)new NamedObjectPatternFilter(), true){

            protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                FilterSettingsDialog.this.columnsViewer = new CheckboxTreeViewer(parent, style);
                return FilterSettingsDialog.this.columnsViewer;
            }
        };
        this.columnsViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                List nestedBindings = ((DBDAttributeBinding)parentElement).getNestedBindings();
                if (nestedBindings == null || nestedBindings.isEmpty()) {
                    return null;
                }
                Object[] res = nestedBindings.toArray(new DBDAttributeBinding[0]);
                Arrays.sort(res, FilterSettingsDialog.this.activeSorter);
                return res;
            }

            public boolean hasChildren(Object element) {
                List nestedBindings = ((DBDAttributeBinding)element).getNestedBindings();
                return nestedBindings != null && !nestedBindings.isEmpty();
            }
        });
        this.columnsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        this.columnsViewer.setCheckStateProvider((ICheckStateProvider)new CheckStateProvider());
        final Tree columnsTree = this.columnsViewer.getTree();
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        columnsTree.setLayoutData((Object)gd);
        columnsTree.setHeaderVisible(true);
        columnsTree.setLinesVisible(true);
        UIUtils.createTreeColumn((Tree)columnsTree, (int)16384, (String)ResultSetMessages.controls_resultset_filter_column_name);
        UIUtils.createTreeColumn((Tree)columnsTree, (int)16384, (String)"#");
        UIUtils.createTreeColumn((Tree)columnsTree, (int)16384, (String)ResultSetMessages.controls_resultset_filter_column_order);
        TreeColumn criteriaColumn = UIUtils.createTreeColumn((Tree)columnsTree, (int)16384, (String)ResultSetMessages.controls_resultset_filter_column_criteria);
        new CustomTreeEditor(columnsTree){
            {
                super($anonymous0);
                this.firstTraverseIndex = 3;
                this.lastTraverseIndex = 3;
            }

            protected Control createEditor(Tree table, int index, TreeItem item) {
                if (index == 2) {
                    this.toggleColumnOrder(item);
                    return null;
                }
                if (index == 3 && FilterSettingsDialog.this.resultSetViewer.supportsDataFilter()) {
                    Text text = new Text((Composite)columnsTree, 2048);
                    text.setText(item.getText(index));
                    text.selectAll();
                    return text;
                }
                return null;
            }

            protected void saveEditorValue(Control control, int index, TreeItem item) {
                Text text = (Text)control;
                String criteria = text.getText().trim();
                DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint((DBDAttributeBinding)item.getData());
                if (CommonUtils.isEmpty((String)criteria)) {
                    constraint.setCriteria(null);
                } else {
                    constraint.setCriteria(criteria);
                }
                item.setText(3, criteria);
            }

            private void toggleColumnOrder(TreeItem item) {
                DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint((DBDAttributeBinding)item.getData());
                if (constraint.getOrderPosition() == 0) {
                    constraint.setOrderPosition(FilterSettingsDialog.this.dataFilter.getMaxOrderingPosition() + 1);
                    constraint.setOrderDescending(false);
                } else if (!constraint.isOrderDescending()) {
                    constraint.setOrderDescending(true);
                } else {
                    constraint.setOrderPosition(0);
                    constraint.setOrderDescending(false);
                }
                FilterSettingsDialog.this.columnsViewer.refresh();
            }
        };
        this.columnsViewer.addCheckStateListener(event -> {
            DBDAttributeConstraint constraint = this.getBindingConstraint((DBDAttributeBinding)event.getElement());
            constraint.setVisible(event.getChecked());
        });
        ToolBar toolbar = new ToolBar(columnsGroup, 131328);
        gd = new GridData(768);
        gd.verticalIndent = 3;
        toolbar.setLayoutData((Object)gd);
        toolbar.setLayout((Layout)new FillLayout());
        this.moveTopButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_move_to_top, UIIcon.ARROW_TOP, () -> {
            int selectionIndex = this.getSelectionIndex(this.columnsViewer.getTree());
            this.moveColumns(selectionIndex, 0);
        });
        this.moveTopButton.setEnabled(false);
        this.moveUpButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_move_up, UIIcon.ARROW_UP, () -> {
            int selectionIndex = this.getSelectionIndex(this.columnsViewer.getTree());
            this.swapColumns(selectionIndex, selectionIndex - 1);
        });
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_move_down, UIIcon.ARROW_DOWN, () -> {
            int selectionIndex = this.getSelectionIndex(this.columnsViewer.getTree());
            this.swapColumns(selectionIndex, selectionIndex + 1);
        });
        this.moveDownButton.setEnabled(false);
        this.moveBottomButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_move_to_bottom, UIIcon.ARROW_BOTTOM, () -> {
            int selectionIndex = this.getSelectionIndex(this.columnsViewer.getTree());
            this.moveColumns(selectionIndex, this.getItemsCount() - 1);
        });
        this.moveBottomButton.setEnabled(false);
        UIUtils.createToolBarSeparator((ToolBar)toolbar, (int)512);
        FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_sort, UIIcon.SORT, () -> {
            this.attributes.sort(this.ALPHA_SORTER);
            int i = 0;
            while (i < this.attributes.size()) {
                DBDAttributeConstraint constraint = this.getBindingConstraint(this.attributes.get(i));
                constraint.setVisualPosition(i);
                ++i;
            }
            this.columnsViewer.refresh();
        });
        UIUtils.createToolBarSeparator((ToolBar)toolbar, (int)512);
        ToolItem showAllButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_show_all, null, () -> {
            for (DBDAttributeConstraint constraint : this.constraints) {
                constraint.setVisible(true);
            }
            this.columnsViewer.refresh();
        });
        showAllButton.setImage(UIUtils.getShardImage((String)"IMG_ETOOL_DEF_PERSPECTIVE"));
        ToolItem showNoneButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_show_none, null, () -> {
            for (DBDAttributeConstraint constraint : this.constraints) {
                constraint.setVisible(false);
            }
            this.columnsViewer.refresh();
        });
        showNoneButton.setImage(UIUtils.getShardImage((String)"IMG_ELCL_REMOVEALL"));
        FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_reset, UIIcon.REFRESH, () -> {
            this.dataFilter.reset();
            this.constraints = new ArrayList<DBDAttributeConstraint>(this.dataFilter.getConstraints());
            this.refreshData();
            this.orderText.setText("");
            this.whereText.setText("");
        });
        this.columnsViewer.addSelectionChangedListener(event -> {
            int selectionIndex = this.getSelectionIndex(this.columnsViewer.getTree());
            this.moveTopButton.setEnabled(selectionIndex > 0);
            this.moveUpButton.setEnabled(selectionIndex > 0);
            this.moveDownButton.setEnabled(selectionIndex >= 0 && selectionIndex < this.getItemsCount() - 1);
            this.moveBottomButton.setEnabled(selectionIndex >= 0 && selectionIndex < this.getItemsCount() - 1);
        });
        TabItem libsTab = new TabItem(tabFolder, 0);
        libsTab.setText(ResultSetMessages.controls_resultset_filter_group_columns);
        libsTab.setToolTipText("Set criteria and order for individual column(s)");
        libsTab.setControl((Control)columnsGroup);
        this.createCustomFilters(tabFolder);
        this.columnsViewer.setInput(this.attributes);
        this.refreshData();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Tree)this.columnsViewer.getTree(), (boolean)true, (float[])new float[]{0.45f, 0.05f, 0.05f, 0.45f}));
        if (criteriaColumn.getWidth() < 200) {
            criteriaColumn.setWidth(200);
        }
        if (!this.resultSetViewer.supportsDataFilter()) {
            Label warnLabel = new Label(composite, 0);
            warnLabel.setText(ResultSetMessages.controls_resultset_filter_warning_custom_order_disabled);
            warnLabel.setForeground(parent.getDisplay().getSystemColor(3));
        }
        return parent;
    }

    private int getItemsCount() {
        return this.columnsViewer.getTree().getItemCount();
    }

    private void refreshData() {
        this.attributes.sort(this.activeSorter);
        this.columnsViewer.refresh();
        this.columnsViewer.expandAll();
    }

    private int getSelectionIndex(Tree tree) {
        TreeItem[] selection = tree.getSelection();
        if (selection.length == 0) {
            return 0;
        }
        return tree.indexOf(selection[0]);
    }

    private void swapColumns(int curIndex, int newIndex) {
        DBDAttributeConstraint c1 = this.getBindingConstraint((DBDAttributeBinding)this.columnsViewer.getTree().getItem(curIndex).getData());
        DBDAttributeConstraint c2 = this.getBindingConstraint((DBDAttributeBinding)this.columnsViewer.getTree().getItem(newIndex).getData());
        int vp2 = c2.getVisualPosition();
        c2.setVisualPosition(c1.getVisualPosition());
        c1.setVisualPosition(vp2);
        this.refreshData();
        this.moveTopButton.setEnabled(newIndex > 0);
        this.moveUpButton.setEnabled(newIndex > 0);
        this.moveDownButton.setEnabled(newIndex < this.getItemsCount() - 1);
        this.moveBottomButton.setEnabled(newIndex < this.getItemsCount() - 1);
    }

    private void moveColumns(int curIndex, int newIndex) {
        if (curIndex == newIndex) {
            return;
        }
        DBDAttributeConstraint curAttr = this.getBindingConstraint((DBDAttributeBinding)this.columnsViewer.getTree().getItem(curIndex).getData());
        for (DBDAttributeConstraint c : this.constraints) {
            if (newIndex < curIndex) {
                if (c.getVisualPosition() < newIndex || c.getVisualPosition() >= curIndex) continue;
                c.setVisualPosition(c.getVisualPosition() + 1);
                continue;
            }
            if (c.getVisualPosition() <= curIndex || c.getVisualPosition() > newIndex) continue;
            c.setVisualPosition(c.getVisualPosition() - 1);
        }
        curAttr.setVisualPosition(newIndex);
        this.refreshData();
        this.moveTopButton.setEnabled(newIndex > 0);
        this.moveUpButton.setEnabled(newIndex > 0);
        this.moveDownButton.setEnabled(newIndex < this.getItemsCount() - 1);
        this.moveBottomButton.setEnabled(newIndex < this.getItemsCount() - 1);
    }

    private void createCustomFilters(TabFolder tabFolder) {
        Composite filterGroup = new Composite((Composite)tabFolder, 0);
        filterGroup.setLayoutData((Object)new GridData(1808));
        filterGroup.setLayout((Layout)new GridLayout(1, false));
        UIUtils.createControlLabel((Composite)filterGroup, (String)ResultSetMessages.controls_resultset_filter_label_where);
        this.whereText = new Text(filterGroup, 2818);
        this.whereText.setLayoutData((Object)new GridData(1808));
        if (this.dataFilter.getWhere() != null) {
            this.whereText.setText(this.dataFilter.getWhere());
        }
        UIUtils.createControlLabel((Composite)filterGroup, (String)ResultSetMessages.controls_resultset_filter_label_orderby);
        this.orderText = new Text(filterGroup, 2818);
        this.orderText.setLayoutData((Object)new GridData(1808));
        if (this.dataFilter.getOrder() != null) {
            this.orderText.setText(this.dataFilter.getOrder());
        }
        if (!this.resultSetViewer.supportsDataFilter()) {
            filterGroup.setEnabled(false);
            ControlEnableState.disable((Control)filterGroup);
        }
        TabItem libsTab = new TabItem(tabFolder, 0);
        libsTab.setText(ResultSetMessages.controls_resultset_filter_group_custom);
        libsTab.setToolTipText("Set custom criteria and order for whole query");
        libsTab.setControl((Control)filterGroup);
    }

    public int open() {
        return super.open();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        boolean hasVisibleColumns = false;
        for (DBDAttributeConstraint constraint : this.dataFilter.getConstraints()) {
            if (!constraint.isVisible()) continue;
            hasVisibleColumns = true;
        }
        if (!hasVisibleColumns) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)"Bad filter", (String)"You have to set at least one column visible", (int)8);
            return;
        }
        if (!CommonUtils.isEmpty((String)this.orderText.getText())) {
            this.dataFilter.setOrder(this.orderText.getText());
        } else {
            this.dataFilter.setOrder(null);
        }
        if (!CommonUtils.isEmpty((String)this.whereText.getText())) {
            this.dataFilter.setWhere(this.whereText.getText());
        } else {
            this.dataFilter.setWhere(null);
        }
        boolean filtersChanged = true;
        if (this.dataFilter.equalFilters(this.resultSetViewer.getModel().getDataFilter(), true)) {
            filtersChanged = false;
        }
        this.resultSetViewer.setDataFilter(this.dataFilter, filtersChanged);
        super.okPressed();
    }

    @NotNull
    private DBDAttributeConstraint getBindingConstraint(DBDAttributeBinding binding) {
        for (DBDAttributeConstraint constraint : this.constraints) {
            if (!constraint.matches((DBSAttributeBase)binding, true)) continue;
            return constraint;
        }
        throw new IllegalStateException("Can't find constraint for binding " + binding);
    }

    private static ToolItem createToolItem(ToolBar toolBar, String text, DBIcon icon, final Runnable action) {
        ToolItem item = new ToolItem(toolBar, 8);
        if (icon != null) {
            item.setImage(DBeaverIcons.getImage((DBPImage)icon));
        }
        if (text != null) {
            item.setToolTipText(text);
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        return item;
    }

    class CheckStateProvider
    implements ICheckStateProvider {
        CheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            return FilterSettingsDialog.this.getBindingConstraint((DBDAttributeBinding)element).isVisible();
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    class ColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ColumnLabelProvider() {
        }

        @Nullable
        public Image getColumnImage(Object element, int columnIndex) {
            DBDAttributeConstraint constraint;
            DBDAttributeBinding binding = (DBDAttributeBinding)element;
            if (columnIndex == 0) {
                return DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)binding.getMetaAttribute()));
            }
            if (columnIndex == 2 && (constraint = FilterSettingsDialog.this.getBindingConstraint(binding)).getOrderPosition() > 0) {
                return DBeaverIcons.getImage((DBPImage)(constraint.isOrderDescending() ? UIIcon.SORT_INCREASE : UIIcon.SORT_DECREASE));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DBDAttributeBinding binding = (DBDAttributeBinding)element;
            DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
            switch (columnIndex) {
                case 0: {
                    return constraint.getAttribute().getName();
                }
                case 1: {
                    return String.valueOf(constraint.getOriginalVisualPosition() + 1);
                }
                case 2: {
                    int orderPosition = constraint.getOrderPosition();
                    if (orderPosition > 0) {
                        return " " + String.valueOf(orderPosition);
                    }
                    return "";
                }
                case 3: {
                    String condition;
                    DBCExecutionContext executionContext = FilterSettingsDialog.this.resultSetViewer.getExecutionContext();
                    if (executionContext != null && (condition = SQLUtils.getConstraintCondition((DBPDataSource)executionContext.getDataSource(), (DBDAttributeConstraint)constraint, (boolean)true)) != null) {
                        return condition;
                    }
                    return "";
                }
            }
            return "";
        }
    }
}

