/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCArrayValueHandler;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class PostgreArrayValueHandler
extends JDBCArrayValueHandler {
    public static final PostgreArrayValueHandler INSTANCE = new PostgreArrayValueHandler();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return super.fetchColumnValue(session, resultSet, type, index);
    }

    public DBDCollection getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object != null) {
            String className = object.getClass().getName();
            if (object instanceof String || className.equals("org.postgresql.util.PGobject") || className.equals("org.postgresql.jdbc.PgArray")) {
                PostgreDataType arrayType = PostgreUtils.findDataType(session, (PostgreDataSource)session.getDataSource(), type);
                if (arrayType == null) {
                    throw new DBCException("Can't resolve data type " + type.getFullTypeName());
                }
                PostgreDataType itemType = arrayType.getElementType(session.getProgressMonitor());
                if (itemType == null) {
                    throw new DBCException("Array type " + arrayType.getFullTypeName() + " doesn't have a component type");
                }
                if (className.equals("org.postgresql.jdbc.PgArray")) {
                    String strValue = object.toString();
                    return this.convertStringArrayToCollection(session, itemType, strValue);
                }
                if (className.equals("org.postgresql.util.PGobject")) {
                    Object[] objectArray;
                    Object value = PostgreUtils.extractPGObjectValue(object);
                    if (value instanceof String) {
                        return this.convertStringToCollection(session, type, itemType, (String)value);
                    }
                    DBDValueHandler dBDValueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType);
                    if (value == null) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = value;
                    }
                    return new JDBCCollection((DBSDataType)itemType, dBDValueHandler, objectArray);
                }
                return this.convertStringToCollection(session, type, itemType, (String)object);
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    private JDBCCollection convertStringToCollection(@NotNull DBCSession session, @NotNull DBSTypedObject arrayType, @NotNull PostgreDataType itemType, @NotNull String value) throws DBCException {
        PostgreDataType arrayDataType = PostgreUtils.findDataType(session, (PostgreDataSource)session.getDataSource(), arrayType);
        String delimiter = arrayDataType != null ? CommonUtils.toString((Object)arrayDataType.getArrayDelimiter(), (String)" ") : " ";
        if (itemType.getDataKind() == DBPDataKind.STRUCT) {
            List<Object> itemStrings = PostgreUtils.parseArrayString(value, delimiter);
            Object[] itemValues = new Object[itemStrings.size()];
            DBDValueHandler itemValueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType);
            int i = 0;
            while (i < itemStrings.size()) {
                Object itemValue;
                Object itemString = itemStrings.get(i);
                itemValues[i] = itemValue = itemValueHandler.getValueFromObject(session, (DBSTypedObject)itemType, itemString, false, false);
                ++i;
            }
            return new JDBCCollection((DBSDataType)itemType, itemValueHandler, itemValues);
        }
        List<Object> strings = PostgreUtils.parseArrayString(value, delimiter);
        Object[] contents = new Object[strings.size()];
        int i = 0;
        while (i < strings.size()) {
            contents[i] = PostgreUtils.convertStringToValue(session, (DBSTypedObject)itemType, String.valueOf(strings.get(i)), false);
            ++i;
        }
        return new JDBCCollection((DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), contents);
    }

    private JDBCCollection convertStringArrayToCollection(@NotNull DBCSession session, @NotNull PostgreDataType itemType, @NotNull String strValue) throws DBCException {
        String[] strings = PostgreUtils.parseObjectString(strValue.substring(1, strValue.length() - 1));
        Object[] contents = new Object[strings.length];
        int i = 0;
        while (i < strings.length) {
            contents[i] = PostgreUtils.convertStringToValue(session, (DBSTypedObject)itemType, strings[i], false);
            ++i;
        }
        return new JDBCCollection((DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), contents);
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (!DBUtils.isNullValue((Object)value) && value instanceof DBDCollection) {
            DBDCollection collection = (DBDCollection)value;
            DBDValueHandler valueHandler = collection.getComponentValueHandler();
            StringBuilder str = new StringBuilder();
            if (format == DBDDisplayFormat.NATIVE) {
                str.append("'");
            }
            str.append("{");
            int i = 0;
            while (i < collection.getItemCount()) {
                Object item;
                if (i > 0) {
                    str.append(',');
                }
                String itemString = (item = collection.getItem(i)) instanceof JDBCCollection ? this.getValueDisplayString(column, item, format) : valueHandler.getValueDisplayString((DBSTypedObject)collection.getComponentType(), item, DBDDisplayFormat.NATIVE);
                if (format == DBDDisplayFormat.NATIVE) {
                    str.append(SQLUtils.escapeString((DBPDataSource)collection.getComponentType().getDataSource(), (String)itemString));
                } else {
                    str.append(itemString);
                }
                ++i;
            }
            str.append("}");
            if (format == DBDDisplayFormat.NATIVE) {
                str.append("'");
            }
            return str.toString();
        }
        return super.getValueDisplayString(column, value, format);
    }
}

