/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DataSourcePreferenceStore
extends SimplePreferenceStore
implements IDataSourceContainerProvider {
    private final DataSourceDescriptor dataSourceDescriptor;

    DataSourcePreferenceStore(DataSourceDescriptor dataSourceDescriptor) {
        super(DBWorkbench.getPlatform().getPreferenceStore());
        this.dataSourceDescriptor = dataSourceDescriptor;
        Map defaultConnectionProperties = dataSourceDescriptor.getDriver().getDefaultConnectionProperties();
        for (Map.Entry prop : defaultConnectionProperties.entrySet()) {
            String propName = (String)prop.getKey();
            if (!propName.startsWith("@dbeaver-default-")) continue;
            this.getDefaultProperties().put(propName.substring("@dbeaver-default-".length()), CommonUtils.toString(prop.getValue()));
        }
    }

    public void save() throws IOException {
        this.dataSourceDescriptor.getRegistry().flushConfig();
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceDescriptor;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        super.firePropertyChangeEvent(name, oldValue, newValue);
        DBPPreferenceStore gps = DBWorkbench.getPlatform().getDataSourceProviderRegistry().getGlobalDataSourcePreferenceStore();
        if (gps instanceof AbstractPreferenceStore) {
            ((AbstractPreferenceStore)gps).firePropertyChangeEvent((Object)this, name, oldValue, newValue);
        }
    }
}

