/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.gis.internal.GISViewerActivator;
import org.jkiss.dbeaver.ui.gis.registry.GeometryViewerDescriptor;
import org.jkiss.dbeaver.ui.gis.registry.LeafletTilesDescriptor;
import org.jkiss.utils.CommonUtils;

public class GeometryViewerRegistry {
    private static final Log log = Log.getLog(GeometryViewerRegistry.class);
    private static GeometryViewerRegistry instance = null;
    private final Map<String, GeometryViewerDescriptor> viewers = new HashMap<String, GeometryViewerDescriptor>();
    private final List<LeafletTilesDescriptor> leafletTiles = new ArrayList<LeafletTilesDescriptor>();
    private LeafletTilesDescriptor defaultLeafletTiles = null;

    public static synchronized GeometryViewerRegistry getInstance() {
        if (instance == null) {
            instance = new GeometryViewerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private GeometryViewerRegistry(IExtensionRegistry registry) {
        AbstractDescriptor type;
        IConfigurationElement ext;
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.data.gis.geometryViewer");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            type = new GeometryViewerDescriptor(ext);
            this.viewers.put(type.getId(), (GeometryViewerDescriptor)type);
            ++n2;
        }
        iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.data.gis.leaflet.tiles");
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            type = new LeafletTilesDescriptor(ext);
            this.leafletTiles.add((LeafletTilesDescriptor)type);
            ++n2;
        }
        String defTilesId = GISViewerActivator.getDefault().getPreferences().getString("gis.view.defaultLeafletTiles");
        if (!CommonUtils.isEmpty((String)defTilesId)) {
            this.defaultLeafletTiles = (LeafletTilesDescriptor)DBUtils.findObject(this.leafletTiles, (String)defTilesId);
        }
        if (this.defaultLeafletTiles == null) {
            this.defaultLeafletTiles = this.leafletTiles.isEmpty() ? null : this.leafletTiles.get(0);
        }
    }

    public List<GeometryViewerDescriptor> getViewers() {
        return new ArrayList<GeometryViewerDescriptor>(this.viewers.values());
    }

    public List<GeometryViewerDescriptor> getSupportedViewers(DBPDataSource dataSource) {
        ArrayList<GeometryViewerDescriptor> result = new ArrayList<GeometryViewerDescriptor>();
        for (GeometryViewerDescriptor viewer : this.viewers.values()) {
            if (!viewer.supportedBy(dataSource)) continue;
            result.add(viewer);
        }
        return result;
    }

    public GeometryViewerDescriptor getViewer(String id) {
        return this.viewers.get(id);
    }

    public List<LeafletTilesDescriptor> getLeafletTiles() {
        return this.leafletTiles;
    }

    public LeafletTilesDescriptor getDefaultLeafletTiles() {
        return this.defaultLeafletTiles;
    }

    public void setDefaultLeafletTiles(LeafletTilesDescriptor defaultLeafletTiles) {
        this.defaultLeafletTiles = defaultLeafletTiles;
        GISViewerActivator.getDefault().getPreferences().setValue("gis.view.defaultLeafletTiles", this.defaultLeafletTiles == null ? "" : this.defaultLeafletTiles.getId());
        try {
            GISViewerActivator.getDefault().getPreferences().save();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }
}

