/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolVirtualSchema;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class ExasolSchemaManager
extends SQLObjectEditor<ExasolSchema, ExasolDataSource>
implements DBEObjectRenamer<ExasolSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<? extends DBSObject, ExasolSchema> getObjectsCache(ExasolSchema object) {
        ExasolDataSource source = object.getDataSource();
        return source.getSchemaCache();
    }

    public boolean canCreateObject(Object container) {
        return super.canCreateObject(container);
    }

    protected ExasolSchema createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBCException {
        boolean virtSchema;
        Object navContainer = options.get("container");
        boolean bl = virtSchema = navContainer instanceof DBNDatabaseFolder && ((DBNDatabaseFolder)navContainer).getChildrenClass() == ExasolVirtualSchema.class;
        if (virtSchema) {
            throw new DBCFeatureNotSupportedException();
        }
        return new ExasolSchema((ExasolDataSource)((Object)container), "NEW_SCHEMA", "");
    }

    private void changeLimit(List<DBEPersistAction> actions, ExasolSchema schema, BigDecimal limit) {
        String script = String.format("ALTER SCHEMA %s SET RAW_SIZE_LIMIT = %d", DBUtils.getQuotedIdentifier((DBSObject)schema), limit.longValue());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_schema_raw_limit, script));
    }

    private void changeOwner(List<DBEPersistAction> actions, ExasolSchema schema, String owner) {
        String script = "ALTER SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema) + " CHANGE OWNER  " + owner;
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_schema_owner, script));
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolSchema schema = (ExasolSchema)command.getObject();
        String script = "CREATE SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_schema_create, script));
        String owner = schema.getOwner();
        if (owner != null) {
            this.changeOwner(actions, schema, owner);
        }
        if (schema.getRawObjectSizeLimit() != null) {
            this.changeLimit(actions, schema, schema.getRawObjectSizeLimit());
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " CASCADE"));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolSchema obj = (ExasolSchema)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename Schema", "RENAME SCHEMA " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }

    public void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        ExasolSchema schema = (ExasolSchema)command.getObject();
        if (command.getProperties().size() >= 1) {
            if (command.getProperties().containsKey("description")) {
                String script = "COMMENT ON SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema) + " IS '" + ExasolUtils.quoteString((String)CommonUtils.notNull((Object)schema.getDescription(), (Object)"")) + "'";
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Change comment on Schema", script));
            }
            if (command.getProperties().containsKey("owner")) {
                this.changeOwner(actionList, schema, schema.getOwner());
            }
            if (command.getProperties().containsKey("rawObjectSizeLimit")) {
                this.changeLimit(actionList, schema, schema.getRawObjectSizeLimit());
            }
        }
    }

    public void renameObject(DBECommandContext commandContext, ExasolSchema object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }
}

