/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef GUI_GAME_HPP
#define GUI_GAME_HPP

#include "Game.hpp"

class GuiGame : public Game {
public:
  GuiGame();
  ~GuiGame();

  virtual void getPlayers();
  virtual void setOptions();
  virtual void updateStatus(char* statusStr);

  void setCardBack(int which);
  void showPrevTrickDiag();
  void hidePrevTrickDiag();
  void incrPrevTrickDiag(int incrVal);
  
protected:
  virtual void processEvent(Event ev);
  virtual void resetForGame();
  virtual void resetForDeal();
  virtual void setTopCard();

  virtual void auctionCont();
  virtual void auctionEnd();
  virtual void bidMade(Common::PlayerPosition who, Common::Bid theBid);
  virtual void discardStart();
  virtual void roundStart();
  virtual void roundCont();
  virtual void roundEnd();
  virtual void cardPlayed(Common::PlayerPosition who, const Card& theCard);
  virtual void allPass();
  virtual void gameEnd();
  virtual void gameEndForReal();
  virtual void updateTrickCounts(Common::PlayerPosition theWinner);
  virtual void delayBetweenPlays();
  virtual void pause();
  virtual void unpause();

  virtual void updateLonerPoints();
  virtual void updateTakeAllPoints();
  virtual void updateTakeEnufPoints();
  virtual void updateSetPoints();

  Player* getComputerPlayer(Common::PlayerPosition pos);
  void    updateLabels();
  void    updateStatus();
  void    hideTopCard();
  char*   getPauseText();
  void    setMainLabelColors();
  void    setAuctionLabelColors();

  void    configPrevTrickDiag();
  void    clearPrevTrickDiag();
  
  void    setTimeout(unsigned int milliseconds);

  enum Labels {
    LEADER = 0,
    SUITLED,
    WINNER,
    NSTRICKS,
    EWTRICKS,
    TRUMP,
    CALLER,
    DEALER,
    NSPOINTS,
    EWPOINTS,
    NUMLABELS
  };

  Common::PlayerPosition itsOldLeader;
  
  GtkWidget* itsLabels[NUMLABELS];
  char*      itsLabelText[NUMLABELS];
  int*       itsLabelVars[NUMLABELS];
  
  GtkWidget* itsLabelTables[3];

  GtkWidget* itsStatus;
  char       itsStatusText[100];

  GtkWidget* itsMainwinNames[Common::PLAYERS_PER_GAME];
  GtkStyle*  itsOrigLabelStyle;
  GtkStyle*  itsBlueLabelStyle;
  GtkStyle*  itsRedLabelStyle;
  GtkStyle*  itsPurpleLabelStyle;

  GtkStyle*  itsOrigMainwinNameLabelStyle;
  GtkStyle*  itsNewMainwinNameLabelStyle;

  GtkStyle*  itsOrigAuctionNameLabelStyle;
  GtkStyle*  itsNewAuctionNameLabelStyle;

  GtkWidget* itsPrevTrickTable;
  GtkWidget* itsPrevTrickPixmapsOrig[Common::PLAYERS_PER_GAME];
  GtkWidget* itsPrevTrickPixmapsCur[Common::PLAYERS_PER_GAME];
  GtkWidget* itsPrevTrickButtons[2];
  GtkWidget* itsPrevTrickNumber;
  GtkWidget* itsPrevTrickLed;
  GtkWidget* itsPrevTrickWinner;
  int        itsPrevTrickVisible;
  int        itsPrevTrickCounter;
  int        itsPrevTrickCoords[Common::PLAYERS_PER_GAME][4];
  
  int        itsHasTimeout;
  int        itsTimeoutTag;
};
#endif
