/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <ctype.h>

#include <Debug.hpp>

#include "globals.hpp"
#include "support.hpp"
#include "GuiOptions.hpp"

GuiOptions::GuiOptions() {
  itsShowTrickStats = 1;
  itsShowRoundStats = 1;
  itsShowGameStats  = 1;
  itsCardBack       = 0;
}

void GuiOptions::init() {
  /* do base class init */
  Options::init();

  /* now update gui */
  updateGui();
}

int GuiOptions::load() {
  Options::load();
  updateGui();
}

void GuiOptions::updateGui() {
  GtkWidget* temp;
  char       widget_name[100];

  /* get skill and aggression settings */
  for (int i = 0; i < Common::PLAYERS_PER_GAME; i++) {
    if (i == Common::SOUTH) {
      continue;
    }

    char c = Common::getPlayerPositionChar((Common::PlayerPosition) i);
    c = tolower(c);

    sprintf(widget_name, "%cskill", c);
    temp = lookup_widget(prefdiag,  widget_name);

    GtkAdjustment* adj = gtk_range_get_adjustment(GTK_RANGE(temp));
    gtk_adjustment_set_value(adj, itsLevel[i]);

    sprintf(widget_name, "%cagg", c);
    temp = lookup_widget(prefdiag,  widget_name);

    adj = gtk_range_get_adjustment(GTK_RANGE(temp));
    gtk_adjustment_set_value(adj, itsAgg[i]);
  }

  for (int i = Options::NODELAY; i < (Options::PAUSE+1); i++) {
    sprintf(widget_name, "delay_style_%d", i);
    temp = lookup_widget(prefdiag, widget_name);
    if (itsDelayMode == (DelayMode) i) {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), true);
    } else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), false);
    }
  }

  temp = lookup_widget(prefdiag, "tricks_one_point");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), itsTricksOnePoint);

  temp = lookup_widget(prefdiag, "points_for_game");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), itsPointsForGame);

  temp = lookup_widget(prefdiag, "show_trick_stats");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), itsShowTrickStats);

  temp = lookup_widget(prefdiag, "show_round_stats");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), itsShowRoundStats);

  temp = lookup_widget(prefdiag, "show_game_stats");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), itsShowGameStats);

  temp = lookup_widget(prefdiag, "delay_between_plays");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), itsDelayBetweenPlays);

  temp = lookup_widget(prefdiag, "play_for_me");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), itsAutoPlay);

  temp = lookup_widget(prefdiag, "auto_deal_end");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), itsAutoDealEnd);

  temp = lookup_widget(prefdiag, "partner_loner");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), itsPartnerLoner);

  temp = lookup_widget(prefdiag, "stick_the_dealer");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), itsStickTheDealer);

  for (int i = 0; i < NUM_CARD_BACKS; i++) {
    sprintf(widget_name, "cardback%d_button", i);
    temp = lookup_widget(prefdiag, widget_name);
    if (itsCardBack == i) {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), true);
    } else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), false);
    }
  }
}

void GuiOptions::configure() {
  LOG("enter GuiOptions::configure()\n");

  GtkWidget* temp;
  char       widget_name[100];

  /* get skill and aggression settings */
  for (int i = 0; i < Common::PLAYERS_PER_GAME; i++) {
    if (i == Common::SOUTH) {
      continue;
    }

    char c = Common::getPlayerPositionChar((Common::PlayerPosition) i);
    c = tolower(c);

    sprintf(widget_name, "%cskill", c);
    temp = lookup_widget(prefdiag,  widget_name);
    GtkAdjustment* adj = gtk_range_get_adjustment(GTK_RANGE(temp));
    itsLevel[i] = /*(AILevel)*/ (int) adj->value;

    sprintf(widget_name, "%cagg", c);
    temp = lookup_widget(prefdiag,  widget_name);
    adj = gtk_range_get_adjustment(GTK_RANGE(temp));
    itsAgg[i] = /*(AIAgg)*/ (int) adj->value;
  }

  for (int i = Options::NODELAY; i < (Options::PAUSE+1); i++) {
    sprintf(widget_name, "delay_style_%d", i);
    temp = lookup_widget(prefdiag, widget_name);
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      itsDelayMode = (DelayMode) i;
      break;
    }
  }

  temp = lookup_widget(prefdiag, "tricks_one_point");
  itsTricksOnePoint = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(prefdiag, "points_for_game");
  itsPointsForGame = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(prefdiag, "show_trick_stats");
  itsShowTrickStats = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(prefdiag, "show_round_stats");
  itsShowRoundStats = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(prefdiag, "show_game_stats");
  itsShowGameStats = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(prefdiag, "delay_between_plays");
  itsDelayBetweenPlays = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(prefdiag, "play_for_me");
  itsAutoPlay = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(prefdiag, "auto_deal_end");
  itsAutoDealEnd = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  
  temp = lookup_widget(prefdiag, "partner_loner");
  itsPartnerLoner = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  
  temp = lookup_widget(prefdiag, "stick_the_dealer");
  itsStickTheDealer = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  
  for (int i = 0; i < NUM_CARD_BACKS; i++) {
    sprintf(widget_name, "cardback%d_button", i);
    temp = lookup_widget(prefdiag, widget_name);
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      itsCardBack = i;
      break;
    }
  }

  /* save off the new settings so they will be automatically restored
     the next time we start up */
  save();

  LOG("exit GuiOptions::configure()\n");
}

int GuiOptions::writeOutOptions(FILE *out) {
  Options::writeOutOptions(out);

  fprintf(out, "%d %d %d %d\n", itsShowTrickStats, itsShowRoundStats,
	  itsShowGameStats, itsCardBack);

  fclose(out);
  return 0;
}

int GuiOptions::readInOptions(FILE *in) {
  Options::readInOptions(in);

  if (itsVersion == CURRENT_VERSION) {
    LOG("good version\n");
    fscanf(in, "%d %d %d %d", &itsShowTrickStats, &itsShowRoundStats,
	   &itsShowGameStats, &itsCardBack);
  } else {
    LOG("bad version\n");
    fscanf(in, "%d %d %d", &itsShowTrickStats, &itsShowRoundStats,
	   &itsShowGameStats);
  }

  LOG("itsShowTrickStats is %d, itsCardBack is %d\n", itsShowTrickStats, itsCardBack);

  fclose(in);
  return 0;
}

GuiOptions* GuiOptions::get() {
  return (GuiOptions*) itsOptions;
}

void GuiOptions::set(GuiOptions* opt) {
  Options::set(opt);
}
