/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef GUI_OPTIONS_HPP
#define GUI_OPTIONS_HPP

#include <Options.hpp>

class GuiOptions : public Options {
public:
  GuiOptions();
  ~GuiOptions();

  virtual void init();
  virtual int  load();

  void         configure();

  static  GuiOptions*  get();
  static  void         set(GuiOptions* opt);

  int getShowTrickStats() { return itsShowTrickStats; }
  int getShowRoundStats() { return itsShowRoundStats; }
  int getShowGameStats() { return itsShowGameStats; }

  int getCardBack() { return itsCardBack; }
  
protected:
  virtual int writeOutOptions(FILE *out);
  virtual int readInOptions(FILE *in);
  void        updateGui();

  int itsShowTrickStats;
  int itsShowRoundStats;
  int itsShowGameStats;
  int itsCardBack;
};

#endif
