/*

Euchre - a free as in freedom and as in beer version of the 
euchre card game
  
Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>

#include <Debug.hpp>
  
#include "globals.hpp"
#include "support.hpp"
#include "GuiPlayer.hpp"

GuiPlayer::GuiPlayer(Common::PlayerPosition myPos) : itsPlPos(myPos) {
  char pixname[100];
  switch (myPos) {
  case Common::NORTH:
    sprintf(pixname, "nplayedcard");
    itsCardCoords[0] = 3;
    itsCardCoords[1] = 6;
    itsCardCoords[2] = 1;
    itsCardCoords[3] = 2;

    itsSuitCoords[0] = 5;
    itsSuitCoords[1] = 6;
    itsSuitCoords[2] = 0;
    itsSuitCoords[3] = 1;

    itsBidCoords[0] = 3;
    itsBidCoords[1] = 4;
    itsBidCoords[2] = 0;
    itsBidCoords[3] = 1;

    itsMarkerCoords[0] = 1;
    itsMarkerCoords[1] = 2;
    itsMarkerCoords[2] = 0;
    itsMarkerCoords[3] = 1;
    
    break;

  case Common::EAST:
    sprintf(pixname, "eplayedcard");
    itsCardCoords[0] = 6;
    itsCardCoords[1] = 7;
    itsCardCoords[2] = 2;
    itsCardCoords[3] = 5;

    itsSuitCoords[0] = 7;
    itsSuitCoords[1] = 8;
    itsSuitCoords[2] = 4;
    itsSuitCoords[3] = 5;

    itsBidCoords[0] = 7;
    itsBidCoords[1] = 8;
    itsBidCoords[2] = 2;
    itsBidCoords[3] = 3;

    itsMarkerCoords[0] = 2;
    itsMarkerCoords[1] = 3;
    itsMarkerCoords[2] = 1;
    itsMarkerCoords[3] = 2;
    break;

  case Common::SOUTH:
    sprintf(pixname, "splayedcard");
    itsCardCoords[0] = 3;
    itsCardCoords[1] = 6;
    itsCardCoords[2] = 5;
    itsCardCoords[3] = 6;

    itsSuitCoords[0] = 5;
    itsSuitCoords[1] = 6;
    itsSuitCoords[2] = 7;
    itsSuitCoords[3] = 8;

    itsBidCoords[0] = 3;
    itsBidCoords[1] = 4;
    itsBidCoords[2] = 7;
    itsBidCoords[3] = 8;

    itsMarkerCoords[0] = 1;
    itsMarkerCoords[1] = 2;
    itsMarkerCoords[2] = 2;
    itsMarkerCoords[3] = 3;
    break;

  case Common::WEST:
    sprintf(pixname, "wplayedcard");
    itsCardCoords[0] = 2;
    itsCardCoords[1] = 3;
    itsCardCoords[2] = 2;
    itsCardCoords[3] = 5;

    itsSuitCoords[0] = 1;
    itsSuitCoords[1] = 2;
    itsSuitCoords[2] = 4;
    itsSuitCoords[3] = 5;

    itsBidCoords[0] = 1;
    itsBidCoords[1] = 2;
    itsBidCoords[2] = 2;
    itsBidCoords[3] = 3;

    itsMarkerCoords[0] = 0;
    itsMarkerCoords[1] = 1;
    itsMarkerCoords[2] = 1;
    itsMarkerCoords[3] = 2;
    break;

  default:
    LOG("position %d uh-oh!\n", myPos);
    break;
  }

  itsTable         = lookup_widget(mainwin, "table1");
  itsMarkerTable   = lookup_widget(mainwin, "marker_table");
  itsPixmap        = lookup_widget(mainwin, pixname);
  itsOldPixmap     = itsPixmap;
  itsBidSuitPixmap = NULL;
  itsBidCallPixmap = NULL;
  itsMarkerPixmap  = NULL;
  
  if (GTK_WIDGET(bidSuitEmptyPixmaps[itsPlPos])->parent != NULL) {
    gtk_container_remove(GTK_CONTAINER(itsTable),
			 bidSuitEmptyPixmaps[itsPlPos]);
  }
  gtk_table_attach(GTK_TABLE(itsTable), bidSuitEmptyPixmaps[itsPlPos],
		   itsSuitCoords[0], itsSuitCoords[1],
		   itsSuitCoords[2], itsSuitCoords[3],
		   (GtkAttachOptions) (GTK_FILL),
		   (GtkAttachOptions) (GTK_FILL), 0, 0);

  if (GTK_WIDGET(bidEmptyPixmaps[itsPlPos])->parent != NULL) {
    gtk_container_remove(GTK_CONTAINER(itsTable), bidEmptyPixmaps[itsPlPos]);
  }
  gtk_table_attach(GTK_TABLE(itsTable), bidEmptyPixmaps[itsPlPos],
		   itsBidCoords[0], itsBidCoords[1],
		   itsBidCoords[2], itsBidCoords[3],
		   (GtkAttachOptions) (GTK_FILL),
		   (GtkAttachOptions) (GTK_FILL), 0, 0);

  LOG("about to remove marker for %d\n", itsPlPos);  
  if (GTK_WIDGET(emptyMarkers[itsPlPos])->parent != NULL) {
    gtk_widget_ref(emptyMarkers[itsPlPos]);
    gtk_container_remove(GTK_CONTAINER(itsMarkerTable), emptyMarkers[itsPlPos]);
  }
  gtk_table_attach(GTK_TABLE(itsMarkerTable), emptyMarkers[itsPlPos],
		   itsMarkerCoords[0], itsMarkerCoords[1],
		   itsMarkerCoords[2], itsMarkerCoords[3],
		   (GtkAttachOptions) (GTK_FILL),
		   (GtkAttachOptions) (GTK_FILL), 0, 0);
}

GuiPlayer::~GuiPlayer() {
  if (itsPixmap != itsOldPixmap) {
    setCardPixmap(itsOldPixmap);
  }

  setBidSuitPixmap(NULL);
  setMarker(NULL);
}

void GuiPlayer::setCardPixmap(GtkWidget* pixmap) {
  // don't repack the same thing
  if (itsPixmap == pixmap) {
    return;
  }

  // hack to keep our pixmaps from being deleted by 0 references
  if (GTK_OBJECT(itsPixmap)->ref_count == 1) {
    gtk_widget_ref(itsPixmap);
  }

  // remove the old pixmap
  gtk_container_remove(GTK_CONTAINER(itsTable), itsPixmap);

  // and add the new one
  itsPixmap = pixmap;
  gtk_table_attach(GTK_TABLE(itsTable), itsPixmap, itsCardCoords[0],
		   itsCardCoords[1], itsCardCoords[2], itsCardCoords[3],
		   (GtkAttachOptions) (GTK_FILL),
		   (GtkAttachOptions) (GTK_FILL), 0, 0);
}

void GuiPlayer::setBidSuitPixmap(GtkWidget* pixmap) {
  /* if NULL then remove the pixmap */
  if (pixmap == NULL) {
    if (itsBidSuitPixmap != NULL) {
      // hack to keep our pixmaps from being deleted by 0 references
      if (GTK_OBJECT(itsBidSuitPixmap)->ref_count == 1) {
	gtk_widget_ref(itsBidSuitPixmap);
      }

      // remove the bid pixmap
      gtk_container_remove(GTK_CONTAINER(itsTable), itsBidSuitPixmap);

      // remember that it's gone
      itsBidSuitPixmap = NULL;

      // fill the empty space with a transparent pixmap 
      gtk_table_attach(GTK_TABLE(itsTable), bidSuitEmptyPixmaps[itsPlPos],
		       itsSuitCoords[0], itsSuitCoords[1],
		       itsSuitCoords[2], itsSuitCoords[3],
		       (GtkAttachOptions) (GTK_FILL),
		       (GtkAttachOptions) (GTK_FILL), 0, 0);
    }
  } else {
    // set the pixmap
    itsBidSuitPixmap = pixmap;
    gtk_container_remove(GTK_CONTAINER(itsTable), bidSuitEmptyPixmaps[itsPlPos]);
    gtk_table_attach(GTK_TABLE(itsTable), itsBidSuitPixmap, itsSuitCoords[0],
		     itsSuitCoords[1], itsSuitCoords[2], itsSuitCoords[3],
		     (GtkAttachOptions) (GTK_FILL),
		     (GtkAttachOptions) (GTK_FILL), 0, 0);
  }
}

void GuiPlayer::setBidCallPixmap(GtkWidget* pixmap) {
  /* if NULL then remove the pixmap */
  if (pixmap == NULL) {
    if (itsBidCallPixmap != NULL) {
      // hack to keep our pixmaps from being deleted by 0 references
      if (GTK_OBJECT(itsBidCallPixmap)->ref_count == 1) {
	gtk_widget_ref(itsBidCallPixmap);
      }

      // remove the bid pixmap
      gtk_container_remove(GTK_CONTAINER(itsTable), itsBidCallPixmap);

      // remember that it's gone
      itsBidCallPixmap = NULL;

      // fill the empty space with a transparent pixmap 
      gtk_table_attach(GTK_TABLE(itsTable), bidEmptyPixmaps[itsPlPos],
		       itsBidCoords[0], itsBidCoords[1],
		       itsBidCoords[2], itsBidCoords[3],
		       (GtkAttachOptions) (GTK_FILL),
		       (GtkAttachOptions) (GTK_FILL), 0, 0);
    }
  } else {
    // set the pixmap
    itsBidCallPixmap = pixmap;
    gtk_container_remove(GTK_CONTAINER(itsTable), bidEmptyPixmaps[itsPlPos]);
    gtk_table_attach(GTK_TABLE(itsTable), itsBidCallPixmap, itsBidCoords[0],
		     itsBidCoords[1], itsBidCoords[2], itsBidCoords[3],
		     (GtkAttachOptions) (GTK_FILL),
		     (GtkAttachOptions) (GTK_FILL), 0, 0);
  }
}

void GuiPlayer::setMarker(GtkWidget* pixmap) {
  /* if NULL then remove the pixmap */
  if (pixmap == NULL) {
    if (itsMarkerPixmap != NULL) {
      // hack to keep our pixmaps from being deleted by 0 references
      if (GTK_OBJECT(itsMarkerPixmap)->ref_count == 1) {
	gtk_widget_ref(itsMarkerPixmap);
      }

      // remove the bid pixmap
      gtk_container_remove(GTK_CONTAINER(itsMarkerTable), itsMarkerPixmap);

      // remember that it's gone
      itsMarkerPixmap = NULL;

      // fill the empty space with a transparent pixmap 
      gtk_table_attach(GTK_TABLE(itsMarkerTable), emptyMarkers[itsPlPos],
		       itsMarkerCoords[0], itsMarkerCoords[1],
		       itsMarkerCoords[2], itsMarkerCoords[3],
		       (GtkAttachOptions) (GTK_FILL),
		       (GtkAttachOptions) (GTK_FILL), 0, 0);
    }
  } else {
    // set the pixmap
    itsMarkerPixmap = pixmap;
    gtk_container_remove(GTK_CONTAINER(itsMarkerTable), emptyMarkers[itsPlPos]);
    gtk_table_attach(GTK_TABLE(itsMarkerTable), itsMarkerPixmap,
		     itsMarkerCoords[0], itsMarkerCoords[1],
		     itsMarkerCoords[2], itsMarkerCoords[3],
		     (GtkAttachOptions) (GTK_FILL),
		     (GtkAttachOptions) (GTK_FILL), 0, 0);
  }
}
