/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef GUI_PLAYER_HPP
#define GUI_PLAYER_HPP

#include <gtk/gtk.h>
#include <Common.hpp>

class GuiPlayer {
public:
  GuiPlayer(Common::PlayerPosition myPos);
  virtual ~GuiPlayer();

protected:
  void setCardPixmap(GtkWidget* pixmap);
  void setBidSuitPixmap(GtkWidget* pixmap);
  void setBidCallPixmap(GtkWidget* pixmap);
  void setMarker(GtkWidget* pixmap);
  
  Common::PlayerPosition itsPlPos;
  GtkWidget*             itsTable;
  GtkWidget*             itsMarkerTable;
  GtkWidget*             itsPixmap;
  GtkWidget*             itsOldPixmap;
  GtkWidget*             itsBidSuitPixmap;
  GtkWidget*             itsBidCallPixmap;
  GtkWidget*             itsMarkerPixmap;
  int                    itsCardCoords[4];
  int                    itsSuitCoords[4];
  int                    itsBidCoords[4];
  int                    itsMarkerCoords[4];
};

#endif
