/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef CARD_HPP
#define CARD_HPP

#include <string>
using std::string;

class Card {
public:
  /* The Card Suits */
  enum Suit {
    NoSuit   = -1,
    Diamonds = 0,
    Clubs    = 1,
    Hearts   = 2,
    Spades   = 3
  };

  /* The Card Number */
  enum Number {
    NoNumber = -1,
    Nine     = 0,
    Ten      = 1,
    Jack     = 2,
    Queen    = 3,
    King     = 4,
    Ace      = 5
  };

  /* The Card Value */
  enum Value {
    NonTrumpLow  = Nine,
    NonTrumpHigh = Ace,
    TrumpAdj     = 6,
    JackTrumpVal = 13,
    JackPartVal  = 12
  };

  Card();
  Card(Suit aSuit, Number aNumber);
  ~Card();

  static char  getSuitChar(Suit suit);
  static char* getSuitStr(Suit suit);
  static char  getNumberChar(Number number);

  static Suit getPartnerSuit(Suit suit);

  char   getSuitChar() const;
  char*  getSuitStr() const;
  Suit   getSuit() const;
  Suit   getAdjSuit() const;

  char   getNumberChar() const;
  Number getNumber() const;

  const char*  getName() const;

  /* check the suit of the card versus the passed in suit.  The first
     assumes that Common::getTrump() will return trump, the second
     let's the caller specify trump */
  int    isSuit(const Suit aSuit) const;
  int    isSuit(const Suit aSuit, const Suit aTrump) const;

  /* get the value of a card.  The first assumes that
     Common::getTrump() will return trump, the second let's the caller
     specify trump */
  int    getValue() const;
  int    getValue(const Suit aTrump) const;

  void   setSuit(const Suit aSuit) { itsSuit = aSuit; }
  void   setNumber(Number aNumber) { itsNumber = aNumber; }
  void   setName() {
    itsName = getNumberChar();
    itsName += getSuitChar(itsSuit);
  }

  int    operator==(const Card& card) const;
  int    operator!=(const Card& card) const;
 
protected:
  Suit   itsSuit;
  Number itsNumber;
  string   itsName;
};

#endif /* CARD_HPP */
