/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "Common.hpp"

Common::PlayerPosition Common::getPartner(PlayerPosition pp) {
  return (PlayerPosition) ((pp + 2) % (WEST + 1));
}

char Common::getPlayerPositionChar(PlayerPosition pp) {
  char c = 'X';

  switch (pp) {
  case NORTH:
    c = 'N';
    break;

  case EAST:
    c = 'E';
    break;

  case SOUTH:
    c = 'S';
    break;

  case WEST:
    c = 'W';
    break;
  }

  return c;
}

static char* PlayerPositionStrings[] = {
  "North", "East", "South", "West", "None"
};

char* Common::getPlayerPositionStr(PlayerPosition pp) {
  if (pp < NORTH || pp > WEST) {
    pp = (PlayerPosition) (WEST + 1);
  }


  return PlayerPositionStrings[pp];
}

static char* BidStrings[] = {
  "No Bid", "Pass", "Called It", "Loner"
};

char* Common::getBidStr(Bid bid) {
  if (bid < NOBID || bid > LONER) {
    return 0;
  }

  return BidStrings[bid];
}

static Card::Suit trump = Card::NoSuit;
void Common::setTrump(const Card::Suit aTrump) {
  trump = aTrump;
}

Card::Suit Common::getTrump() {
  return trump;
}

