/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <time.h>
#include <stdlib.h>

#include "Debug.hpp"
#include "Deck.hpp"

Deck::Deck() {
  init();
}

Deck::~Deck() {}

void Deck::init() {
  int index = 0;
  Card card;

  srand(time(NULL));

  for (int s = Card::Diamonds; s <= Card::Spades; s++) {
    for (int n = Card::Nine; n <= Card::Ace; n++) {
      card.setSuit((Card::Suit)s);
      card.setNumber((Card::Number)n);
      card.setName();

      itsCards[index++] = card;
    }
  }

  itsCardsInDeck = NUM_CARDS;
}

Card Deck::removeCard() {
  int index;
  int counter = 0;
  int semi_rand = ((rand() % itsCardsInDeck) + 1);

  for (index = 0; index < NUM_CARDS; index++) {
    if (itsCards[index].getSuit() != Card::NoSuit) {
      counter++;
    }

    if (counter == semi_rand) {
      break;
    }
  }

  return removeCard(index);
}

void Deck::removeCard(const Card& card) {
  for (int i = 0; i < NUM_CARDS; i++) {
    if (itsCards[i] == card) {
      removeCard(i);
      break;
    }
  }
}

Card Deck::removeCard(int index) {
  Card c;

  if (index < 0 || index >= NUM_CARDS) {
    return c;
  }

  c = itsCards[index];

  itsCards[index].setSuit(Card::NoSuit);
  itsCards[index].setNumber(Card::NoNumber);
  itsCardsInDeck--;

  return c;
}

void Deck::addCard(const Card& card) {
  if (itsCardsInDeck == NUM_CARDS) {
    return;
  }

  itsCards[itsCardsInDeck++] = card;
}

const char* Deck::getCards() {
  for (int i = 0; i < Deck::NUM_CARDS; i++) {
    if (itsCards[i].getSuit() != Card::NoSuit) {
      s += itsCards[i].getName() + ' ';
    }
  }

  return s.c_str();
}
