/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "Debug.hpp"
#include "Player.hpp"

Player::Player(Common::PlayerPosition myPos) : 
  itsPos(myPos),
  itsPartnerPos(Common::getPartner(itsPos)),
  itsBid(Common::NOBID) {}
Player::~Player() {};

void Player::setHand(const Hand& theHand) {
  itsHand = theHand;
}

void Player::sortHand() {
  Hand copyHand = itsHand;

  /* sort the hand */
  int counter = 0;
  for (int s = Card::Diamonds; s <= Card::Spades; s++) {
    for (int n = Card::NonTrumpLow; n <= Card::JackTrumpVal; n++) {
      for (int i = 0; i < Common::CARDS_PER_HAND; i++) {
	if (copyHand.getCard(i).isSuit((Card::Suit) s) &&
	    copyHand.getCard(i).getValue() == n) {
	  itsHand.setCard(counter++, copyHand.getCard(i));
	}
      }
    }
  }
}

void Player::assignBid(Common::Bid bid, Card::Suit trump) {
  itsBid         = bid;
  itsCalledTrump = trump;
}

int Player::isInteractive() const {
  return 0;
}

void Player::setTopCard(const Card& upCard) {
}

void Player::unsetTopCard() {

}

void Player::auction1End(const Card& upCard) {

}

void Player::setBid(Common::PlayerPosition who, Common::Bid bid) {

}

void Player::setTrump(Card::Suit trump) {

}

void Player::finishRound(const Round& theRound,
			 Common::PlayerPosition whoStarted) {

}

void Player::finishDeal(int NSPoints, int EWPoints) {

}

void Player::allPass() {

}

const char* Player::toString() {
  str = Common::getPlayerPositionChar(this->itsPos) 
    + ' ' + this->itsHand.getName();
  return str.c_str();
}
