/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef PLAYER_HPP
#define PLAYER_HPP

#include "Common.hpp"
#include "Hand.hpp"
#include "Round.hpp"

class Player {
public:
  Player(Common::PlayerPosition myPos);
  virtual ~Player() = 0;

  Common::PlayerPosition getPos() const { return itsPos; }
  const Hand&            getHand() const { return itsHand; }
  Common::Bid            getBid() const { return itsBid; }
  void                   resetBid() { itsBid = Common::NOBID; }

  /* this is called to set the hand for this player */
  virtual void setHand(const Hand& theHand);

  /* this is called to set the bid for this player */
  virtual void assignBid(Common::Bid bid, Card::Suit trump = Card::NoSuit);

  /* this is called to tell if the player object is interactive or not */
  virtual int isInteractive() const;

  /* this is called to set the top card.  this is only called if the
     player is the dealer. */
  virtual void setTopCard(const Card& upCard);

  /* this is called to clear the top card.  this is also only called
     if the player is the dealer. */
  virtual void unsetTopCard();
  
  /* this is called to get the bid for the first auction (dealers
     picks up) */
  virtual Common::Bid auction1(const Card& upCard,
			       Common::PlayerPosition dealer) = 0;

  /* this is called to tell the player the first auction has ended
     with no bid */
  virtual void auction1End(const Card& upCard);

  /* this is called to name your own trump.  if stuck is true then you
     must bid. */
  virtual Common::Bid auction2(Card& yourTrump,
			       const Card& upCard,
			       bool stuck) = 0;

  /* this is called to get the discard when you are dealer */
  virtual Card discard(Card& newCard) = 0;

  /* this is called to notify the player when a bid is made */
  virtual void setBid(Common::PlayerPosition who,
		      Common::Bid bid);

  /* this is called to notify the player when trump is set */
  virtual void setTrump(Card::Suit trump);

  /* this is called to get the next card to play */
  virtual Card getCard(const Round& theRound, 
		       Common::PlayerPosition whoStarted) = 0;

  /* this is called after each round finishes */
  virtual void finishRound(const Round& theRound,
			   Common::PlayerPosition whoStarted);

  /* this is called after each deal finishes */
  virtual void finishDeal(int NSPoints, int EWPoints);

  /* this is called whenever a deal is passed by everyone for both
     auctions.  in this case finishDeal is not called */
  virtual void allPass();

  virtual const char* toString();

protected:
  /* this method sorts itsHand */
  virtual void sortHand();

  Hand                   itsHand;
  Common::PlayerPosition itsPos;
  Common::PlayerPosition itsPartnerPos;
  Common::Bid            itsBid;
  Card::Suit             itsCalledTrump;
  string str;
};

#endif /* PLAYER_HPP */

