/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef ROUND_HPP
#define ROUND_HPP

#include "Common.hpp"
#include "Card.hpp"

class Round {
public:
  Round();
  ~Round();

  Card::Suit getSuit(Common::PlayerPosition pos) const;
  Card       getCard(Common::PlayerPosition pos) const;
  void       setCard(Common::PlayerPosition pos, Card card);
  void       reset();

  Common::PlayerPosition getWinner(Common::PlayerPosition start,
				   Card::Suit trump) const;

  void       printRound();

protected:
  Card itsCards[Common::CARDS_PER_ROUND];
};

#endif /* ROUND_HPP */

