/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionArrayAggregate;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.Type;

public interface ExpressionJSON {

    public static class ExpressionJSONObjectAgg
    extends Expression {
        final ExpressionArrayAggregate namesAgg;
        final ExpressionArrayAggregate valuesAgg;
        final boolean nullOnNull;
        final boolean uniqueKeys;
        boolean isValueJSON;

        public ExpressionJSONObjectAgg(ExpressionArrayAggregate expressionArrayAggregate, ExpressionArrayAggregate expressionArrayAggregate2, boolean bl, boolean bl2, Type type) {
            super(103);
            this.namesAgg = expressionArrayAggregate;
            this.valuesAgg = expressionArrayAggregate2;
            this.nullOnNull = bl;
            this.uniqueKeys = bl2;
            this.dataType = type == null ? Type.SQL_VARCHAR_LONG : type;
            this.isValueJSON = expressionArrayAggregate2.exprOpType == 103;
            this.nodes = new Expression[]{expressionArrayAggregate, expressionArrayAggregate2};
        }

        @Override
        public void resolveTypes(Session session, Expression expression) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].resolveTypes(session, this);
            }
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            Object[] objectArray = (Object[])this.nodes[0].getValue(session);
            Object[] objectArray2 = (Object[])this.nodes[1].getValue(session);
            Type type = this.nodes[0].dataType.collectionBaseType();
            Type type2 = this.nodes[1].dataType.collectionBaseType();
            OrderedHashSet<String> orderedHashSet = new OrderedHashSet<String>();
            stringBuilder.append('{');
            for (int i = 0; i < objectArray.length; ++i) {
                String string;
                String string2 = (String)objectArray[i];
                String string3 = (String)objectArray2[i];
                if (string2 == null || !this.nullOnNull && string3 == null) continue;
                if (n > 0) {
                    stringBuilder.append(',');
                }
                if (this.uniqueKeys && !orderedHashSet.add(string = type.convertToString(string2))) {
                    throw Error.error(104);
                }
                if (type.isCharacterType()) {
                    type.convertToJSON(string2, stringBuilder);
                } else {
                    string = type.convertToString(string2);
                    string = StringConverter.toQuotedString(string, '\"', false);
                    stringBuilder.append(string);
                }
                stringBuilder.append(':');
                if (this.isValueJSON) {
                    stringBuilder.append(string3);
                } else {
                    type2.convertToJSON(string3, stringBuilder);
                }
                ++n;
            }
            stringBuilder.append('}');
            if ((long)stringBuilder.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return stringBuilder.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_OBJECTAGG()";
        }

        @Override
        public String describe(Session session, int n) {
            return "JSON_OBJECTAGG()";
        }
    }

    public static class ExpressionJSONObject
    extends Expression {
        final OrderedHashMap exprMap;
        final boolean nullOnNull;
        final boolean uniqueKeys;

        public ExpressionJSONObject(OrderedHashMap orderedHashMap, boolean bl, boolean bl2, Type type) {
            super(103);
            this.exprMap = orderedHashMap;
            this.nullOnNull = bl;
            this.uniqueKeys = bl2;
            this.dataType = type == null ? Type.SQL_VARCHAR_LONG : type;
            this.nodes = new Expression[orderedHashMap.size() * 2];
            for (int i = 0; i < orderedHashMap.size(); ++i) {
                this.nodes[i * 2] = (Expression)orderedHashMap.getKeyAt(i);
                this.nodes[i * 2 + 1] = (Expression)orderedHashMap.get(i);
            }
        }

        @Override
        public void resolveTypes(Session session, Expression expression) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].resolveTypes(session, this);
            }
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            OrderedHashSet<String> orderedHashSet = new OrderedHashSet<String>();
            stringBuilder.append('{');
            for (int i = 0; i < this.exprMap.size(); ++i) {
                Object object;
                int n2 = i * 2;
                if (n > 0) {
                    stringBuilder.append(',');
                }
                Object object2 = this.nodes[n2].getValue(session);
                if (this.uniqueKeys && !orderedHashSet.add((String)(object = this.nodes[n2].dataType.convertToString(object2)))) {
                    throw Error.error(104);
                }
                if (this.nodes[n2].dataType.isCharacterType()) {
                    this.nodes[n2].dataType.convertToJSON(object2, stringBuilder);
                } else {
                    object = this.nodes[n2].dataType.convertToString(object2);
                    object = StringConverter.toQuotedString((String)object, '\"', false);
                    stringBuilder.append((String)object);
                }
                stringBuilder.append(':');
                object = this.nodes[n2 + 1].getValue(session);
                if (this.nodes[n2 + 1].opType == 103) {
                    stringBuilder.append((String)object);
                } else {
                    this.nodes[n2 + 1].dataType.convertToJSON(object, stringBuilder);
                }
                ++n;
            }
            stringBuilder.append('}');
            if ((long)stringBuilder.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return stringBuilder.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_OBJECT()";
        }

        @Override
        public String describe(Session session, int n) {
            return "JSON_OBJECT()";
        }
    }

    public static class ExpressionJSONArrayAgg
    extends Expression {
        final boolean isValueJSON;
        final boolean nullOnNull;

        public ExpressionJSONArrayAgg(ExpressionArrayAggregate expressionArrayAggregate, boolean bl, Type type) {
            super(103);
            this.nullOnNull = bl;
            this.dataType = type == null ? Type.SQL_VARCHAR_LONG : type;
            this.isValueJSON = expressionArrayAggregate.exprOpType == 103;
            this.nodes = new Expression[]{expressionArrayAggregate};
        }

        @Override
        public void resolveTypes(Session session, Expression expression) {
            this.nodes[0].resolveTypes(session, this);
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder stringBuilder = new StringBuilder();
            Object object = this.nodes[0].getValue(session);
            ArrayType arrayType = (ArrayType)this.nodes[0].dataType;
            if (this.isValueJSON) {
                arrayType.convertToJSONsimple(object, stringBuilder);
            } else {
                arrayType.convertToJSON(object, stringBuilder);
            }
            if ((long)stringBuilder.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return stringBuilder.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_ARRAYAGG()";
        }

        @Override
        public String describe(Session session, int n) {
            return "JSON_ARRAYAGG()";
        }
    }

    public static class ExpressionJSONArrayFromValues
    extends Expression {
        final HsqlArrayList exprList;
        final boolean nullOnNull;

        public ExpressionJSONArrayFromValues(HsqlArrayList hsqlArrayList, boolean bl, Type type) {
            super(103);
            this.exprList = hsqlArrayList;
            this.nullOnNull = bl;
            this.dataType = type == null ? Type.SQL_VARCHAR_LONG : type;
            this.nodes = new Expression[hsqlArrayList.size()];
            hsqlArrayList.toArray(this.nodes);
        }

        @Override
        public void resolveTypes(Session session, Expression expression) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].resolveTypes(session, this);
            }
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            stringBuilder.append('[');
            for (int i = 0; i < this.nodes.length; ++i) {
                if (n > 0) {
                    stringBuilder.append(',');
                }
                Object object = this.nodes[i].getValue(session);
                if (this.nodes[i].opType == 103) {
                    stringBuilder.append((String)object);
                } else {
                    this.nodes[i].dataType.convertToJSON(object, stringBuilder);
                }
                ++n;
            }
            stringBuilder.append(']');
            if ((long)stringBuilder.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return stringBuilder.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_ARRAY()";
        }

        @Override
        public String describe(Session session, int n) {
            return "JSON_ARRAY()";
        }
    }

    public static class ExpressionJSONArrayFromQuery
    extends Expression {
        final Expression exprQuery;
        final boolean nullOnNull;

        public ExpressionJSONArrayFromQuery(Expression expression, boolean bl, Type type) {
            super(103);
            this.exprQuery = expression;
            this.nullOnNull = bl;
            this.dataType = type == null ? Type.SQL_VARCHAR_LONG : type;
            this.nodes = new Expression[]{expression};
        }

        @Override
        public void resolveTypes(Session session, Expression expression) {
            this.nodes[0].resolveTypes(session, this);
        }

        @Override
        public Object getValue(Session session) {
            StringBuilder stringBuilder = new StringBuilder();
            Object object = this.nodes[0].getValue(session);
            this.nodes[0].dataType.convertToJSON(object, stringBuilder);
            if ((long)stringBuilder.length() > this.dataType.precision) {
                throw Error.error(3401);
            }
            return stringBuilder.toString();
        }

        @Override
        public String getSQL() {
            return "JSON_ARRAY()";
        }

        @Override
        public String describe(Session session, int n) {
            return "JSON_ARRAY()";
        }
    }

    public static class ExpressionJSONWrapper
    extends Expression {
        public ExpressionJSONWrapper(Expression expression) {
            super(103);
            this.nodes = new Expression[]{expression};
        }

        @Override
        public void resolveTypes(Session session, Expression expression) {
            this.nodes[0].resolveTypes(session, this);
            this.dataType = this.nodes[0].dataType;
        }

        @Override
        public Object getValue(Session session) {
            return this.nodes[0].getValue(session);
        }

        @Override
        public String getSQL() {
            return this.nodes[0].getSQL();
        }

        @Override
        public String describe(Session session, int n) {
            return this.nodes[0].getSQL();
        }
    }
}

