/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmc;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1UTF8String;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERSequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERUTF8String;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmc.BodyPartID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmc.CMCFailInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmc.CMCStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmc.CMCStatusInfoV2;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmc.ExtendedFailInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmc.OtherStatusInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cmc.PendInfo;

public class CMCStatusInfoV2Builder {
    private final CMCStatus cMCStatus;
    private final ASN1Sequence bodyList;
    private ASN1UTF8String statusString;
    private OtherStatusInfo otherInfo;

    public CMCStatusInfoV2Builder(CMCStatus cMCStatus, BodyPartID bodyPartID) {
        this.cMCStatus = cMCStatus;
        this.bodyList = new DERSequence(bodyPartID);
    }

    public CMCStatusInfoV2Builder(CMCStatus cMCStatus, BodyPartID[] bodyPartIDArray) {
        this.cMCStatus = cMCStatus;
        this.bodyList = new DERSequence(bodyPartIDArray);
    }

    public CMCStatusInfoV2Builder setStatusString(String string) {
        this.statusString = new DERUTF8String(string);
        return this;
    }

    public CMCStatusInfoV2Builder setOtherInfo(CMCFailInfo cMCFailInfo) {
        this.otherInfo = new OtherStatusInfo(cMCFailInfo);
        return this;
    }

    public CMCStatusInfoV2Builder setOtherInfo(ExtendedFailInfo extendedFailInfo) {
        this.otherInfo = new OtherStatusInfo(extendedFailInfo);
        return this;
    }

    public CMCStatusInfoV2Builder setOtherInfo(PendInfo pendInfo) {
        this.otherInfo = new OtherStatusInfo(pendInfo);
        return this;
    }

    public CMCStatusInfoV2 build() {
        return new CMCStatusInfoV2(this.cMCStatus, this.bodyList, this.statusString, this.otherInfo);
    }
}

