/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.sql;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.sql.AWSSecretsManagerDriver;
import java.sql.SQLException;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.utils.StringUtils;

public final class AWSSecretsManagerMSSQLServerDriver
extends AWSSecretsManagerDriver {
    public static final int LOGIN_FAILED = 18456;
    public static final String SUBPREFIX = "sqlserver";

    public AWSSecretsManagerMSSQLServerDriver() {
    }

    public AWSSecretsManagerMSSQLServerDriver(SecretCache cache) {
        super(cache);
    }

    public AWSSecretsManagerMSSQLServerDriver(SecretsManagerClientBuilder builder) {
        super(builder);
    }

    public AWSSecretsManagerMSSQLServerDriver(SecretsManagerClient client) {
        super(client);
    }

    public AWSSecretsManagerMSSQLServerDriver(SecretCacheConfiguration cacheConfig) {
        super(cacheConfig);
    }

    @Override
    public String getPropertySubprefix() {
        return SUBPREFIX;
    }

    @Override
    public boolean isExceptionDueToAuthenticationError(Exception e) {
        if (e instanceof SQLException) {
            SQLException sqle = (SQLException)e;
            int errorCode = sqle.getErrorCode();
            return errorCode == 18456;
        }
        return false;
    }

    @Override
    public String constructUrlFromEndpointPortDatabase(String endpoint, String port, String dbname) {
        String url = "jdbc:sqlserver://" + endpoint;
        if (StringUtils.isNotBlank((CharSequence)port)) {
            url = url + ":" + port;
        }
        if (StringUtils.isNotBlank((CharSequence)dbname)) {
            url = url + ";databaseName=" + dbname + ";";
        }
        return url;
    }

    @Override
    public String getDefaultDriverClass() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    static {
        AWSSecretsManagerDriver.register(new AWSSecretsManagerMSSQLServerDriver());
    }
}

