/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.sql;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.sql.AWSSecretsManagerDriver;
import java.sql.SQLException;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.utils.StringUtils;

public final class AWSSecretsManagerPostgreSQLDriver
extends AWSSecretsManagerDriver {
    public static final String ACCESS_DENIED_FOR_USER_USING_PASSWORD_TO_DATABASE = "28P01";
    public static final String ACCESS_DENIED_FOR_INVALID_AUTHORIZATION_SPECIFICATION = "28000";
    public static final String SUBPREFIX = "postgresql";

    public AWSSecretsManagerPostgreSQLDriver() {
    }

    public AWSSecretsManagerPostgreSQLDriver(SecretCache cache) {
        super(cache);
    }

    public AWSSecretsManagerPostgreSQLDriver(SecretsManagerClientBuilder builder) {
        super(builder);
    }

    public AWSSecretsManagerPostgreSQLDriver(SecretsManagerClient client) {
        super(client);
    }

    public AWSSecretsManagerPostgreSQLDriver(SecretCacheConfiguration cacheConfig) {
        super(cacheConfig);
    }

    @Override
    public String getPropertySubprefix() {
        return SUBPREFIX;
    }

    @Override
    public boolean isExceptionDueToAuthenticationError(Exception e) {
        if (e instanceof SQLException) {
            SQLException sqle = (SQLException)e;
            String sqlState = sqle.getSQLState();
            return sqlState.equals(ACCESS_DENIED_FOR_USER_USING_PASSWORD_TO_DATABASE) || sqlState.equals(ACCESS_DENIED_FOR_INVALID_AUTHORIZATION_SPECIFICATION);
        }
        return false;
    }

    @Override
    public String constructUrlFromEndpointPortDatabase(String endpoint, String port, String dbname) {
        String url = "jdbc:postgresql://" + endpoint;
        if (StringUtils.isNotBlank((CharSequence)port)) {
            url = url + ":" + port;
        }
        url = url + "/";
        if (StringUtils.isNotBlank((CharSequence)dbname)) {
            url = url + dbname;
        }
        return url;
    }

    @Override
    public String getDefaultDriverClass() {
        return "org.postgresql.Driver";
    }

    static {
        AWSSecretsManagerDriver.register(new AWSSecretsManagerPostgreSQLDriver());
    }
}

