/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.VectorOverArrayList;

public class KeyPairPKCS12
extends PKCS12 {
    private ArrayList<X509> orderedCertChain = null;

    public KeyPairPKCS12() {
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 pkcs8, Vector<X509> certChain, int mode) {
        this(pkcs8, certChain, KeyPairPKCS12.transformMode(mode));
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 pkcs8, Vector<X509> certChain, ASN1ObjectID pbeOID) {
        this(pkcs8, certChain, pbeOID, (String)null);
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 pkcs8, Vector<X509> certChain, int mode, String friendlyName) {
        this(pkcs8, certChain, KeyPairPKCS12.transformMode(mode), friendlyName);
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 pkcs8, Vector<X509> certChain, ASN1ObjectID pbeOID, String friendlyName) {
        this(pkcs8, (List<X509>)certChain, pbeOID, friendlyName);
    }

    public KeyPairPKCS12(PrivateKeyPKCS8 pkcs8, List<X509> certChain, ASN1ObjectID pbeOID, String friendlyName) {
        byte[] localKeyID = null;
        if (certChain != null && certChain.size() > 0) {
            X509 botCert = certChain.get(0);
            MessageDigest sha = null;
            try {
                sha = MessageDigest.getInstance((AlgorithmIdentifier)AlgID.sha_1);
            }
            catch (AlgorithmIdentifierException ex) {
                throw new RuntimeException("SHA1 class not found. " + ex.toString());
            }
            localKeyID = sha.computeDigest(botCert.getEncoded());
        }
        if (pkcs8 != null) {
            PKCS12Safe k = new PKCS12Safe((PKCS12)this, (ASN1ObjectID)null);
            PKCS12ShroudedKeyBag b = new PKCS12ShroudedKeyBag(k, pkcs8);
            if (localKeyID != null) {
                b.setLocalKeyID(localKeyID);
            }
            if (friendlyName != null) {
                b.setFriendlyName(friendlyName);
            }
            k.addBag(b);
            this.addAuthSafe(k);
        }
        if (certChain != null && certChain.size() > 0) {
            PKCS12Safe cc = new PKCS12Safe((PKCS12)this, pbeOID);
            for (int i = certChain.size() - 1; i > 0; --i) {
                cc.addBag(new PKCS12CertBag(cc, certChain.get(i)));
            }
            X509 botCert = certChain.get(0);
            PKCS12CertBag b = new PKCS12CertBag(cc, botCert);
            if (localKeyID != null) {
                b.setLocalKeyID(localKeyID);
            }
            if (friendlyName != null) {
                b.setFriendlyName(friendlyName);
            }
            cc.addBag(b);
            this.addAuthSafe(cc);
        }
    }

    public KeyPairPKCS12(String passwd, PrivateKeyPKCS8 pkcs8, Vector<X509> certChain, int mode) {
        this(passwd, pkcs8, certChain, KeyPairPKCS12.transformMode(mode));
    }

    public KeyPairPKCS12(String passwd, PrivateKeyPKCS8 pkcs8, Vector<X509> certChain, ASN1ObjectID pbeOID) {
        this(passwd, pkcs8, certChain, pbeOID, (String)null);
    }

    public KeyPairPKCS12(String passwd, PrivateKeyPKCS8 pkcs8, Vector<X509> certChain, int mode, String friendlyName) {
        this(passwd, pkcs8, certChain, KeyPairPKCS12.transformMode(mode), friendlyName);
    }

    public KeyPairPKCS12(String passwd, PrivateKeyPKCS8 pkcs8, Vector<X509> certChain, ASN1ObjectID pbeOID, String friendlyName) {
        this(passwd, pkcs8, (List<X509>)certChain, pbeOID, friendlyName);
    }

    public KeyPairPKCS12(String passwd, PrivateKeyPKCS8 pkcs8, List<X509> certChain, ASN1ObjectID pbeOID, String friendlyName) {
        this(pkcs8, certChain, pbeOID, friendlyName);
        this.setPassword(passwd);
    }

    public KeyPairPKCS12(String passwd, InputStream is) throws IOException {
        super(passwd, is);
        this.orderCertificateChain();
    }

    public KeyPairPKCS12(String passwd, ASN1Sequence s) throws IOException {
        super(passwd, s);
        this.orderCertificateChain();
    }

    private static ASN1ObjectID transformMode(int mode) {
        if (mode == -2) {
            return PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC;
        }
        if (mode == -1) {
            return PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC;
        }
        if (mode == 0) {
            return null;
        }
        return new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, mode);
    }

    @Override
    public void input(ASN1Sequence s) throws IOException {
        super.input(s);
        this.orderedCertChain = null;
        this.orderCertificateChain();
    }

    @Override
    public void input(InputStream is) throws IOException {
        super.input(is);
        this.orderedCertChain = null;
        this.orderCertificateChain();
    }

    private PKCS12ShroudedKeyBag getShroudedKeyBag() {
        for (PKCS12Safe s : this.getAuthSafesAsList()) {
            for (PKCS12Bag b : s.getBagsAsList()) {
                if (!(b instanceof PKCS12ShroudedKeyBag)) continue;
                return (PKCS12ShroudedKeyBag)b;
            }
        }
        return null;
    }

    public PrivateKeyPKCS8 getPrivateKeyPKCS8() {
        PKCS12ShroudedKeyBag b = this.getShroudedKeyBag();
        if (b != null) {
            return b.getPKCS8();
        }
        return null;
    }

    public PrivateKey getPrivateKey() {
        PKCS12ShroudedKeyBag b = this.getShroudedKeyBag();
        if (b != null) {
            return b.getPrivateKey();
        }
        return null;
    }

    public PrivateKey getPrivateKey(String passwd) {
        PrivateKeyPKCS8 pkcs8 = this.getPrivateKeyPKCS8();
        if (pkcs8 != null) {
            pkcs8.setPassword(passwd);
            return pkcs8.getKey();
        }
        return null;
    }

    @Deprecated
    public Vector<X509> getCertificateChain() {
        return this.orderedCertChain == null ? null : new VectorOverArrayList(this.orderedCertChain);
    }

    public ArrayList<X509> getCertificateChainAsList() {
        return this.orderedCertChain;
    }

    public X509 getBottomCert() {
        ArrayList<X509> cc = this.getCertificateChainAsList();
        if (cc.size() == 0) {
            return null;
        }
        return cc.get(0);
    }

    private void orderCertificateChain() throws InvalidInputException {
        if (this.orderedCertChain != null) {
            return;
        }
        LinkedHashMap<X500Name, X509> issuers = new LinkedHashMap<X500Name, X509>();
        LinkedHashMap<X500Name, X509> subjects = new LinkedHashMap<X500Name, X509>();
        int certCount = 0;
        ArrayList<X509> chain = new ArrayList<X509>();
        LinkedHashMap<X509, X509> check = new LinkedHashMap<X509, X509>();
        for (PKCS12Safe safe : this.getAuthSafesAsList()) {
            for (PKCS12Bag bag : safe.getBagsAsList()) {
                if (!(bag instanceof PKCS12CertBag)) continue;
                X509 cert = ((PKCS12CertBag)bag).getCert();
                if (cert.getIssuer().equals(cert.getSubject())) {
                    chain.add(cert);
                    check.put(cert, cert);
                } else {
                    if (issuers.put(cert.getIssuer(), cert) != null) {
                        throw new InvalidInputException("Multiple certificates with same issuer");
                    }
                    if (subjects.put(cert.getSubject(), cert) != null) {
                        throw new InvalidInputException("Multiple certificates with same subject");
                    }
                }
                ++certCount;
            }
        }
        if (chain.size() == 0 && issuers.size() > 0) {
            X509 cert = (X509)issuers.values().iterator().next();
            if (cert != null) {
                chain.add(cert);
                check.put(cert, cert);
            }
        } else if (chain.size() > 1) {
            throw new InvalidInputException("Certificate chain contains more than 1 self-signed cert");
        }
        if (chain.size() == 1) {
            X509 first = (X509)chain.get(0);
            X509 prev = (X509)subjects.get(first.getIssuer());
            X509 next = (X509)issuers.get(first.getSubject());
            while (prev != null) {
                if (check.put(prev, prev) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                chain.add(prev);
                prev = (X509)subjects.get(prev.getIssuer());
            }
            while (next != null) {
                if (check.put(next, next) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                chain.add(0, next);
                next = (X509)issuers.get(next.getSubject());
            }
            if (chain.size() != certCount) {
                throw new InvalidInputException("Certificate chain cannot be ordered");
            }
        }
        this.orderedCertChain = chain;
    }
}

