/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.sqlserver.SQLServerDatabase;
import org.flywaydb.database.sqlserver.SQLServerTable;

public class SQLServerSchema
extends Schema<SQLServerDatabase, SQLServerTable> {
    private static final Log LOG = LogFactory.getLog(SQLServerSchema.class);
    protected final String databaseName;

    public SQLServerSchema(JdbcTemplate jdbcTemplate, SQLServerDatabase database, String databaseName, String name) {
        super(jdbcTemplate, (Database)database, name);
        this.databaseName = databaseName;
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME=?", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() throws SQLException {
        boolean empty = this.queryDBObjects(ObjectType.SCALAR_FUNCTION, ObjectType.AGGREGATE, ObjectType.CLR_SCALAR_FUNCTION, ObjectType.CLR_TABLE_VALUED_FUNCTION, ObjectType.TABLE_VALUED_FUNCTION, ObjectType.STORED_PROCEDURE, ObjectType.CLR_STORED_PROCEDURE, ObjectType.USER_TABLE, ObjectType.SYNONYM, ObjectType.SEQUENCE_OBJECT, ObjectType.FOREIGN_KEY, ObjectType.VIEW).isEmpty();
        if (empty) {
            int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM ( SELECT t.name FROM sys.types t INNER JOIN sys.schemas s ON t.schema_id = s.schema_id WHERE t.is_user_defined = 1 AND s.name = ? Union SELECT name FROM sys.assemblies WHERE is_user_defined=1) R", new String[]{this.name});
            empty = objectCount == 0;
        }
        return empty;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((SQLServerDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.clean();
        this.jdbcTemplate.execute("DROP SCHEMA " + ((SQLServerDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doClean() throws SQLException {
        for (String statement : this.getCleanStatementsBeforeFirstTableDrop(this.queryDBObjects(ObjectType.USER_TABLE))) {
            this.executeIgnoringDependencyErrors(statement);
        }
        this.dropTablesIgnoringErrors((SQLServerTable[])this.allTables());
        for (String statement : this.getCleanStatementsBeforeSecondTableDrop(this.queryDBObjects(ObjectType.USER_TABLE))) {
            this.executeIgnoringDependencyErrors(statement);
        }
        this.dropTablesIgnoringErrors((SQLServerTable[])this.allTables());
        for (String statement : this.getCleanStatementsAfterLastTableDrop(this.queryDBObjects(ObjectType.USER_TABLE))) {
            this.executeIgnoringDependencyErrors(statement);
        }
        for (String statement : this.getCleanStatementsBeforeFirstTableDrop(this.queryDBObjects(ObjectType.USER_TABLE))) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        this.dropTablesIgnoringErrors((SQLServerTable[])this.allTables());
        for (String statement : this.getCleanStatementsBeforeSecondTableDrop(this.queryDBObjects(ObjectType.USER_TABLE))) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        this.dropTables((SQLServerTable[])this.allTables());
        for (String statement : this.getCleanStatementsAfterLastTableDrop(this.queryDBObjects(ObjectType.USER_TABLE))) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> getCleanStatementsBeforeFirstTableDrop(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        statements.addAll(this.cleanTriggers());
        statements.addAll(this.cleanForeignKeys(tables));
        return statements;
    }

    private List<String> getCleanStatementsBeforeSecondTableDrop(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        statements.addAll(this.cleanForeignKeys(tables));
        statements.addAll(this.cleanPrimaryKeys(tables));
        statements.addAll(this.cleanDefaultConstraints(tables));
        statements.addAll(this.cleanUniqueConstraints(tables));
        statements.addAll(this.cleanComputedColumns(tables));
        statements.addAll(this.cleanObjects("PROCEDURE", ObjectType.STORED_PROCEDURE, ObjectType.CLR_STORED_PROCEDURE));
        statements.addAll(this.cleanObjects("VIEW", ObjectType.VIEW));
        statements.addAll(this.cleanObjects("FUNCTION", ObjectType.SCALAR_FUNCTION, ObjectType.CLR_SCALAR_FUNCTION, ObjectType.CLR_TABLE_VALUED_FUNCTION, ObjectType.TABLE_VALUED_FUNCTION, ObjectType.INLINED_TABLE_FUNCTION));
        return statements;
    }

    private List<String> getCleanStatementsAfterLastTableDrop(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        statements.addAll(this.cleanIndexes(tables));
        statements.addAll(this.cleanObjects("AGGREGATE", ObjectType.AGGREGATE));
        statements.addAll(this.cleanSynonyms());
        statements.addAll(this.cleanRules());
        statements.addAll(this.cleanObjects("DEFAULT", ObjectType.DEFAULT_CONSTRAINT));
        if (((SQLServerDatabase)this.database).hasXmlSchemaCollections()) {
            statements.addAll(this.cleanXmlSchemaCollections());
        }
        if (((SQLServerDatabase)this.database).supportsSequences()) {
            statements.addAll(this.cleanObjects("SEQUENCE", ObjectType.SEQUENCE_OBJECT));
        }
        if (((SQLServerDatabase)this.database).supportsServiceBrokers()) {
            statements.addAll(this.cleanServiceBrokers());
        }
        return statements;
    }

    private void dropTables(SQLServerTable[] allTables) throws SQLException {
        for (SQLServerTable table : allTables) {
            table.dropSystemVersioningIfPresent();
        }
        for (SQLServerTable table : allTables) {
            table.drop();
        }
    }

    private void dropTablesIgnoringErrors(SQLServerTable[] allTables) {
        try {
            this.dropTables(allTables);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void executeIgnoringDependencyErrors(String statement) {
        try {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        catch (SQLException e) {
            LOG.debug("Ignoring dependency-related error: " + e.getMessage());
        }
    }

    protected List<DBObject> queryDBObjects(ObjectType ... types) throws SQLException {
        return this.queryDBObjectsWithParent(null, types);
    }

    private List<DBObject> queryDBObjectsWithParent(DBObject parent, ObjectType ... types) throws SQLException {
        StringBuilder query = new StringBuilder("SELECT obj.object_id, obj.name FROM sys.objects AS obj LEFT JOIN sys.extended_properties AS eps ON obj.object_id = eps.major_id AND eps.class = 1 AND eps.minor_id = 0 AND eps.name='microsoft_database_tools_support' WHERE SCHEMA_NAME(obj.schema_id) = '" + this.name + "' AND eps.major_id IS NULL AND obj.is_ms_shipped = 0 AND obj.type IN (");
        boolean first = true;
        for (ObjectType type : types) {
            if (!first) {
                query.append(", ");
            }
            query.append("'").append(type.code).append("'");
            first = false;
        }
        query.append(")");
        if (parent != null) {
            query.append(" AND obj.parent_object_id = ").append(parent.objectId);
        }
        query.append(" order by create_date desc, object_id desc");
        return this.jdbcTemplate.query(query.toString(), rs -> new DBObject(rs.getLong("object_id"), rs.getString("name")), new Object[0]);
    }

    private List<String> cleanPrimaryKeys(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            for (DBObject pk : this.queryDBObjectsWithParent(table, ObjectType.PRIMARY_KEY)) {
                statements.add("ALTER TABLE " + ((SQLServerDatabase)this.database).quote(new String[]{this.name, table.name}) + " DROP CONSTRAINT " + ((SQLServerDatabase)this.database).quote(new String[]{pk.name}));
            }
        }
        return statements;
    }

    private List<String> cleanForeignKeys(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            for (DBObject fk : this.queryDBObjectsWithParent(table, ObjectType.FOREIGN_KEY, ObjectType.CHECK_CONSTRAINT)) {
                statements.add("ALTER TABLE " + ((SQLServerDatabase)this.database).quote(new String[]{this.name, table.name}) + " DROP CONSTRAINT " + ((SQLServerDatabase)this.database).quote(new String[]{fk.name}));
            }
        }
        return statements;
    }

    private List<String> cleanComputedColumns(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            String tableName = ((SQLServerDatabase)this.database).quote(new String[]{this.name, table.name});
            List columns = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.computed_columns WHERE object_id=OBJECT_ID(N'" + tableName + "')", new String[0]);
            for (String column : columns) {
                statements.add("ALTER TABLE " + tableName + " DROP COLUMN " + ((SQLServerDatabase)this.database).quote(new String[]{column}));
            }
        }
        return statements;
    }

    private List<String> cleanIndexes(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            String tableName = ((SQLServerDatabase)this.database).quote(new String[]{this.name, table.name});
            List indexes = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.indexes WHERE object_id=OBJECT_ID(N'" + tableName + "') AND is_primary_key = 0 AND is_unique_constraint = 0 AND name IS NOT NULL", new String[0]);
            for (String index : indexes) {
                statements.add("DROP INDEX " + ((SQLServerDatabase)this.database).quote(new String[]{index}) + " ON " + tableName);
            }
        }
        return statements;
    }

    private List<String> cleanDefaultConstraints(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            String tableName = ((SQLServerDatabase)this.database).quote(new String[]{this.name, table.name});
            List indexes = this.jdbcTemplate.queryForStringList("SELECT i.name FROM sys.indexes i JOIN sys.index_columns ic on i.index_id = ic.index_id JOIN sys.columns c ON ic.column_id = c.column_id AND i.object_id = c.object_id WHERE i.object_id=OBJECT_ID(N'" + tableName + "') AND is_primary_key = 0 AND is_unique_constraint = 1 AND i.name IS NOT NULL GROUP BY i.name HAVING MAX(CAST(is_rowguidcol AS INT)) = 0 OR MAX(CAST(is_filestream AS INT)) = 0", new String[0]);
            for (String index : indexes) {
                statements.add("ALTER TABLE " + tableName + " DROP CONSTRAINT " + ((SQLServerDatabase)this.database).quote(new String[]{index}));
            }
        }
        return statements;
    }

    private List<String> cleanUniqueConstraints(List<DBObject> tables) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (DBObject table : tables) {
            for (DBObject df : this.queryDBObjectsWithParent(table, ObjectType.DEFAULT_CONSTRAINT)) {
                statements.add("ALTER TABLE " + ((SQLServerDatabase)this.database).quote(new String[]{this.name, table.name}) + " DROP CONSTRAINT " + ((SQLServerDatabase)this.database).quote(new String[]{df.name}));
            }
        }
        return statements;
    }

    protected List<String> cleanTriggers() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (((SQLServerDatabase)this.database).supportsTriggers()) {
            List triggerNames = this.jdbcTemplate.queryForStringList("SELECT * FROM sys.triggers WHERE is_ms_shipped=0 AND parent_id=0 AND parent_class_desc='DATABASE'", new String[0]);
            for (String triggerName : triggerNames) {
                statements.add("DROP TRIGGER " + ((SQLServerDatabase)this.database).quote(new String[]{triggerName}) + " ON DATABASE");
            }
        }
        return statements;
    }

    protected List<String> cleanSynonyms() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (((SQLServerDatabase)this.database).supportsSynonyms()) {
            statements.addAll(this.cleanObjects("SYNONYM", ObjectType.SYNONYM));
        }
        return statements;
    }

    protected List<String> cleanRules() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (((SQLServerDatabase)this.database).supportsRules()) {
            statements.addAll(this.cleanObjects("RULE", ObjectType.RULE));
        }
        return statements;
    }

    private List<String> cleanXmlSchemaCollections() throws SQLException {
        List xscNames = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.xml_schema_collections WHERE schema_id = SCHEMA_ID(?)", new String[]{this.name});
        return xscNames.stream().map(xscName -> "DROP XML SCHEMA COLLECTION " + ((SQLServerDatabase)this.database).quote(new String[]{this.name, xscName})).collect(Collectors.toList());
    }

    private List<String> cleanServiceBrokers() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        List queues = this.jdbcTemplate.queryForList("SELECT name AS queue_name, object_id AS queue_id FROM sys.service_queues WHERE schema_id = schema_id('" + this.name + "') AND is_ms_shipped = 0;", new Object[0]);
        if (queues.isEmpty()) {
            return statements;
        }
        String queueIds = queues.stream().map(queueAndSchema -> (String)queueAndSchema.get("queue_id")).collect(Collectors.joining(","));
        List services = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.services WHERE service_queue_id IN (" + queueIds + ")", new String[0]);
        for (String service : services) {
            statements.add("DROP SERVICE " + ((SQLServerDatabase)this.database).quote(new String[]{service}));
        }
        for (Map queueAndSchema2 : queues) {
            statements.add("DROP QUEUE " + ((SQLServerDatabase)this.database).quote(new String[]{this.name, (String)queueAndSchema2.get("queue_name")}));
        }
        return statements;
    }

    protected List<String> cleanObjects(String dropQualifier, ObjectType ... objectTypes) throws SQLException {
        return this.queryDBObjects(objectTypes).stream().map(dbObject -> "DROP " + dropQualifier + " " + ((SQLServerDatabase)this.database).quote(new String[]{this.name, dbObject.name})).collect(Collectors.toList());
    }

    protected SQLServerTable[] doAllTables() throws SQLException {
        return (SQLServerTable[])this.queryDBObjects(ObjectType.USER_TABLE).stream().map(table -> new SQLServerTable(this.jdbcTemplate, (SQLServerDatabase)this.database, this.databaseName, this, table.name)).toArray(SQLServerTable[]::new);
    }

    public Table getTable(String tableName) {
        return new SQLServerTable(this.jdbcTemplate, (SQLServerDatabase)this.database, this.databaseName, this, tableName);
    }

    protected static final class ObjectType
    extends Enum<ObjectType> {
        public static final /* enum */ ObjectType AGGREGATE = new ObjectType("AF");
        public static final /* enum */ ObjectType CHECK_CONSTRAINT = new ObjectType("C");
        public static final /* enum */ ObjectType DEFAULT_CONSTRAINT = new ObjectType("D");
        public static final /* enum */ ObjectType PRIMARY_KEY = new ObjectType("PK");
        public static final /* enum */ ObjectType FOREIGN_KEY = new ObjectType("F");
        public static final /* enum */ ObjectType INLINED_TABLE_FUNCTION = new ObjectType("IF");
        public static final /* enum */ ObjectType SCALAR_FUNCTION = new ObjectType("FN");
        public static final /* enum */ ObjectType CLR_SCALAR_FUNCTION = new ObjectType("FS");
        public static final /* enum */ ObjectType CLR_TABLE_VALUED_FUNCTION = new ObjectType("FT");
        public static final /* enum */ ObjectType STORED_PROCEDURE = new ObjectType("P");
        public static final /* enum */ ObjectType CLR_STORED_PROCEDURE = new ObjectType("PC");
        public static final /* enum */ ObjectType RULE = new ObjectType("R");
        public static final /* enum */ ObjectType SYNONYM = new ObjectType("SN");
        public static final /* enum */ ObjectType TABLE_VALUED_FUNCTION = new ObjectType("TF");
        public static final /* enum */ ObjectType ASSEMBLY_DML_TRIGGER = new ObjectType("TA");
        public static final /* enum */ ObjectType SQL_DML_TRIGGER = new ObjectType("TR");
        public static final /* enum */ ObjectType UNIQUE_CONSTRAINT = new ObjectType("UQ");
        public static final /* enum */ ObjectType USER_TABLE = new ObjectType("U");
        public static final /* enum */ ObjectType VIEW = new ObjectType("V");
        public static final /* enum */ ObjectType SEQUENCE_OBJECT = new ObjectType("SO");
        public final String code;
        private static final /* synthetic */ ObjectType[] $VALUES;

        public static ObjectType[] values() {
            return (ObjectType[])$VALUES.clone();
        }

        public static ObjectType valueOf(String name) {
            return Enum.valueOf(ObjectType.class, name);
        }

        private ObjectType(String code) {
            assert (code != null);
            this.code = code;
        }

        private static /* synthetic */ ObjectType[] $values() {
            return new ObjectType[]{AGGREGATE, CHECK_CONSTRAINT, DEFAULT_CONSTRAINT, PRIMARY_KEY, FOREIGN_KEY, INLINED_TABLE_FUNCTION, SCALAR_FUNCTION, CLR_SCALAR_FUNCTION, CLR_TABLE_VALUED_FUNCTION, STORED_PROCEDURE, CLR_STORED_PROCEDURE, RULE, SYNONYM, TABLE_VALUED_FUNCTION, ASSEMBLY_DML_TRIGGER, SQL_DML_TRIGGER, UNIQUE_CONSTRAINT, USER_TABLE, VIEW, SEQUENCE_OBJECT};
        }

        static {
            $VALUES = ObjectType.$values();
        }
    }

    public static class DBObject {
        public final String name;
        public final long objectId;

        public DBObject(long objectId, String name) {
            assert (name != null);
            this.objectId = objectId;
            this.name = name;
        }
    }
}

