/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.util.Locale;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Token;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BitType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class Scanner {
    static final char[] specials = new char[]{'\"', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '\\', ':', ';', '<', '=', '>', '?', '[', ']', '^', '_', '|', '{', '}'};
    static final String[] multi = new String[]{"??(", "??)", "<>", ">=", "<=", "||", "->", "::", "..", "--", "/*", "*/"};
    static final char[] whitespace = new char[]{'\t', '\n', '\u000b', '\f', '\r', ' ', '\u0085', ' ', '\u00a0', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u202f', '\u205f', '\u3000', '\u2028', '\u2029'};
    static final OrderedIntHashSet whiteSpaceSet = new OrderedIntHashSet(32);
    String sqlString;
    int currentPosition;
    int tokenPosition;
    int limit;
    Token token = new Token();
    boolean nullAndBooleanAsValue;
    boolean backtickQuoting;
    boolean hyphenInBinary;
    boolean charLiteral = true;
    private boolean hasNonSpaceSeparator;
    private static final int maxPooledStringLength;
    char[] charBuffer = new char[256];
    CharArrayWriter charWriter = new CharArrayWriter(this.charBuffer);
    byte[] byteBuffer = new byte[256];
    HsqlByteArrayOutputStream byteOutputStream = new HsqlByteArrayOutputStream(this.byteBuffer);
    private String intervalString;
    private int intervalPosition;
    private int intervalPrecision;
    private int fractionPrecision;
    Type dateTimeType;

    public Scanner() {
    }

    public Scanner(Session session, String string) {
        this.reset(session, string);
    }

    public void reset(Session session, String string) {
        this.reset(string);
        if (session != null) {
            this.backtickQuoting = session.database.sqlSyntaxMys;
            this.charLiteral = session.database.sqlCharLiteral;
        }
    }

    public void reset(String string) {
        this.sqlString = string;
        this.currentPosition = 0;
        this.tokenPosition = 0;
        this.limit = this.sqlString.length();
        this.hasNonSpaceSeparator = false;
        this.token.reset();
        this.token.tokenType = 1015;
    }

    void resetState() {
        this.tokenPosition = this.currentPosition;
        this.token.reset();
    }

    public void setNullAndBooleanAsValue() {
        this.nullAndBooleanAsValue = true;
    }

    public void scanNext() {
        if (this.currentPosition == this.limit) {
            this.resetState();
            this.token.tokenType = 1014;
            return;
        }
        if (this.scanSeparator()) {
            // empty if block
        }
        if (this.currentPosition == this.limit) {
            this.resetState();
            this.token.tokenType = 1014;
            return;
        }
        boolean bl = !this.token.isDelimiter;
        this.scanToken();
        if (!bl || !this.token.isDelimiter) {
            // empty if block
        }
        if (this.token.isMalformed) {
            this.token.fullString = this.getPart(this.tokenPosition, this.currentPosition);
        }
    }

    public void scanEnd() {
        if (this.currentPosition == this.limit) {
            this.resetState();
            this.token.tokenType = 1014;
        }
    }

    public Token getToken() {
        return this.token;
    }

    public String getString() {
        return this.token.tokenString;
    }

    public int getTokenType() {
        return this.token.tokenType;
    }

    public Object getValue() {
        return this.token.tokenValue;
    }

    public Type getDataType() {
        return this.token.dataType;
    }

    public void replaceToken(String string) {
        this.sqlString = this.sqlString.substring(0, this.tokenPosition) + string + this.sqlString.substring(this.currentPosition);
        this.limit = this.sqlString.length();
        this.currentPosition = this.tokenPosition + string.length();
    }

    public int getLineNumber() {
        return Scanner.countEndOfLines(this.sqlString, this.tokenPosition) + 1;
    }

    int getTokenPosition() {
        return this.tokenPosition;
    }

    void position(int n) {
        this.currentPosition = this.tokenPosition = n;
    }

    String getPart(int n, int n2) {
        return this.sqlString.substring(n, n2);
    }

    private int charAt(int n) {
        if (n >= this.limit) {
            return -1;
        }
        return this.sqlString.charAt(n);
    }

    void scanBinaryString() {
        this.byteOutputStream.reset(this.byteBuffer);
        do {
            this.scanBinaryStringPart();
            if (!this.token.isMalformed) continue;
            return;
        } while (this.scanSeparator() && this.charAt(this.currentPosition) == 39);
        this.token.tokenValue = new BinaryData(this.byteOutputStream.toByteArray(), false);
        this.byteOutputStream.reset(this.byteBuffer);
    }

    static int getHexValue(int n) {
        n = n >= 48 && n <= 57 ? (n -= 48) : (n >= 97 && n <= 102 ? (n -= 87) : (n >= 65 && n <= 70 ? (n -= 55) : -1));
        return n;
    }

    public void scanUUIDStringWithQuote() {
        try {
            this.hyphenInBinary = true;
            this.scanBinaryStringWithQuote();
            if (this.token.tokenValue instanceof BinaryData && ((BinaryData)this.token.tokenValue).length(null) != 16L) {
                this.token.tokenType = 1022;
                this.token.isMalformed = true;
            }
        }
        finally {
            this.hyphenInBinary = false;
        }
    }

    public void scanBinaryStringWithQuote() {
        this.resetState();
        this.scanSeparator();
        if (this.charAt(this.currentPosition) != 39) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
            return;
        }
        this.scanBinaryString();
    }

    void scanBinaryStringPart() {
        boolean bl = false;
        boolean bl2 = true;
        byte by = 0;
        ++this.currentPosition;
        while (this.currentPosition < this.limit) {
            int n = this.sqlString.charAt(this.currentPosition);
            if (!(this.hyphenInBinary && n == 45 || n == 32)) {
                if (n == 39) {
                    bl = true;
                    ++this.currentPosition;
                    break;
                }
                if ((n = Scanner.getHexValue(n)) == -1) {
                    this.token.tokenType = 1022;
                    this.token.isMalformed = true;
                    return;
                }
                if (bl2) {
                    by = (byte)(n << 4);
                    bl2 = false;
                } else {
                    by = (byte)(by + (byte)n);
                    this.byteOutputStream.writeByte(by);
                    bl2 = true;
                }
            }
            ++this.currentPosition;
        }
        if (!bl2) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
            return;
        }
        if (!bl) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
        }
    }

    void scanBitString() {
        BitMap bitMap = new BitMap(0, true);
        do {
            this.scanBitStringPart(bitMap);
            if (!this.token.isMalformed) continue;
            return;
        } while (this.scanSeparator() && this.charAt(this.currentPosition) == 39);
        this.token.tokenValue = BinaryData.getBitData(bitMap.getBytes(), bitMap.size());
    }

    public void scanBitStringWithQuote() {
        this.resetState();
        this.scanSeparator();
        if (this.charAt(this.currentPosition) != 39) {
            this.token.tokenType = 1021;
            this.token.isMalformed = true;
            return;
        }
        this.scanBitString();
    }

    void scanBitStringPart(BitMap bitMap) {
        boolean bl = false;
        int n = bitMap.size();
        ++this.currentPosition;
        while (this.currentPosition < this.limit) {
            char c = this.sqlString.charAt(this.currentPosition);
            if (c != ' ') {
                if (c == '\'') {
                    bl = true;
                    ++this.currentPosition;
                    break;
                }
                if (c == '0') {
                    bitMap.unset(n);
                    ++n;
                } else if (c == '1') {
                    bitMap.set(n);
                    ++n;
                } else {
                    this.token.tokenType = 1021;
                    this.token.isMalformed = true;
                    return;
                }
            }
            ++this.currentPosition;
        }
        if (!bl) {
            this.token.tokenType = 1021;
            this.token.isMalformed = true;
            return;
        }
        bitMap.setSize(n);
    }

    void convertUnicodeString(int n) {
        this.charWriter.reset(this.charBuffer);
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.token.tokenString.indexOf(n, n2)) < 0) {
                n3 = this.token.tokenString.length();
            }
            this.charWriter.write(this.token.tokenString, n2, n3 - n2);
            if (n3 == this.token.tokenString.length()) break;
            if (++n3 == this.token.tokenString.length()) {
                this.token.tokenType = 1023;
                this.token.isMalformed = true;
                return;
            }
            if (this.token.tokenString.charAt(n3) == n) {
                this.charWriter.write(n);
                n2 = ++n3;
                continue;
            }
            if (n3 > this.token.tokenString.length() - 4) {
                this.token.tokenType = 1023;
                this.token.isMalformed = true;
                return;
            }
            int n4 = 4;
            int n5 = 0;
            int n6 = 0;
            if (this.token.tokenString.charAt(n3) == '+') {
                if (++n3 > this.token.tokenString.length() - 6) {
                    this.token.tokenType = 1023;
                    this.token.isMalformed = true;
                    return;
                }
                n5 = 2;
                n4 = 8;
            }
            n2 = n3;
            while (n5 < n4) {
                int n7 = this.token.tokenString.charAt(n2++);
                if ((n7 = Scanner.getHexValue(n7)) == -1) {
                    this.token.tokenType = 1023;
                    this.token.isMalformed = true;
                    return;
                }
                n6 |= n7 << (n4 - n5 - 1) * 4;
                ++n5;
            }
            if (n4 == 8) {
                this.charWriter.write(n6 >>> 16);
            }
            this.charWriter.write(n6 & (n6 & 0xFFFF));
        }
        this.token.tokenValue = this.charWriter.toString();
    }

    public boolean scanSpecialIdentifier(String string) {
        int n = string.length();
        if (this.limit - this.currentPosition < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == this.sqlString.charAt(this.currentPosition + i) || c == Character.toUpperCase(this.sqlString.charAt(this.currentPosition + i))) continue;
            return false;
        }
        this.currentPosition += n;
        return true;
    }

    private int scanEscapeDefinition() {
        int n = this.charAt(this.currentPosition);
        if (n == 39) {
            ++this.currentPosition;
            if (!this.scanWhitespace() && Scanner.getHexValue(n = this.charAt(this.currentPosition)) == -1 && n != 43 && n != 39 && n != 34) {
                int n2 = n;
                ++this.currentPosition;
                n = this.charAt(this.currentPosition);
                if (n == 39) {
                    ++this.currentPosition;
                    return n2;
                }
            }
        }
        return -1;
    }

    private void scanUnicodeString() {
        int n = 92;
        this.scanCharacterString();
        this.scanSeparator();
        int n2 = this.charAt(this.currentPosition);
        if ((n2 == 117 || n2 == 85) && this.scanSpecialIdentifier("UESCAPE")) {
            this.scanSeparator();
            n = this.scanEscapeDefinition();
            if (n == -1) {
                this.token.tokenType = 1026;
                this.token.isMalformed = true;
                return;
            }
        }
        this.convertUnicodeString(n);
    }

    private boolean scanUnicodeIdentifier() {
        int n = 92;
        this.scanStringPart('\"');
        if (this.token.isMalformed) {
            return false;
        }
        this.token.tokenString = this.charWriter.toString();
        int n2 = this.charAt(this.currentPosition);
        if ((n2 == 117 || n2 == 85) && this.scanSpecialIdentifier("UESCAPE")) {
            this.scanSeparator();
            n = this.scanEscapeDefinition();
            if (n == -1) {
                this.token.tokenType = 1026;
                this.token.isMalformed = true;
                return false;
            }
        }
        this.convertUnicodeString(n);
        return !this.token.isMalformed;
    }

    boolean shiftPrefixes() {
        if (this.token.namePrePrePrefix != null) {
            return false;
        }
        this.token.namePrePrePrefix = this.token.namePrePrefix;
        this.token.isDelimitedPrePrePrefix = this.token.isDelimitedPrePrefix;
        this.token.namePrePrefix = this.token.namePrefix;
        this.token.isDelimitedPrePrefix = this.token.isDelimitedPrefix;
        this.token.namePrefix = this.token.tokenString;
        this.token.isDelimitedPrefix = this.token.tokenType == 1013;
        return true;
    }

    private void scanIdentifierChain() {
        boolean bl;
        int n = this.charAt(this.currentPosition);
        switch (n) {
            case 96: {
                if (!this.backtickQuoting) break;
                this.charWriter.reset(this.charBuffer);
                this.scanStringPart('`');
                if (this.token.isMalformed) {
                    return;
                }
                this.token.tokenType = 1013;
                this.token.tokenString = this.charWriter.toString();
                this.token.isDelimiter = true;
                break;
            }
            case 34: {
                this.charWriter.reset(this.charBuffer);
                this.scanStringPart('\"');
                if (this.token.isMalformed) {
                    return;
                }
                this.token.tokenType = 1013;
                this.token.tokenString = this.charWriter.toString();
                this.token.isDelimiter = true;
                break;
            }
            case 85: 
            case 117: {
                if (this.charAt(this.currentPosition + 1) == 38 && this.charAt(this.currentPosition + 1) == 34) {
                    this.currentPosition += 3;
                    bl = this.scanUnicodeIdentifier();
                    if (!bl) {
                        return;
                    }
                    this.token.tokenType = 1013;
                    this.token.isDelimiter = false;
                    break;
                }
            }
            default: {
                bl = this.scanUndelimitedIdentifier();
                if (!bl) {
                    return;
                }
                this.token.tokenType = 1012;
                this.token.isDelimiter = false;
            }
        }
        bl = this.scanWhitespace();
        n = this.charAt(this.currentPosition);
        if (n == 46) {
            int n2;
            if (bl && (n2 = this.charAt(this.currentPosition + 1)) >= 48 && n2 <= 57) {
                return;
            }
            ++this.currentPosition;
            this.scanWhitespace();
            n = this.charAt(this.currentPosition);
            if (n == 42) {
                ++this.currentPosition;
                this.shiftPrefixes();
                this.token.tokenString = "*";
                this.token.tokenType = 921;
            } else {
                this.shiftPrefixes();
                this.scanIdentifierChain();
            }
        }
    }

    public boolean scanUndelimitedIdentifier() {
        int n;
        int n2;
        boolean bl;
        if (this.currentPosition == this.limit) {
            return false;
        }
        char c = this.sqlString.charAt(this.currentPosition);
        boolean bl2 = bl = c == '_' || c == '$';
        if (!bl && !Character.isLetter(c)) {
            this.token.tokenString = Character.toString(c);
            this.token.tokenType = -1;
            this.token.isMalformed = true;
            return false;
        }
        for (n2 = this.currentPosition + 1; n2 < this.limit; ++n2) {
            n = this.sqlString.charAt(n2);
            if (n == 36) {
                bl = true;
                continue;
            }
            if (n != 95 && !Character.isLetterOrDigit((char)n)) break;
        }
        this.token.tokenString = this.sqlString.substring(this.currentPosition, n2).toUpperCase(Locale.ENGLISH);
        this.currentPosition = n2;
        if (this.nullAndBooleanAsValue && ((n = this.currentPosition - this.tokenPosition) == 4 || n == 5)) {
            switch (c) {
                case 'T': 
                case 't': {
                    if (!"TRUE".equals(this.token.tokenString)) break;
                    this.token.tokenString = "TRUE";
                    this.token.tokenType = 1011;
                    this.token.tokenValue = Boolean.TRUE;
                    this.token.dataType = Type.SQL_BOOLEAN;
                    return false;
                }
                case 'F': 
                case 'f': {
                    if (!"FALSE".equals(this.token.tokenString)) break;
                    this.token.tokenString = "FALSE";
                    this.token.tokenType = 1011;
                    this.token.tokenValue = Boolean.FALSE;
                    this.token.dataType = Type.SQL_BOOLEAN;
                    return false;
                }
                case 'N': 
                case 'n': {
                    if (!"NULL".equals(this.token.tokenString)) break;
                    this.token.tokenString = "NULL";
                    this.token.tokenType = 1011;
                    this.token.tokenValue = null;
                    return false;
                }
            }
        }
        if (bl) {
            this.token.hasIrregularChar = true;
        }
        return true;
    }

    void scanNumber() {
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        this.token.tokenType = 1011;
        this.token.dataType = Type.SQL_INTEGER;
        int n2 = this.currentPosition;
        while (this.currentPosition < this.limit) {
            boolean bl3 = false;
            int n3 = this.charAt(this.currentPosition);
            switch (n3) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    bl = true;
                    break;
                }
                case 46: {
                    this.token.dataType = Type.SQL_NUMERIC;
                    if (bl2 || n != -1) {
                        this.token.tokenString = this.sqlString.substring(n2, this.currentPosition + 1);
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                        return;
                    }
                    bl2 = true;
                    break;
                }
                case 69: 
                case 101: {
                    this.token.dataType = Type.SQL_DOUBLE;
                    if (n != -1 || !bl) {
                        this.token.tokenString = this.sqlString.substring(n2, this.currentPosition + 1);
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                        return;
                    }
                    bl2 = true;
                    n = this.currentPosition;
                    break;
                }
                case 43: 
                case 45: {
                    if (n == this.currentPosition - 1) break;
                    bl3 = true;
                    break;
                }
                case 71: 
                case 75: 
                case 77: 
                case 80: 
                case 84: 
                case 103: 
                case 107: 
                case 109: 
                case 112: 
                case 116: {
                    if (!bl || bl2) {
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                        return;
                    }
                    String string = Character.toString((char)n3).toUpperCase(Locale.ENGLISH);
                    this.token.lobMultiplierType = Tokens.getNonKeywordID(string, 1020);
                    if (this.token.lobMultiplierType == 1020) {
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                        return;
                    }
                    try {
                        this.token.tokenValue = ValuePool.getInt(Integer.parseInt(this.sqlString.substring(n2, this.currentPosition)));
                        this.token.tokenType = 1018;
                        ++this.currentPosition;
                        this.token.fullString = this.getPart(this.tokenPosition, this.currentPosition);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                    }
                    return;
                }
                default: {
                    bl3 = true;
                }
            }
            if (bl3) break;
            ++this.currentPosition;
        }
        this.token.tokenString = this.sqlString.substring(n2, this.currentPosition);
        switch (this.token.dataType.typeCode) {
            case 4: {
                if (this.token.tokenString.length() < 20) {
                    try {
                        long l = Long.parseLong(this.token.tokenString);
                        if (this.token.tokenString.length() < 11 && l <= Integer.MAX_VALUE) {
                            this.token.tokenValue = ValuePool.getInt((int)l);
                            return;
                        }
                        this.token.dataType = Type.SQL_BIGINT;
                        this.token.tokenValue = ValuePool.getLong(l);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.token.dataType = Type.SQL_NUMERIC;
            }
            case 2: {
                try {
                    BigDecimal bigDecimal = new BigDecimal(this.token.tokenString);
                    this.token.tokenValue = bigDecimal;
                    this.token.dataType = NumberType.getNumberTypeForLiteral(bigDecimal);
                }
                catch (Exception exception) {
                    this.token.tokenType = 1020;
                    this.token.isMalformed = true;
                    return;
                }
                return;
            }
            case 8: {
                try {
                    double d = Double.parseDouble(this.token.tokenString);
                    long l = Double.doubleToLongBits(d);
                    this.token.tokenValue = ValuePool.getDouble(l);
                }
                catch (Exception exception) {
                    this.token.tokenType = 1020;
                    this.token.isMalformed = true;
                    return;
                }
                return;
            }
        }
    }

    boolean scanSeparator() {
        boolean bl = false;
        while (true) {
            boolean bl2 = this.scanWhitespace();
            bl |= bl2;
            if (!this.scanCommentAsInlineSeparator()) break;
            bl = true;
            this.hasNonSpaceSeparator = true;
        }
        return bl;
    }

    boolean scanCommentAsInlineSeparator() {
        int n = this.charAt(this.currentPosition);
        if (n == 45 && this.charAt(this.currentPosition + 1) == 45) {
            int n2 = this.sqlString.indexOf(13, this.currentPosition + 2);
            if (n2 == -1) {
                n2 = this.sqlString.indexOf(10, this.currentPosition + 2);
            } else if (this.charAt(n2 + 1) == 10) {
                ++n2;
            }
            this.currentPosition = n2 == -1 ? this.limit : n2 + 1;
            return true;
        }
        if (n == 47 && this.charAt(this.currentPosition + 1) == 42) {
            return this.skipBracketedComment();
        }
        return false;
    }

    public boolean scanWhitespace() {
        boolean bl = false;
        while (this.currentPosition < this.limit) {
            char c = this.sqlString.charAt(this.currentPosition);
            if (c == ' ') {
                bl = true;
            } else {
                if (!whiteSpaceSet.contains(c)) break;
                this.hasNonSpaceSeparator = true;
                bl = true;
            }
            ++this.currentPosition;
        }
        return bl;
    }

    private static int countEndOfLines(String string, int n) {
        int n2 = -2;
        char c = '\u0000';
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 != '\r' && c2 != '\n') continue;
            if (i == n2 + 1) {
                if (c2 != '\n' || c == c2) {
                    ++n3;
                }
            } else {
                ++n3;
            }
            n2 = i;
            c = c2;
        }
        return n3;
    }

    void scanCharacterString() {
        this.charWriter.reset(this.charBuffer);
        do {
            this.scanStringPart('\'');
            if (!this.token.isMalformed) continue;
            return;
        } while (this.scanSeparator() && this.charAt(this.currentPosition) == 39);
        this.token.tokenString = this.charWriter.toString();
        this.token.tokenValue = this.token.tokenString;
    }

    public void scanStringPart(char c) {
        int n;
        ++this.currentPosition;
        while (true) {
            if ((n = this.sqlString.indexOf(c, this.currentPosition)) < 0) {
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.limit);
                this.token.tokenType = c == '\'' ? 1019 : 1025;
                this.token.isMalformed = true;
                return;
            }
            if (this.charAt(n + 1) != c) break;
            this.charWriter.write(this.sqlString, this.currentPosition, ++n - this.currentPosition);
            this.currentPosition = n + 1;
        }
        this.charWriter.write(this.sqlString, this.currentPosition, n - this.currentPosition);
        this.currentPosition = n + 1;
    }

    void scanToken() {
        int n = this.charAt(this.currentPosition);
        this.resetState();
        this.token.tokenType = 1012;
        switch (n) {
            case 91: {
                this.token.tokenString = "[";
                this.token.tokenType = 932;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 93: {
                this.token.tokenString = "]";
                this.token.tokenType = 942;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 40: {
                this.token.tokenString = "(";
                this.token.tokenType = 937;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 41: {
                this.token.tokenString = ")";
                this.token.tokenType = 922;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 44: {
                this.token.tokenString = ",";
                this.token.tokenType = 924;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 42: {
                this.token.tokenString = "*";
                this.token.tokenType = 921;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 61: {
                this.token.tokenString = "=";
                this.token.tokenType = 420;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 59: {
                this.token.tokenString = ";";
                this.token.tokenType = 943;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 43: {
                this.token.tokenString = "+";
                this.token.tokenType = 938;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 58: {
                if (this.charAt(this.currentPosition + 1) == 58) {
                    this.currentPosition += 2;
                    this.token.tokenString = "::";
                    this.token.tokenType = 927;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = ":";
                this.token.tokenType = 923;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 63: {
                if (this.charAt(this.currentPosition + 1) == 63) {
                    if (this.charAt(this.currentPosition + 2) == 40) {
                        this.token.tokenString = "[";
                        this.token.tokenType = 932;
                        this.currentPosition += 3;
                        this.token.isDelimiter = true;
                        return;
                    }
                    if (this.charAt(this.currentPosition + 2) == 41) {
                        this.token.tokenString = "]";
                        this.token.tokenType = 942;
                        this.currentPosition += 3;
                        this.token.isDelimiter = true;
                        return;
                    }
                }
                this.token.tokenString = "?";
                this.token.tokenType = 939;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 33: {
                if (this.charAt(this.currentPosition + 1) == 61) {
                    this.token.tokenString = "<>";
                    this.token.tokenType = 936;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
                this.token.tokenType = -1;
                this.token.isDelimiter = true;
                return;
            }
            case 60: {
                if (this.charAt(this.currentPosition + 1) == 62) {
                    this.token.tokenString = "<>";
                    this.token.tokenType = 936;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                if (this.charAt(this.currentPosition + 1) == 61) {
                    this.token.tokenString = "<=";
                    this.token.tokenType = 934;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = "<";
                this.token.tokenType = 933;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 62: {
                if (this.charAt(this.currentPosition + 1) == 61) {
                    this.token.tokenString = ">=";
                    this.token.tokenType = 930;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = ">";
                this.token.tokenType = 929;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 124: {
                if (this.charAt(this.currentPosition + 1) == 124) {
                    this.token.tokenString = "||";
                    this.token.tokenType = 925;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
                this.token.tokenType = -1;
                this.token.isDelimiter = true;
                return;
            }
            case 47: {
                if (this.charAt(this.currentPosition + 1) == 47) {
                    int n2 = this.sqlString.indexOf(13, this.currentPosition + 2);
                    if (n2 == -1) {
                        n2 = this.sqlString.indexOf(10, this.currentPosition + 2);
                    }
                    if (n2 == -1) {
                        n2 = this.limit;
                    }
                    this.token.tokenString = this.sqlString.substring(this.currentPosition + 2, n2);
                    this.token.tokenType = 1016;
                    this.token.isDelimiter = true;
                    return;
                }
                if (this.charAt(this.currentPosition + 1) == 42) {
                    this.scanBracketedComment();
                    return;
                }
                this.token.tokenString = "/";
                this.token.tokenType = 926;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 45: {
                if (this.charAt(this.currentPosition + 1) == 45) {
                    int n3 = this.sqlString.indexOf(13, this.currentPosition + 2);
                    if (n3 == -1) {
                        n3 = this.sqlString.indexOf(10, this.currentPosition + 2);
                    }
                    if (n3 == -1) {
                        n3 = this.limit;
                    }
                    this.token.tokenString = this.sqlString.substring(this.currentPosition + 2, n3);
                    this.token.tokenType = 1016;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = "-";
                this.token.tokenType = 935;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 34: {
                this.token.tokenType = 1013;
                break;
            }
            case 96: {
                if (!this.backtickQuoting) break;
                this.token.tokenType = 1013;
                break;
            }
            case 39: {
                this.scanCharacterString();
                if (this.token.isMalformed) {
                    return;
                }
                int n4 = this.charLiteral ? 1 : 12;
                this.token.dataType = CharacterType.getCharacterType(n4, this.token.tokenString.length());
                this.token.tokenType = 1011;
                this.token.isDelimiter = true;
                return;
            }
            case 88: 
            case 120: {
                if (this.charAt(this.currentPosition + 1) != 39) break;
                ++this.currentPosition;
                this.scanBinaryString();
                if (this.token.isMalformed) {
                    return;
                }
                this.token.dataType = BinaryType.getBinaryType(61, ((BinaryData)this.token.tokenValue).length(null));
                this.token.tokenType = 1011;
                return;
            }
            case 66: 
            case 98: {
                if (this.charAt(this.currentPosition + 1) != 39) break;
                ++this.currentPosition;
                this.scanBitString();
                if (this.token.isMalformed) {
                    return;
                }
                this.token.dataType = BitType.getBitType(14, ((BinaryData)this.token.tokenValue).bitLength(null));
                this.token.tokenType = 1011;
                return;
            }
            case 78: 
            case 110: {
                if (this.charAt(this.currentPosition + 1) != 39) break;
                ++this.currentPosition;
                this.scanCharacterString();
                if (this.token.isMalformed) {
                    return;
                }
                int n5 = this.charLiteral ? 1 : 12;
                this.token.dataType = CharacterType.getCharacterType(n5, this.token.tokenString.length());
                this.token.tokenType = 1011;
                return;
            }
            case 85: 
            case 117: {
                if (this.charAt(this.currentPosition + 1) != 38 || this.charAt(this.currentPosition + 2) != 39) break;
                this.currentPosition += 2;
                this.token.dataType = Type.SQL_CHAR;
                this.token.tokenType = 1011;
                this.scanUnicodeString();
                if (this.token.isMalformed) {
                    return;
                }
                int n6 = this.charLiteral ? 1 : 12;
                this.token.dataType = CharacterType.getCharacterType(n6, ((String)this.token.tokenValue).length());
                return;
            }
            case 95: {
                int n7 = this.currentPosition++;
                this.scanIdentifierChain();
                if (this.token.isMalformed) {
                    this.position(n7);
                    this.resetState();
                    break;
                }
                if (this.token.tokenType != 1012) {
                    this.token.tokenType = 1019;
                    this.token.isMalformed = true;
                    return;
                }
                this.scanSeparator();
                if (this.charAt(this.currentPosition) == 39) {
                    if (this.token.namePrePrefix != null) {
                        this.token.tokenType = 1019;
                        this.token.isMalformed = true;
                        return;
                    }
                    this.token.charsetSchema = this.token.namePrefix;
                    this.token.charsetName = this.token.tokenString;
                    this.scanCharacterString();
                    this.token.tokenType = 1011;
                    this.token.dataType = CharacterType.getCharacterType(1, this.token.tokenString.length());
                    this.token.isDelimiter = true;
                    return;
                }
                this.position(n7);
                this.resetState();
                break;
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.token.tokenType = 1011;
                this.scanNumber();
                return;
            }
        }
        this.scanIdentifierChain();
        this.setIdentifierProperties();
    }

    private boolean skipBracketedComment() {
        int n = this.sqlString.indexOf("*/", this.currentPosition + 2);
        if (n == -1) {
            this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
            this.token.tokenType = 1024;
            this.token.isMalformed = true;
            return false;
        }
        String string = this.sqlString.substring(this.currentPosition + 2, n);
        this.currentPosition = n + 2;
        return true;
    }

    private boolean scanBracketedComment() {
        int n = this.sqlString.indexOf("*/", this.currentPosition + 2);
        if (n == -1) {
            this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
            this.token.tokenType = -1;
            this.token.isDelimiter = true;
            return false;
        }
        this.token.tokenString = this.sqlString.substring(this.currentPosition + 2, n);
        this.token.tokenType = 1016;
        this.token.isDelimiter = true;
        return true;
    }

    private void setIdentifierProperties() {
        if (this.token.tokenType == 1012) {
            this.token.isUndelimitedIdentifier = true;
            if (this.token.namePrefix == null) {
                this.token.tokenType = Tokens.getKeywordID(this.token.tokenString, 1012);
                if (this.token.tokenType == 1012) {
                    this.token.tokenType = Tokens.getNonKeywordID(this.token.tokenString, 1012);
                } else {
                    this.token.isReservedIdentifier = true;
                    this.token.isCoreReservedIdentifier = Tokens.isCoreKeyword(this.token.tokenType);
                }
            }
        } else if (this.token.tokenType == 1013) {
            this.token.isDelimitedIdentifier = true;
        }
    }

    public boolean scanNull() {
        this.scanSeparator();
        int n = this.charAt(this.currentPosition);
        return (n == 78 || n == 110) && this.scanSpecialIdentifier("NULL");
    }

    private void scanNext(int n) {
        this.scanNext();
        if (this.token.isMalformed) {
            throw Error.error(n);
        }
    }

    IntervalType scanIntervalType() {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = n = this.token.tokenType;
        this.scanNext(3406);
        if (this.token.tokenType == 937) {
            this.scanNext(3406);
            if (this.token.dataType == null || this.token.dataType.typeCode != 4) {
                throw Error.error(3406);
            }
            n2 = ((Number)this.token.tokenValue).intValue();
            this.scanNext(3406);
            if (this.token.tokenType == 924) {
                if (n4 != 264) {
                    throw Error.error(3406);
                }
                this.scanNext(3406);
                if (this.token.dataType == null || this.token.dataType.typeCode != 4) {
                    throw Error.error(3406);
                }
                n3 = ((Number)this.token.tokenValue).intValue();
                this.scanNext(3406);
            }
            if (this.token.tokenType != 922) {
                throw Error.error(3406);
            }
            this.scanNext(3406);
        }
        if (this.token.tokenType == 301) {
            this.scanNext(3406);
            n = this.token.tokenType;
            this.scanNext(3406);
        }
        if (this.token.tokenType == 937) {
            if (n != 264 || n == n4) {
                throw Error.error(3406);
            }
            this.scanNext(3406);
            if (this.token.dataType == null || this.token.dataType.typeCode != 4) {
                throw Error.error(3406);
            }
            n3 = ((Number)this.token.tokenValue).intValue();
            this.scanNext(3406);
            if (this.token.tokenType != 922) {
                throw Error.error(3406);
            }
            this.scanNext(3406);
        }
        int n5 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n4);
        int n6 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n);
        return IntervalType.getIntervalType(n5, n6, n2, n3);
    }

    public TimestampData newDate(String string) {
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.dateTimeType = null;
        this.intervalString = string;
        this.scanDateParts(2);
        if (this.intervalPosition != string.length()) {
            throw Error.error(3407);
        }
        long l = HsqlDateTime.getDateSeconds(string);
        return new TimestampData(l);
    }

    public TimestampData newTimestamp(String string) {
        long l = 0L;
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.dateTimeType = null;
        this.intervalString = string;
        this.scanDateParts(5);
        if (this.intervalPosition == 10) {
            long l2 = HsqlDateTime.getDateSeconds(string.substring(0, this.intervalPosition));
            this.dateTimeType = Type.SQL_TIMESTAMP_NO_FRACTION;
            return new TimestampData(l2, n, (int)l);
        }
        long l3 = HsqlDateTime.getTimestampSeconds(string.substring(0, this.intervalPosition));
        n = this.scanIntervalFraction(9);
        int n3 = this.intervalPosition;
        boolean bl2 = this.scanIntervalSign();
        if (bl2 || n3 != this.intervalPosition) {
            l = this.scanIntervalValue(Type.SQL_INTERVAL_HOUR_TO_MINUTE);
            bl = true;
            if (bl2) {
                l = -l;
            }
        }
        if (l >= (long)DTIType.yearToSecondFactors[2] || l > 64800L || -l > 64800L) {
            throw Error.error(3409);
        }
        if (this.intervalPosition != n2) {
            throw Error.error(3407);
        }
        int n4 = bl ? 95 : 93;
        this.dateTimeType = DateTimeType.getDateTimeType(n4, this.fractionPrecision);
        if (bl) {
            l3 -= l;
        }
        if (l3 > DateTimeType.epochLimitSeconds) {
            throw Error.error(3408);
        }
        return new TimestampData(l3, n, (int)l);
    }

    void scanDateParts(int n) {
        byte[] byArray = DTIType.yearToSecondSeparators;
        int n2 = this.intervalPosition;
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n) {
            boolean bl = false;
            if (n2 == this.intervalString.length()) {
                if (n3 == n) {
                    bl = true;
                } else {
                    if (n3 < 2) {
                        throw Error.error(3407);
                    }
                    bl = true;
                }
            } else {
                char c = this.intervalString.charAt(n2);
                if (c >= '0' && c <= '9') {
                    ++n4;
                    ++n2;
                } else if (c == byArray[n3]) {
                    bl = true;
                    if (n3 != n) {
                        ++n2;
                    }
                } else if (n3 == n) {
                    bl = true;
                } else {
                    throw Error.error(3407);
                }
            }
            if (!bl) continue;
            if (n3 == 0 ? n4 < 4 : n4 == 0 || n4 > 2) {
                throw Error.error(3407);
            }
            ++n3;
            n4 = 0;
            if (n2 != this.intervalString.length()) continue;
            break;
        }
        this.intervalPosition = n2;
    }

    public TimeData newTime(String string) {
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.dateTimeType = null;
        this.intervalString = string;
        long l = this.scanIntervalValue(Type.SQL_INTERVAL_HOUR_TO_SECOND);
        int n = this.scanIntervalFraction(9);
        long l2 = 0L;
        int n2 = this.intervalPosition;
        boolean bl = false;
        boolean bl2 = this.scanIntervalSign();
        if (n2 != this.intervalPosition) {
            l2 = this.scanIntervalValue(Type.SQL_INTERVAL_HOUR_TO_MINUTE);
            bl = true;
        }
        if (this.intervalPosition != string.length()) {
            throw Error.error(3409);
        }
        if (l >= (long)DTIType.yearToSecondFactors[2]) {
            throw Error.error(3408);
        }
        if (l2 > 64800L) {
            throw Error.error(3409);
        }
        if (bl2) {
            l2 = -l2;
        }
        int n3 = bl ? 94 : 92;
        this.dateTimeType = DateTimeType.getDateTimeType(n3, this.fractionPrecision);
        if (bl) {
            l -= l2;
        }
        return new TimeData((int)l, n, (int)l2);
    }

    public Object newInterval(String string, IntervalType intervalType) {
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.intervalString = string;
        boolean bl = this.scanIntervalSign();
        long l = this.scanIntervalValue(intervalType);
        int n = 0;
        if (intervalType.endIntervalType == 106) {
            n = this.scanIntervalFraction(intervalType.scale);
        }
        if (this.intervalPosition != string.length()) {
            throw Error.error(3406);
        }
        if (bl) {
            l = -l;
            n = -n;
        }
        this.dateTimeType = intervalType;
        if (intervalType.defaultPrecision) {
            this.dateTimeType = IntervalType.getIntervalType(intervalType.typeCode, intervalType.startIntervalType, intervalType.endIntervalType, this.intervalPrecision, this.fractionPrecision, false);
        }
        if (intervalType.endPartIndex <= 1) {
            return new IntervalMonthData(l);
        }
        return new IntervalSecondData(l, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long scanIntervalValue(IntervalType intervalType) {
        byte[] byArray = DTIType.yearToSecondSeparators;
        int[] nArray = DTIType.yearToSecondFactors;
        int[] nArray2 = DTIType.yearToSecondLimits;
        int n = intervalType.startPartIndex;
        int n2 = intervalType.endPartIndex;
        long l = 0L;
        long l2 = 0L;
        int n3 = this.intervalPosition;
        int n4 = n;
        int n5 = 0;
        while (n4 <= n2) {
            int n6;
            boolean bl = false;
            if (n3 == this.intervalString.length()) {
                if (n4 != n2) throw Error.error(3406);
                bl = true;
            } else {
                n6 = this.intervalString.charAt(n3);
                if (n6 >= 48 && n6 <= 57) {
                    int n7 = n6 - 48;
                    l2 *= 10L;
                    l2 += (long)n7;
                    ++n5;
                    ++n3;
                } else if (n6 == byArray[n4]) {
                    bl = true;
                    if (n4 != n2) {
                        ++n3;
                    }
                } else {
                    if (n4 != n2) throw Error.error(3406);
                    bl = true;
                }
            }
            if (!bl) continue;
            if (n4 == n) {
                if (!intervalType.defaultPrecision && (long)n5 > intervalType.precision) {
                    throw Error.error(3435);
                }
                if (n5 == 0) {
                    throw Error.error(3406);
                }
                n6 = nArray[n4];
                l += l2 * (long)n6;
                this.intervalPrecision = n5;
            } else {
                if (l2 >= (long)nArray2[n4]) {
                    throw Error.error(3435);
                }
                if (n5 == 0 || n5 > 2) {
                    throw Error.error(3406);
                }
                l += l2 * (long)nArray[n4];
            }
            ++n4;
            l2 = 0L;
            n5 = 0;
            if (n3 != this.intervalString.length()) continue;
            break;
        }
        this.intervalPosition = n3;
        return l;
    }

    boolean scanIntervalSign() {
        boolean bl = false;
        if (this.intervalPosition == this.intervalString.length()) {
            return false;
        }
        if (this.intervalString.charAt(this.intervalPosition) == '-') {
            bl = true;
            ++this.intervalPosition;
        } else if (this.intervalString.charAt(this.intervalPosition) == '+') {
            ++this.intervalPosition;
        }
        return bl;
    }

    int scanIntervalFraction(int n) {
        char c;
        if (this.intervalPosition == this.intervalString.length()) {
            return 0;
        }
        if (this.intervalString.charAt(this.intervalPosition) != '.') {
            return 0;
        }
        ++this.intervalPosition;
        int n2 = 0;
        int n3 = 0;
        while (this.intervalPosition < this.intervalString.length() && (c = this.intervalString.charAt(this.intervalPosition)) >= '0' && c <= '9') {
            int n4 = c - 48;
            n2 *= 10;
            n2 += n4;
            ++this.intervalPosition;
            if (++n3 != 9) continue;
            break;
        }
        this.fractionPrecision = n3;
        n2 = DTIType.normaliseFraction(n2, n3, n);
        return n2;
    }

    void scanIntervalSpaces() {
        while (this.intervalPosition < this.intervalString.length() && this.intervalString.charAt(this.intervalPosition) == ' ') {
            ++this.intervalPosition;
        }
    }

    public synchronized Number convertToNumber(String string, NumberType numberType) {
        boolean bl = false;
        this.reset(string);
        this.resetState();
        this.scanWhitespace();
        this.scanToken();
        this.scanWhitespace();
        switch (this.token.tokenType) {
            case 935: {
                bl = true;
                this.scanToken();
                this.scanWhitespace();
                if (this.token.tokenType != 646) break;
                bl = false;
                this.token.tokenType = 1011;
                this.token.dataType = Type.SQL_DOUBLE;
                this.token.tokenValue = Double.NEGATIVE_INFINITY;
                break;
            }
            case 938: {
                this.scanToken();
                this.scanWhitespace();
                break;
            }
            case 662: {
                this.token.tokenType = 1011;
                this.token.dataType = Type.SQL_DOUBLE;
                this.token.tokenValue = Double.NaN;
                break;
            }
            case 646: {
                this.token.tokenType = 1011;
                this.token.dataType = Type.SQL_DOUBLE;
                this.token.tokenValue = Double.POSITIVE_INFINITY;
            }
        }
        if (!this.hasNonSpaceSeparator && this.token.tokenType == 1011 && this.token.tokenValue instanceof Number) {
            Number number = (Number)this.token.tokenValue;
            Type type = this.token.dataType;
            if (bl) {
                number = (Number)this.token.dataType.negate(number);
            }
            this.scanEnd();
            if (this.token.tokenType == 1014) {
                number = (Number)numberType.convertToType(null, number, type);
                return number;
            }
        }
        throw Error.error(3438);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized BinaryData convertToBinary(String string, boolean bl) {
        boolean bl2 = true;
        byte by = 0;
        this.reset(string);
        this.resetState();
        this.byteOutputStream.reset(this.byteBuffer);
        while (this.currentPosition < this.limit) {
            block9: {
                char c = this.sqlString.charAt(this.currentPosition);
                int n = Scanner.getHexValue(c);
                if (n == -1) {
                    if (bl && c == '-' && bl2) {
                        bl2 = !bl2;
                        break block9;
                    } else {
                        this.token.tokenType = 1022;
                        this.token.isMalformed = true;
                        break;
                    }
                }
                if (bl2) {
                    by = (byte)(n << 4);
                } else {
                    by = (byte)(by + (byte)n);
                    this.byteOutputStream.writeByte(by);
                }
            }
            ++this.currentPosition;
            bl2 = !bl2;
        }
        if (!bl2) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
        }
        if (bl && this.byteOutputStream.size() != 16) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
        }
        if (this.token.isMalformed) {
            throw Error.error(3438);
        }
        BinaryData binaryData = new BinaryData(this.byteOutputStream.toByteArray(), false);
        this.byteOutputStream.reset(this.byteBuffer);
        return binaryData;
    }

    public synchronized BinaryData convertToBit(String string) {
        BitMap bitMap = new BitMap(0, true);
        int n = 0;
        this.reset(string);
        this.resetState();
        this.byteOutputStream.reset(this.byteBuffer);
        while (this.currentPosition < this.limit) {
            char c = this.sqlString.charAt(this.currentPosition);
            if (c == '0') {
                bitMap.unset(n);
                ++n;
            } else if (c == '1') {
                bitMap.set(n);
                ++n;
            } else {
                this.token.tokenType = 1021;
                this.token.isMalformed = true;
                throw Error.error(3438);
            }
            ++this.currentPosition;
        }
        bitMap.setSize(n);
        return BinaryData.getBitData(bitMap.getBytes(), bitMap.size());
    }

    public synchronized Object convertToDatetimeInterval(SessionInterface sessionInterface, String string, DTIType dTIType) {
        IntervalType intervalType = null;
        int n = -1;
        int n2 = dTIType.isDateTimeType() ? 3407 : 3406;
        this.reset(string);
        this.resetState();
        this.scanToken();
        this.scanWhitespace();
        switch (this.token.tokenType) {
            case 77: 
            case 150: 
            case 297: 
            case 298: {
                n = this.token.tokenType;
                this.scanToken();
                if (this.token.tokenType != 1011 || !this.token.dataType.isCharacterType()) {
                    throw Error.error(n2);
                }
                string = this.token.tokenString;
                this.scanNext(3407);
                if (dTIType.isIntervalType()) {
                    intervalType = this.scanIntervalType();
                }
                if (this.token.tokenType == 1014) break;
                throw Error.error(n2);
            }
        }
        switch (dTIType.typeCode) {
            case 91: {
                if (n != -1 && n != 77) {
                    throw Error.error(n2);
                }
                TimestampData timestampData = this.newDate(string);
                return dTIType.convertToType(sessionInterface, timestampData, Type.SQL_DATE);
            }
            case 92: 
            case 94: {
                if (n != -1 && n != 297) {
                    throw Error.error(n2);
                }
                TimeData timeData = this.newTime(string);
                return dTIType.convertToType(sessionInterface, timeData, this.dateTimeType);
            }
            case 93: 
            case 95: {
                if (n != -1 && n != 298) {
                    throw Error.error(n2);
                }
                TimestampData timestampData = this.newTimestamp(string);
                return dTIType.convertToType(sessionInterface, timestampData, this.dateTimeType);
            }
        }
        if (n != -1 && n != 150) {
            throw Error.error(n2);
        }
        if (dTIType.isIntervalType()) {
            Object object = this.newInterval(string, (IntervalType)dTIType);
            if (intervalType != null && (intervalType.startIntervalType != dTIType.startIntervalType || intervalType.endIntervalType != dTIType.endIntervalType)) {
                throw Error.error(n2);
            }
            return dTIType.convertToType(sessionInterface, object, this.dateTimeType);
        }
        throw Error.runtimeError(201, "Scanner");
    }

    static {
        for (int i = 0; i < whitespace.length; ++i) {
            whiteSpaceSet.add(whitespace[i]);
        }
        maxPooledStringLength = ValuePool.getMaxStringLength();
    }
}

