/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.DataTypeEnum;
import com.ing.data.cassandra.jdbc.types.TypesMap;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class CassandraParameterMetaData
implements ParameterMetaData {
    private final BoundStatement boundStatement;
    private final int parametersCount;

    public CassandraParameterMetaData(BoundStatement boundStatement, int parametersCount) {
        this.boundStatement = boundStatement;
        this.parametersCount = parametersCount;
    }

    private String getParameterCqlType(int i) {
        return DataTypeEnum.cqlName(this.boundStatement.getType(i - 1));
    }

    private AbstractJdbcType<?> getParameterJdbcType(int i) {
        return TypesMap.getTypeForComparator(this.getParameterCqlType(i).toLowerCase());
    }

    @Override
    public int getParameterCount() {
        return this.parametersCount;
    }

    @Override
    public int isNullable(int i) {
        return 1;
    }

    @Override
    public boolean isSigned(int i) throws SQLException {
        return this.getParameterJdbcType(i).isSigned();
    }

    @Override
    public int getPrecision(int i) throws SQLException {
        return this.getParameterJdbcType(i).getPrecision(null);
    }

    @Override
    public int getScale(int i) throws SQLException {
        return this.getParameterJdbcType(i).getScale(null);
    }

    @Override
    public int getParameterType(int i) {
        return this.getParameterJdbcType(i).getJdbcType();
    }

    @Override
    public String getParameterTypeName(int i) {
        return this.getParameterCqlType(i);
    }

    @Override
    public String getParameterClassName(int i) {
        return this.getParameterJdbcType(i).getType().getName();
    }

    @Override
    public int getParameterMode(int i) {
        return 1;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException(String.format("No object was found that matched the provided interface: %s", iface.getSimpleName()));
    }
}

