/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CassandraBlobDeserializer
extends JsonDeserializer<ByteBuffer> {
    public ByteBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String value = jsonParser.getValueAsString();
        if (value != null) {
            return ByteBuffer.wrap(CassandraBlobDeserializer.hexStringToByteArray(value));
        }
        return null;
    }

    private static byte[] hexStringToByteArray(String input) {
        String hexString = input.replace("0x", "");
        int len = hexString.length();
        if (!hexString.matches("[0-9A-Fa-f]*") || len % 2 != 0) {
            throw new IllegalArgumentException("Invalid value: expecting an even-length hexadecimal string.");
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

