/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.metadata;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.ing.data.cassandra.jdbc.CassandraMetadataResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import com.ing.data.cassandra.jdbc.metadata.AbstractMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.MetadataResultSet;
import com.ing.data.cassandra.jdbc.metadata.MetadataRow;
import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.TypesMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FunctionMetadataResultSetBuilder
extends AbstractMetadataResultSetBuilder {
    public FunctionMetadataResultSetBuilder(CassandraStatement statement) throws SQLException {
        super(statement);
    }

    public CassandraMetadataResultSet buildFunctions(String schemaPattern, String functionNamePattern) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> functionsRows = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("REMARKS", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_TYPE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SPECIFIC_NAME", DataTypes.TEXT));
        this.filterBySchemaNamePattern(schemaPattern, keyspaceMetadata -> this.filterByFunctionNamePattern(functionNamePattern, (KeyspaceMetadata)keyspaceMetadata, (functionSignature, functionMetadata) -> {
            MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), functionSignature.getName().asInternal(), "", String.valueOf(1), functionSignature.getName().asInternal());
            functionsRows.add(row);
        }), null);
        functionsRows.sort(Comparator.comparing(row -> ((MetadataRow)row).getString("FUNCTION_SCHEM")).thenComparing(row -> ((MetadataRow)row).getString("FUNCTION_NAME")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(functionsRows));
    }

    public CassandraMetadataResultSet buildFunctionColumns(String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> functionParamsRows = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_TYPE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DATA_TYPE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("PRECISION", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("LENGTH", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SCALE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("RADIX", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("NULLABLE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("REMARKS", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("CHAR_OCTET_LENGTH", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ORDINAL_POSITION", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("IS_NULLABLE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SPECIFIC_NAME", DataTypes.TEXT));
        this.filterBySchemaNamePattern(schemaPattern, keyspaceMetadata -> this.filterByFunctionNamePattern(functionNamePattern, (KeyspaceMetadata)keyspaceMetadata, (functionSignature, functionMetadata) -> {
            AbstractJdbcType<?> returnJdbcType = TypesMap.getTypeForComparator(functionMetadata.getReturnType().asCql(false, true));
            MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), functionSignature.getName().asInternal(), "", String.valueOf(4), String.valueOf(returnJdbcType.getJdbcType()), functionMetadata.getReturnType().toString(), String.valueOf(returnJdbcType.getPrecision(null)), String.valueOf(Integer.MAX_VALUE), String.valueOf(returnJdbcType.getScale(null)), String.valueOf(returnJdbcType.getPrecision(null)), String.valueOf(1), "", null, "0", "YES", functionSignature.getName().asInternal());
            functionParamsRows.add(row);
            List paramNames = functionMetadata.getParameterNames();
            for (int i = 0; i < paramNames.size(); ++i) {
                if (columnNamePattern != null && !this.matchesPattern(columnNamePattern, ((CqlIdentifier)paramNames.get(i)).asInternal())) continue;
                AbstractJdbcType<?> paramJdbcType = TypesMap.getTypeForComparator(((DataType)functionSignature.getParameterTypes().get(i)).asCql(false, true));
                MetadataRow paramRow = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), functionSignature.getName().asInternal(), ((CqlIdentifier)paramNames.get(i)).asInternal(), String.valueOf(1), String.valueOf(paramJdbcType.getJdbcType()), ((DataType)functionSignature.getParameterTypes().get(i)).toString(), String.valueOf(paramJdbcType.getPrecision(null)), String.valueOf(Integer.MAX_VALUE), String.valueOf(paramJdbcType.getScale(null)), String.valueOf(paramJdbcType.getPrecision(null)), String.valueOf(1), "", null, String.valueOf(i + 1), "YES", functionSignature.getName().asInternal());
                functionParamsRows.add(paramRow);
            }
        }), null);
        functionParamsRows.sort(Comparator.comparing(row -> ((MetadataRow)row).getString("FUNCTION_SCHEM")).thenComparing(row -> ((MetadataRow)row).getString("FUNCTION_NAME")).thenComparing(row -> ((MetadataRow)row).getString("SPECIFIC_NAME")).thenComparing(row -> Integer.valueOf(((MetadataRow)row).getString("ORDINAL_POSITION"))));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(functionParamsRows));
    }
}

