/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.metadata;

import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class MetadataRow {
    private final ArrayList<String> entries = new ArrayList();
    private final HashMap<String, Integer> names = new HashMap();
    private final ArrayList<ColumnDefinitions.Definition> definitions = new ArrayList();

    public MetadataRow addEntry(String key, String value) {
        this.names.put(key, this.entries.size());
        this.entries.add(value);
        this.definitions.add(new ColumnDefinitions.Definition("", "", key, DataTypes.TEXT));
        return this;
    }

    public MetadataRow withTemplate(MetadataRowTemplate template, String ... values) {
        if (template.getColumnDefinitions().length != values.length) {
            throw new RuntimeException("Unable to populate a metadata row.");
        }
        for (int i = 0; i < template.getColumnDefinitions().length; ++i) {
            this.addEntry(template.getColumnDefinitions()[i].getName(), values[i]);
        }
        return this;
    }

    public ColumnDefinitions getColumnDefinitions() {
        ColumnDefinitions.Definition[] definitionArr = new ColumnDefinitions.Definition[this.definitions.size()];
        definitionArr = this.definitions.toArray(definitionArr);
        return new ColumnDefinitions(definitionArr);
    }

    public boolean isNull(int i) {
        return this.entries.get(i) == null;
    }

    public boolean isNull(String name) {
        return this.isNull(this.getIndex(name));
    }

    public boolean getBool(int i) {
        return Boolean.parseBoolean(this.entries.get(i));
    }

    public boolean getBool(String name) {
        return this.getBool(this.getIndex(name));
    }

    public byte getByte(int i) {
        return (byte)this.getInt(i);
    }

    public byte getByte(String name) {
        return (byte)this.getInt(this.getIndex(name));
    }

    public short getShort(int i) {
        return (short)this.getInt(i);
    }

    public short getShort(String name) {
        return (short)this.getInt(this.getIndex(name));
    }

    public int getInt(int i) {
        if (this.isNull(i)) {
            return 0;
        }
        return Integer.parseInt(this.entries.get(i));
    }

    public int getInt(String name) {
        return this.getInt(this.getIndex(name));
    }

    public long getLong(int i) {
        if (this.isNull(i)) {
            return 0L;
        }
        return Long.parseLong(this.entries.get(i));
    }

    public long getLong(String name) {
        return this.getLong(this.getIndex(name));
    }

    public Date getDate(int i) {
        return null;
    }

    public Date getDate(String name) {
        return null;
    }

    public Time getTime(int i) {
        return null;
    }

    public Time getTime(String name) {
        return null;
    }

    public CqlDuration getDuration(int i) {
        return null;
    }

    public CqlDuration getDuration(String name) {
        return null;
    }

    public float getFloat(int i) {
        return 0.0f;
    }

    public float getFloat(String name) {
        return 0.0f;
    }

    public double getDouble(int i) {
        return 0.0;
    }

    public double getDouble(String name) {
        return 0.0;
    }

    public ByteBuffer getBytes(int i) {
        return null;
    }

    public ByteBuffer getBytes(String name) {
        return null;
    }

    public String getString(int i) {
        return this.entries.get(i);
    }

    public String getString(String name) {
        return this.getString(this.getIndex(name));
    }

    public BigInteger getVarint(int i) {
        return null;
    }

    public BigInteger getVarint(String name) {
        return null;
    }

    public BigDecimal getDecimal(int i) {
        return null;
    }

    public BigDecimal getDecimal(String name) {
        return null;
    }

    public UUID getUUID(int i) {
        return null;
    }

    public UUID getUUID(String name) {
        return null;
    }

    public InetAddress getInet(int i) {
        return null;
    }

    public InetAddress getInet(String name) {
        return null;
    }

    public <T> List<T> getList(int i, Class<T> elementsClass) {
        return null;
    }

    public <T> List<T> getList(String name, Class<T> elementsClass) {
        return null;
    }

    public <T> Set<T> getSet(int i, Class<T> elementsClass) {
        return null;
    }

    public <T> Set<T> getSet(String name, Class<T> elementsClass) {
        return null;
    }

    public <K, V> Map<K, V> getMap(int i, Class<K> keysClass, Class<V> valuesClass) {
        return null;
    }

    public <K, V> Map<K, V> getMap(String name, Class<K> keysClass, Class<V> valuesClass) {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String entry : this.entries) {
            sb.append(entry).append(" -- ");
        }
        return "[" + sb + "]";
    }

    private Integer getIndex(String name) {
        Integer idx = this.names.get(name);
        if (idx == null) {
            throw new IllegalArgumentException(name + " is not a column defined in this row.");
        }
        return idx;
    }

    public static class MetadataRowTemplate {
        private final ColumnDefinitions.Definition[] columnDefinitions;

        public MetadataRowTemplate(ColumnDefinitions.Definition ... columnDefinitions) {
            this.columnDefinitions = columnDefinitions;
        }

        public ColumnDefinitions.Definition[] getColumnDefinitions() {
            return this.columnDefinitions;
        }
    }
}

