/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public final class AzureCliToken
implements JsonSerializable<AzureCliToken> {
    private String accessToken;
    private String expiresOn;
    private Long expiresOnUnixTime;
    private String subscription;
    private String tenant;
    private String tokenType;
    private OffsetDateTime tokenExpiry;

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getExpiresOn() {
        return this.expiresOn;
    }

    public Long getExpiresOnUnixTime() {
        return this.expiresOnUnixTime;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public OffsetDateTime getTokenExpiration() {
        return this.tokenExpiry;
    }

    private static OffsetDateTime parseExpiresOnTime(String time) {
        OffsetDateTime tokenExpiry = LocalDateTime.parse(time, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS")).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
        return tokenExpiry;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accessToken", this.accessToken);
        jsonWriter.writeStringField("expiresOn", this.expiresOn);
        jsonWriter.writeNumberField("expires_on", (Number)this.expiresOnUnixTime);
        jsonWriter.writeStringField("subscription", this.subscription);
        jsonWriter.writeStringField("tenant", this.tenant);
        jsonWriter.writeStringField("tokenType", this.tokenType);
        jsonWriter.writeEndObject();
        return jsonWriter;
    }

    public static AzureCliToken fromJson(JsonReader jsonReader) throws IOException {
        return (AzureCliToken)jsonReader.readObject(reader -> {
            AzureCliToken tokenHolder = new AzureCliToken();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessToken".equals(fieldName)) {
                    tokenHolder.accessToken = reader.getString();
                    continue;
                }
                if ("expiresOn".equals(fieldName)) {
                    tokenHolder.expiresOn = reader.getString();
                    continue;
                }
                if ("expires_on".equals(fieldName)) {
                    tokenHolder.expiresOnUnixTime = reader.getLong();
                    continue;
                }
                if ("subscription".equals(fieldName)) {
                    tokenHolder.subscription = reader.getString();
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    tokenHolder.tenant = reader.getString();
                    continue;
                }
                if ("tokenType".equals(fieldName)) {
                    tokenHolder.tokenType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            tokenHolder.tokenExpiry = tokenHolder.expiresOnUnixTime != null ? Instant.ofEpochSecond(tokenHolder.getExpiresOnUnixTime()).atOffset(ZoneOffset.UTC) : AzureCliToken.parseExpiresOnTime(tokenHolder.getExpiresOn());
            return tokenHolder;
        });
    }
}

