/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.common.base.Preconditions;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

class OpenTelemetryApiTracer
implements ApiTracer {
    private final AttributeKey<Long> ATTEMPT_COUNT_KEY = AttributeKey.longKey((String)"attempt.count");
    private final AttributeKey<Long> TOTAL_REQUEST_COUNT_KEY = AttributeKey.longKey((String)"total_request_count");
    private final AttributeKey<Long> TOTAL_RESPONSE_COUNT_KEY = AttributeKey.longKey((String)"total_response_count");
    private final AttributeKey<String> EXCEPTION_MESSAGE_KEY = AttributeKey.stringKey((String)"exception.message");
    private final AttributeKey<Long> ATTEMPT_NUMBER_KEY = AttributeKey.longKey((String)"attempt.number");
    private final AttributeKey<Long> ATTEMPT_REQUEST_COUNT_KEY = AttributeKey.longKey((String)"attempt.request_count");
    private final AttributeKey<Long> ATTEMPT_RESPONSE_COUNT_KEY = AttributeKey.longKey((String)"attempt.response_count");
    private final AttributeKey<String> CONNECTION_ID_KEY = AttributeKey.stringKey((String)"connection");
    private final AttributeKey<Long> RETRY_DELAY_KEY = AttributeKey.longKey((String)"delay_ms");
    private static final AttributeKey<Long> BATCH_SIZE_KEY = AttributeKey.longKey((String)"batch.size");
    private static final AttributeKey<Long> BATCH_COUNT_KEY = AttributeKey.longKey((String)"batch.count");
    private final Span span;
    private final ApiTracerFactory.OperationType operationType;
    private volatile String lastConnectionId;
    private volatile long currentAttemptId;
    private final AtomicLong attemptSentMessages = new AtomicLong(0L);
    private long attemptReceivedMessages = 0L;
    private final AtomicLong totalSentMessages = new AtomicLong(0L);
    private long totalReceivedMessages = 0L;

    OpenTelemetryApiTracer(@Nonnull Span span, @Nonnull ApiTracerFactory.OperationType operationType) {
        this.span = (Span)Preconditions.checkNotNull((Object)span);
        this.operationType = (ApiTracerFactory.OperationType)Preconditions.checkNotNull((Object)operationType);
    }

    Span getSpan() {
        return this.span;
    }

    public ApiTracer.Scope inScope() {
        Scope openTelemetryScope = this.span.makeCurrent();
        return () -> ((Scope)openTelemetryScope).close();
    }

    public void operationSucceeded() {
        this.span.setAllAttributes(this.baseOperationAttributes());
        this.span.setStatus(StatusCode.OK);
        this.span.end();
    }

    public void operationCancelled() {
        this.span.setAllAttributes(this.baseOperationAttributes());
        this.span.setStatus(StatusCode.ERROR, "Cancelled by caller");
        this.span.end();
    }

    public void operationFailed(Throwable error) {
        this.span.setAllAttributes(this.baseOperationAttributes());
        this.span.setStatus(StatusCode.ERROR, error.getMessage());
        this.span.end();
    }

    public void lroStartFailed(Throwable error) {
        this.span.addEvent("Operation failed to start", Attributes.of(this.EXCEPTION_MESSAGE_KEY, (Object)error.getMessage()));
        this.span.setStatus(StatusCode.ERROR, error.getMessage());
        this.span.end();
    }

    public void lroStartSucceeded() {
        this.span.addEvent("Operation started");
    }

    public void connectionSelected(String id) {
        this.lastConnectionId = id;
    }

    public void attemptStarted(int attemptNumber) {
        this.attemptStarted(null, attemptNumber);
    }

    public void attemptStarted(@Nullable Object request, int attemptNumber) {
        this.currentAttemptId = attemptNumber;
        this.attemptSentMessages.set(0L);
        this.attemptReceivedMessages = 0L;
        if (attemptNumber > 0 && this.operationType != ApiTracerFactory.OperationType.LongRunning) {
            this.span.addEvent("Starting RPC retry " + attemptNumber);
        } else if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addEvent("Starting poll attempt " + attemptNumber);
        }
    }

    public void attemptSucceeded() {
        Attributes attributes = this.baseAttemptAttributes();
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addEvent("Polling completed", attributes);
        } else {
            this.span.addEvent("Attempt succeeded", attributes);
        }
    }

    public void attemptCancelled() {
        Attributes attributes = this.baseAttemptAttributes();
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addEvent("Polling was cancelled", attributes);
        } else {
            this.span.addEvent("Attempt cancelled", attributes);
        }
        this.lastConnectionId = null;
    }

    public void attemptFailed(Throwable error, Duration delay) {
        AttributesBuilder builder = this.baseAttemptAttributesBuilder();
        if (delay != null) {
            builder.put(this.RETRY_DELAY_KEY, (Object)delay.toMillis());
        }
        if (error != null) {
            builder.put(this.EXCEPTION_MESSAGE_KEY, (Object)error.getMessage());
        }
        Attributes attributes = builder.build();
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addEvent("Scheduling next poll", attributes);
        } else {
            this.span.addEvent("Attempt failed, scheduling next attempt", attributes);
        }
        this.lastConnectionId = null;
    }

    public void attemptFailedRetriesExhausted(@Nonnull Throwable error) {
        AttributesBuilder builder = this.baseAttemptAttributesBuilder();
        builder.put(this.EXCEPTION_MESSAGE_KEY, (Object)error.getMessage());
        Attributes attributes = builder.build();
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addEvent("Polling attempts exhausted", attributes);
        } else {
            this.span.addEvent("Attempts exhausted", attributes);
        }
        this.lastConnectionId = null;
    }

    public void attemptPermanentFailure(@Nonnull Throwable error) {
        AttributesBuilder builder = this.baseAttemptAttributesBuilder();
        builder.put(this.EXCEPTION_MESSAGE_KEY, (Object)error.getMessage());
        Attributes attributes = builder.build();
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addEvent("Polling failed", attributes);
        } else {
            this.span.addEvent("Attempt failed, error not retryable", attributes);
        }
        this.lastConnectionId = null;
    }

    public void responseReceived() {
        ++this.attemptReceivedMessages;
        ++this.totalReceivedMessages;
    }

    public void requestSent() {
        this.attemptSentMessages.incrementAndGet();
        this.totalSentMessages.incrementAndGet();
    }

    public void batchRequestSent(long elementCount, long requestSize) {
        this.span.setAllAttributes(Attributes.of(BATCH_COUNT_KEY, (Object)elementCount, BATCH_SIZE_KEY, (Object)requestSize));
    }

    private Attributes baseOperationAttributes() {
        AttributesBuilder builder = Attributes.builder();
        builder.put(this.ATTEMPT_COUNT_KEY, (Object)(this.currentAttemptId + 1L));
        long localTotalSentMessages = this.totalSentMessages.get();
        if (localTotalSentMessages > 0L) {
            builder.put(this.TOTAL_REQUEST_COUNT_KEY, (Object)localTotalSentMessages);
        }
        if (this.totalReceivedMessages > 0L) {
            builder.put(this.TOTAL_RESPONSE_COUNT_KEY, (Object)this.totalReceivedMessages);
        }
        return builder.build();
    }

    private Attributes baseAttemptAttributes() {
        return this.baseAttemptAttributesBuilder().build();
    }

    private AttributesBuilder baseAttemptAttributesBuilder() {
        String localLastConnectionId;
        AttributesBuilder builder = Attributes.builder();
        this.populateAttemptNumber(builder);
        long localAttemptSentMessages = this.attemptSentMessages.get();
        if (localAttemptSentMessages > 0L) {
            builder.put(this.ATTEMPT_REQUEST_COUNT_KEY, (Object)localAttemptSentMessages);
        }
        if (this.attemptReceivedMessages > 0L) {
            builder.put(this.ATTEMPT_RESPONSE_COUNT_KEY, (Object)this.attemptReceivedMessages);
        }
        if ((localLastConnectionId = this.lastConnectionId) != null) {
            builder.put(this.CONNECTION_ID_KEY, (Object)localLastConnectionId);
        }
        return builder;
    }

    private void populateAttemptNumber(AttributesBuilder builder) {
        builder.put(this.ATTEMPT_NUMBER_KEY, (Object)this.currentAttemptId);
    }
}

