/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.db2z;

import java.util.Map;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public class DB2ZConfigurationExtension
implements ConfigurationExtension {
    private static final String DATABASE_NAME = "flyway.db2z.databaseName";
    private static final String SQL_ID = "flyway.db2z.sqlId";
    private String databaseName = "";
    private String sqlId = "";

    public String getNamespace() {
        return "db2z";
    }

    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        this.databaseName = configuration.getOrDefault(DATABASE_NAME, this.databaseName);
        this.sqlId = configuration.getOrDefault(SQL_ID, this.sqlId);
        configuration.remove(DATABASE_NAME);
        configuration.remove(SQL_ID);
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        if ("FLYWAY_DB2Z_DATABASE_NAME".equals(environmentVariable)) {
            return DATABASE_NAME;
        }
        if ("FLYWAY_DB2Z_SQL_ID".equals(environmentVariable)) {
            return SQL_ID;
        }
        return null;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setSqlId(String sqlId) {
        this.sqlId = sqlId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DB2ZConfigurationExtension)) {
            return false;
        }
        DB2ZConfigurationExtension other = (DB2ZConfigurationExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$sqlId = this.getSqlId();
        String other$sqlId = other.getSqlId();
        return !(this$sqlId == null ? other$sqlId != null : !this$sqlId.equals(other$sqlId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DB2ZConfigurationExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $sqlId = this.getSqlId();
        result = result * 59 + ($sqlId == null ? 43 : $sqlId.hashCode());
        return result;
    }

    public String toString() {
        return "DB2ZConfigurationExtension(databaseName=" + this.getDatabaseName() + ", sqlId=" + this.getSqlId() + ")";
    }
}

