/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.schemas;

import java.util.ArrayList;
import java.util.Collection;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.verb.VerbUtils;

public class SchemasVerbExtension
implements VerbExtension {
    private static final Log LOG = LogFactory.getLog(SchemasVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "schemas".equals(verb);
    }

    public Object executeVerb(Configuration configuration, FlywayTelemetryManager flywayTelemetryManager) {
        ExperimentalDatabase experimentalDatabase;
        try {
            experimentalDatabase = VerbUtils.getExperimentalDatabase((Configuration)configuration);
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
        ExperimentalModeUtils.logExperimentalDataTelemetry((FlywayTelemetryManager)flywayTelemetryManager, (MetaData)experimentalDatabase.getDatabaseMetaData());
        Collection<String> missingSchemas = this.getMissingSchemas(configuration, experimentalDatabase);
        if (missingSchemas.contains(null)) {
            throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the defaultSchema property!");
        }
        if (missingSchemas.isEmpty()) {
            return null;
        }
        if (configuration.isCreateSchemas()) {
            experimentalDatabase.createSchemas((String[])missingSchemas.toArray(String[]::new));
        }
        SchemaHistoryModel schemaHistoryModel = VerbUtils.getSchemaHistoryModel((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase);
        experimentalDatabase.createSchemaHistoryTableIfNotExists(configuration.getTable());
        if (!missingSchemas.isEmpty()) {
            int installedRank = schemaHistoryModel.calculateInstalledRank((MigrationType)CoreMigrationType.SCHEMA);
            this.createSchemaMarker(experimentalDatabase, configuration, installedRank, missingSchemas);
        }
        return null;
    }

    private Collection<String> getMissingSchemas(Configuration configuration, ExperimentalDatabase experimentalDatabase) {
        ArrayList<String> missingSchemas = new ArrayList<String>();
        String defaultSchema = experimentalDatabase.getDefaultSchema(configuration);
        if (defaultSchema != null && !experimentalDatabase.isSchemaExists(defaultSchema)) {
            missingSchemas.add(defaultSchema);
        }
        for (String schema : configuration.getSchemas()) {
            if (experimentalDatabase.isSchemaExists(schema) || missingSchemas.contains(schema)) continue;
            missingSchemas.add(schema);
        }
        return missingSchemas;
    }

    private void createSchemaMarker(ExperimentalDatabase experimentalDatabase, Configuration configuration, int installedRank, Collection<String> missingSchemas) {
        experimentalDatabase.appendSchemaHistoryItem(SchemaHistoryItem.builder().description("<< Flyway Schema Creation >>").installedRank(installedRank).type("SCHEMA").script(experimentalDatabase.doQuote(String.join((CharSequence)"\",\"", missingSchemas))).installedBy(experimentalDatabase.getInstalledBy(configuration)).executionTime(0).success(true).build(), configuration.getTable());
    }
}

